/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.bm;

import cz.xtf.core.bm.BuildManager;
import cz.xtf.core.config.BuildManagerConfig;
import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildManagers {
    private static final Logger log = LoggerFactory.getLogger(BuildManagers.class);
    private static BuildManager bm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BuildManager get() {
        if (bm != null) return bm;
        Class<BuildManager> clazz = BuildManager.class;
        synchronized (BuildManager.class) {
            if (bm != null) return bm;
            String buildNamespace = BuildManagerConfig.namespace();
            bm = new BuildManager(OpenShifts.master(buildNamespace));
            if (BuildManagerConfig.namespace().equals(OpenShiftConfig.namespace())) return bm;
            OpenShift admin = OpenShifts.admin(buildNamespace);
            try {
                if (admin.getResourceQuota("max-running-builds") != null) return bm;
                ResourceQuota rq = ((ResourceQuotaBuilder)((ResourceQuotaFluent.SpecNested)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName("max-running-builds")).endMetadata()).withNewSpec().addToHard("pods", new Quantity(String.format("%d", BuildManagerConfig.maxRunningBuilds())))).endSpec()).build();
                admin.createResourceQuota(rq);
            }
            catch (KubernetesClientException e) {
                log.warn("Attempt to add hard resource quota on {} namespace failed!", (Object)buildNamespace);
            }
            return bm;
        }
    }
}

