/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.waiting;

import cz.xtf.core.waiting.Waiter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Waiters {
    private static final Logger log = LoggerFactory.getLogger(Waiters.class);

    public static void sleep(TimeUnit timeUnit, long t) {
        Waiters.sleep(timeUnit.toMillis(t));
    }

    public static void sleep(TimeUnit timeUnit, long t, String reason) {
        Waiters.sleep(timeUnit.toMillis(t), reason);
    }

    public static void sleep(TimeUnit timeUnit, long t, String reason, Waiter.LogPoint logPoint) {
        Waiters.sleep(timeUnit.toMillis(t), reason, logPoint);
    }

    public static void sleep(long millis) {
        Waiters.sleep(millis, null, Waiter.LogPoint.NONE);
    }

    public static void sleep(long millis, String reason) {
        Waiters.sleep(millis, reason, Waiter.LogPoint.START);
    }

    public static void sleep(long millis, String reason, Waiter.LogPoint logPoint) {
        try {
            logPoint.logStart(reason, millis);
            Thread.sleep(millis);
            logPoint.logEnd(reason, millis);
        }
        catch (InterruptedException e) {
            log.warn("Interrupted during waiting. Wait reason: {}", (Object)reason, (Object)e);
        }
    }

    private Waiters() {
    }
}

