/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.bm;

import cz.xtf.core.bm.BinaryBuild;
import cz.xtf.core.openshift.OpenShift;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigSpecBuilder;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryBuildFromFile
extends BinaryBuild {
    private static final Logger log = LoggerFactory.getLogger(BinaryBuildFromFile.class);

    public BinaryBuildFromFile(String builderImage, Path path, Map<String, String> envProperties, String id) {
        super(builderImage, path, envProperties, id);
    }

    @Override
    protected void configureBuildStrategy(BuildConfigSpecBuilder builder, String builderImage, List<EnvVar> env) {
        ((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildStrategyFluent.SourceStrategyNested)((BuildStrategyFluent.SourceStrategyNested)((BuildConfigSpecFluent.StrategyNested)builder.withNewStrategy().withType("Source")).withNewSourceStrategy().withEnv(env)).withForcePull(Boolean.valueOf(true))).withNewFrom().withKind("DockerImage")).withName(builderImage)).endFrom()).endSourceStrategy()).endStrategy();
    }

    @Override
    protected String getImage(BuildConfig bc) {
        return bc.getSpec().getStrategy().getSourceStrategy().getFrom().getName();
    }

    @Override
    protected List<EnvVar> getEnv(BuildConfig buildConfig) {
        return buildConfig.getSpec().getStrategy().getSourceStrategy().getEnv();
    }

    @Override
    public void build(OpenShift openShift) {
        openShift.imageStreams().create((Object)this.is);
        openShift.buildConfigs().create((Object)this.bc);
        String fileName = this.getPath().getFileName().toString();
        if (fileName.matches(".*(\\.\\w+)$")) {
            fileName = "ROOT" + fileName.replaceFirst(".*(\\.\\w+)$", "$1");
        }
        ((BuildConfigResource)openShift.buildConfigs().withName(this.bc.getMetadata().getName())).instantiateBinary().asFile(fileName).fromFile(this.getPath().toFile());
    }

    @Override
    protected String getContentHash() {
        if (!this.isCached() || this.contentHash == null) {
            try (InputStream i = Files.newInputStream(this.getPath(), new OpenOption[0]);){
                this.contentHash = Hex.encodeHexString((byte[])DigestUtils.sha256((InputStream)i)).substring(0, 63);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.contentHash;
    }
}

