/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.git;

import cz.xtf.core.git.GitResolver;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JGitResolver
implements GitResolver {
    private static final Logger log = LoggerFactory.getLogger(JGitResolver.class);
    private static final String URL_TEMPLATE = "https://%s/%s/%s";
    private static String reference;
    private static String url;

    public JGitResolver() {
        try {
            JGitResolver.resolveRepoFromHEAD();
        }
        catch (IOException | URISyntaxException e) {
            log.error("Failed to resolve repository from HEAD", (Throwable)e);
            throw new RuntimeException("Failed to resolve repository from HEAD with error: " + e.getMessage());
        }
    }

    private static void resolveRepoFromHEAD() throws IOException, URISyntaxException {
        Repository repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir()).build();
        if (repository == null) {
            log.error("Failed to find a git repository");
            return;
        }
        List<String> matches = JGitResolver.getMatchingRemoteRefs(repository);
        if (matches.isEmpty()) {
            log.error("No remote references found for the current commit");
            return;
        }
        matches = JGitResolver.sortMatches(matches);
        reference = matches.stream().findFirst().map(ref -> ref.substring(ref.lastIndexOf(47) + 1)).orElse(null);
        log.info("xtf.git.repository.ref got automatically resolved as {}", (Object)reference);
        String remote = repository.getRemoteName(matches.get(0));
        url = JGitResolver.getRemoteUrl(repository, remote);
        if (url != null) {
            log.info("xtf.git.repository.url got automatically resolved as {}", (Object)url);
        }
    }

    private static List<String> sortMatches(List<String> matches) {
        List<String> preferredMatches = matches.stream().filter(reference -> reference.contains("upstream") || reference.contains("origin")).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        if (matches.size() > 1 && !preferredMatches.isEmpty()) {
            return preferredMatches;
        }
        return matches;
    }

    private static List<String> getMatchingRemoteRefs(Repository repository) throws IOException {
        ObjectId commitId = repository.resolve("HEAD");
        List allRemoteRefs = repository.getRefDatabase().getRefs().stream().filter(reference -> reference.getName().startsWith("refs/remotes/")).collect(Collectors.toList());
        ArrayList<String> matches = new ArrayList<String>();
        for (Ref ref : allRemoteRefs) {
            if (!ref.getObjectId().equals((AnyObjectId)commitId)) continue;
            matches.add(ref.getName());
        }
        return matches;
    }

    private static String getRemoteUrl(Repository repository, String remoteReference) throws URISyntaxException {
        RemoteConfig remoteConfig = new RemoteConfig((Config)repository.getConfig(), remoteReference);
        if (remoteConfig.getURIs() == null || remoteConfig.getURIs().isEmpty()) {
            log.info("Missing URI in git remote ref '{}'", (Object)remoteReference);
            return null;
        }
        String[] pathTokens = ((URIish)remoteConfig.getURIs().get(0)).getPath().split("/");
        if (pathTokens.length != 2) {
            log.info("Unexpected path '{}' in URI '{}' of git remote ref '{}'", new Object[]{((URIish)remoteConfig.getURIs().get(0)).getPath(), remoteConfig.getURIs().get(0), remoteReference});
            return null;
        }
        return JGitResolver.getRepositoryUrl(((URIish)remoteConfig.getURIs().get(0)).getHost(), pathTokens[0], pathTokens[1]);
    }

    private static String getRepositoryUrl(String host, String remote, String repository) {
        return String.format(URL_TEMPLATE, host, remote, repository);
    }

    @Override
    public String resolveRepoUrl() {
        return url;
    }

    @Override
    public String resolveRepoRef() {
        return reference;
    }
}

