/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.waiting;

import cz.xtf.core.config.WaitingConfig;
import cz.xtf.core.waiting.Waiter;
import cz.xtf.core.waiting.WaiterException;
import cz.xtf.core.waiting.failfast.ExponentialTimeBackoff;
import cz.xtf.core.waiting.failfast.FailFastCheck;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.slf4j.event.Level;

public class SimpleWaiter
implements Waiter {
    private final BooleanSupplier successCondition;
    private BooleanSupplier failureCondition;
    private Runnable onIteration;
    private Runnable onSuccess;
    private Runnable onFailure;
    private Runnable onTimeout;
    private long timeout;
    private long interval;
    private String reason;
    private Waiter.LogPoint logPoint;
    private Level level;
    private FailFastCheck failFast;

    public SimpleWaiter(BooleanSupplier successCondition) {
        this(successCondition, TimeUnit.MILLISECONDS, WaitingConfig.timeout(), null);
    }

    public SimpleWaiter(BooleanSupplier successCondition, String reason) {
        this(successCondition, TimeUnit.MILLISECONDS, WaitingConfig.timeout(), reason);
    }

    public SimpleWaiter(BooleanSupplier successCondition, TimeUnit timeoutUnit, long timeout) {
        this(successCondition, timeoutUnit, timeout, null);
    }

    public SimpleWaiter(BooleanSupplier successCondition, TimeUnit timeoutUnit, long timeout, String reason) {
        this.successCondition = successCondition;
        this.failureCondition = () -> false;
        this.failFast = () -> false;
        this.onIteration = () -> {};
        this.onSuccess = () -> {};
        this.onFailure = () -> {};
        this.onTimeout = () -> {};
        this.timeout = timeoutUnit.toMillis(timeout);
        this.interval = 1000L;
        this.reason = reason;
        this.level = WaitingConfig.level();
        this.logPoint = reason == null ? Waiter.LogPoint.NONE : Waiter.LogPoint.START;
    }

    public SimpleWaiter failureCondition(BooleanSupplier failureCondition) {
        this.failureCondition = failureCondition;
        return this;
    }

    @Override
    public SimpleWaiter timeout(long millis) {
        this.timeout = millis;
        return this;
    }

    @Override
    public SimpleWaiter timeout(TimeUnit timeUnit, long t) {
        this.timeout = timeUnit.toMillis(t);
        return this;
    }

    @Override
    public SimpleWaiter interval(long millis) {
        this.interval = millis;
        return this;
    }

    @Override
    public SimpleWaiter interval(TimeUnit timeUnit, long t) {
        this.interval = timeUnit.toMillis(t);
        return this;
    }

    @Override
    public SimpleWaiter reason(String reason) {
        this.reason = reason;
        this.logPoint = Waiter.LogPoint.START;
        return this;
    }

    @Override
    public SimpleWaiter logPoint(Waiter.LogPoint logPoint) {
        this.logPoint = logPoint;
        return this;
    }

    @Override
    public SimpleWaiter level(Level level) {
        this.level = level;
        return this;
    }

    @Override
    public SimpleWaiter onIteration(Runnable runnable) {
        this.onIteration = runnable;
        return this;
    }

    @Override
    public SimpleWaiter onSuccess(Runnable runnable) {
        this.onSuccess = runnable;
        return this;
    }

    @Override
    public SimpleWaiter onFailure(Runnable runnable) {
        this.onFailure = runnable;
        return this;
    }

    @Override
    public SimpleWaiter failFast(FailFastCheck failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public SimpleWaiter onTimeout(Runnable runnable) {
        this.onTimeout = runnable;
        return this;
    }

    @Override
    public boolean waitFor() {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + this.timeout;
        this.logPoint.logStart(this.reason, this.timeout, this.level);
        ExponentialTimeBackoff backoff = ExponentialTimeBackoff.builder().blocking(false).maxBackoff(32000L).build();
        while (System.currentTimeMillis() < endTime) {
            if (backoff.next() && this.failFast.hasFailed()) {
                this.logPoint.logEnd(this.reason + " (fail fast method failure)", System.currentTimeMillis() - startTime, this.level);
                throw new WaiterException(this.failFast.reason());
            }
            if (this.failureCondition.getAsBoolean()) {
                this.logPoint.logEnd(this.reason + " (Failure)", System.currentTimeMillis() - startTime, this.level);
                this.onFailure.run();
                return false;
            }
            if (this.successCondition.getAsBoolean()) {
                this.logPoint.logEnd(this.reason + " (Success)", System.currentTimeMillis() - startTime, this.level);
                this.onSuccess.run();
                return true;
            }
            this.onIteration.run();
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                throw new WaiterException("Thread has been interrupted!");
            }
        }
        this.logPoint.logEnd(this.reason + " (Time out)", System.currentTimeMillis() - startTime, this.level);
        this.onTimeout.run();
        throw new WaiterException(this.reason);
    }
}

