/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.core.waiting.failfast;

import java.util.Random;

public class ExponentialTimeBackoff {
    private long lastNonBlockingTime;
    private boolean blocking;
    private long maxBackoffMillis;
    private long step;
    private Random random;
    private long nonBlockingWaitMillis;

    private ExponentialTimeBackoff(Builder builder) {
        this.blocking = builder.blocking;
        this.maxBackoffMillis = builder.maxBackoffMillis;
        this.step = 1L;
        this.random = new Random(System.currentTimeMillis());
        this.lastNonBlockingTime = System.currentTimeMillis();
        this.nonBlockingWaitMillis = this.waitMillisForCurrentStep();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean next() {
        return this.blocking ? this.nextBlocking() : this.nextNonBlocking();
    }

    private boolean nextBlocking() {
        try {
            long wait = this.waitMillisForCurrentStep();
            Thread.sleep(wait);
            this.incrementStep();
            return true;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean nextNonBlocking() {
        long now = System.currentTimeMillis();
        if (this.lastNonBlockingTime + this.nonBlockingWaitMillis <= now) {
            this.incrementStep();
            this.nonBlockingWaitMillis = this.waitMillisForCurrentStep();
            this.lastNonBlockingTime = now;
            return true;
        }
        return false;
    }

    private long waitMillisForCurrentStep() {
        if (this.step * 1000L >= this.maxBackoffMillis) {
            return this.maxBackoffMillis + (long)this.random.nextInt(1000);
        }
        return this.step * 1000L + (long)this.random.nextInt(1000);
    }

    private void incrementStep() {
        if (this.step * 1000L < this.maxBackoffMillis) {
            this.step *= 2L;
        }
    }

    public static class Builder {
        static boolean DEFAULT_BLOCKING = false;
        static long DEFAULT_MAX_BACKOFF = 1000L;
        private boolean blocking = DEFAULT_BLOCKING;
        private long maxBackoffMillis = DEFAULT_MAX_BACKOFF;

        private Builder() {
        }

        public Builder blocking(boolean blocking) {
            this.blocking = blocking;
            return this;
        }

        public Builder maxBackoff(long maxBackoffMillis) {
            this.maxBackoffMillis = maxBackoffMillis;
            return this;
        }

        public ExponentialTimeBackoff build() {
            return new ExponentialTimeBackoff(this);
        }
    }
}

