/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.cloud.discovery;

import de.codecentric.boot.admin.server.cloud.discovery.DefaultServiceInstanceConverter;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.util.StringUtils;

public class KubernetesServiceInstanceConverter
extends DefaultServiceInstanceConverter {
    public static final String MANAGEMENT_PORT_NAME = "management";
    private final String portsPrefix;

    public KubernetesServiceInstanceConverter(KubernetesDiscoveryProperties discoveryProperties) {
        this.portsPrefix = discoveryProperties.metadata() != null && discoveryProperties.metadata().portsPrefix() != null ? discoveryProperties.metadata().portsPrefix() : "";
    }

    @Override
    protected int getManagementPort(ServiceInstance instance) {
        String managementPort = KubernetesServiceInstanceConverter.getMetadataValue(instance, this.portsPrefix + MANAGEMENT_PORT_NAME, MANAGEMENT_PORT_NAME);
        if (StringUtils.hasText((String)managementPort)) {
            return Integer.parseInt(managementPort);
        }
        return super.getManagementPort(instance);
    }
}

