/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.common;

import de.flapdoodle.os.common.AllOf;
import de.flapdoodle.os.common.Peculiarity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AllOf", generator="Immutables")
public final class ImmutableAllOf
extends AllOf {
    private final List<Peculiarity> pecularities;

    private ImmutableAllOf(Iterable<? extends Peculiarity> pecularities) {
        this.pecularities = ImmutableAllOf.createUnmodifiableList(false, ImmutableAllOf.createSafeList(pecularities, true, false));
    }

    private ImmutableAllOf(ImmutableAllOf original, List<Peculiarity> pecularities) {
        this.pecularities = pecularities;
    }

    @Override
    public List<Peculiarity> pecularities() {
        return this.pecularities;
    }

    public final ImmutableAllOf withPecularities(Peculiarity ... elements) {
        List<Peculiarity> newValue = ImmutableAllOf.createUnmodifiableList(false, ImmutableAllOf.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableAllOf.validate(new ImmutableAllOf(this, newValue));
    }

    public final ImmutableAllOf withPecularities(Iterable<? extends Peculiarity> elements) {
        if (this.pecularities == elements) {
            return this;
        }
        List<Peculiarity> newValue = ImmutableAllOf.createUnmodifiableList(false, ImmutableAllOf.createSafeList(elements, true, false));
        return ImmutableAllOf.validate(new ImmutableAllOf(this, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAllOf && this.equalTo(0, (ImmutableAllOf)another);
    }

    private boolean equalTo(int synthetic, ImmutableAllOf another) {
        return this.pecularities.equals(another.pecularities);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pecularities.hashCode();
        return h;
    }

    public String toString() {
        return "AllOf{pecularities=" + this.pecularities + "}";
    }

    public static ImmutableAllOf of(List<Peculiarity> pecularities) {
        return ImmutableAllOf.of(pecularities);
    }

    public static ImmutableAllOf of(Iterable<? extends Peculiarity> pecularities) {
        return ImmutableAllOf.validate(new ImmutableAllOf(pecularities));
    }

    private static ImmutableAllOf validate(ImmutableAllOf instance) {
        instance.check();
        return instance;
    }

    public static ImmutableAllOf copyOf(AllOf instance) {
        if (instance instanceof ImmutableAllOf) {
            return (ImmutableAllOf)instance;
        }
        return ImmutableAllOf.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AllOf", generator="Immutables")
    public static final class Builder {
        private List<Peculiarity> pecularities = new ArrayList<Peculiarity>();

        private Builder() {
        }

        public final Builder from(AllOf instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllPecularities(instance.pecularities());
            return this;
        }

        public final Builder addPecularities(Peculiarity element) {
            this.pecularities.add(Objects.requireNonNull(element, "pecularities element"));
            return this;
        }

        public final Builder addPecularities(Peculiarity ... elements) {
            for (Peculiarity element : elements) {
                this.pecularities.add(Objects.requireNonNull(element, "pecularities element"));
            }
            return this;
        }

        public final Builder pecularities(Iterable<? extends Peculiarity> elements) {
            this.pecularities.clear();
            return this.addAllPecularities(elements);
        }

        public final Builder addAllPecularities(Iterable<? extends Peculiarity> elements) {
            for (Peculiarity peculiarity : elements) {
                this.pecularities.add(Objects.requireNonNull(peculiarity, "pecularities element"));
            }
            return this;
        }

        public ImmutableAllOf build() {
            return ImmutableAllOf.validate(new ImmutableAllOf(null, ImmutableAllOf.createUnmodifiableList(true, this.pecularities)));
        }
    }
}

