/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.spring.boot.v3.autoconfig;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import migratedb.v1.core.MigrateDb;
import migratedb.v1.core.api.ExtensionConfig;
import migratedb.v1.core.api.MigrateDbExtension;
import migratedb.v1.core.api.MigrationPattern;
import migratedb.v1.core.api.TargetVersion;
import migratedb.v1.core.api.Version;
import migratedb.v1.core.api.callback.Callback;
import migratedb.v1.core.api.configuration.Configuration;
import migratedb.v1.core.api.configuration.DefaultConfiguration;
import migratedb.v1.core.api.migration.JavaMigration;
import migratedb.v1.spring.boot.v3.autoconfig.ConflictingDataSourcesException;
import migratedb.v1.spring.boot.v3.autoconfig.DefaultMigrateDbExecution;
import migratedb.v1.spring.boot.v3.autoconfig.DerivedDataSource;
import migratedb.v1.spring.boot.v3.autoconfig.MigrateDbConfigurationCustomizer;
import migratedb.v1.spring.boot.v3.autoconfig.MigrateDbDataSource;
import migratedb.v1.spring.boot.v3.autoconfig.MigrateDbExecution;
import migratedb.v1.spring.boot.v3.autoconfig.MigrateDbInitializer;
import migratedb.v1.spring.boot.v3.autoconfig.MigrateDbProperties;
import migratedb.v1.spring.boot.v3.autoconfig.MigrateDbSchemaManagementProvider;
import migratedb.v1.spring.boot.v3.autoconfig.MissingApplicationDataSourceException;
import migratedb.v1.spring.boot.v3.autoconfig.SpringIntegration;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ResourceLoader;

@AutoConfiguration(after={DataSourceAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
@EnableConfigurationProperties(value={MigrateDbProperties.class})
@Import(value={DatabaseInitializationDependencyConfigurer.class})
@ConditionalOnClass(value={MigrateDb.class})
@Conditional(value={MigrateDbDataSourceCondition.class})
@ConditionalOnProperty(prefix="migratedb", name={"enabled"}, matchIfMissing=true)
public class MigrateDbAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MigrateDb migrateDb(ResourceLoader resourceLoader, ObjectProvider<DataSource> applicationDataSource, @MigrateDbDataSource ObjectProvider<DataSource> migrateDbDataSource, ObjectProvider<MigrateDbProperties> properties, ObjectProvider<MigrateDbConfigurationCustomizer> configurationCustomizers, ObjectProvider<JavaMigration> javaMigrations, ObjectProvider<Callback> callbacks, ObjectProvider<MigrateDbExtension> extensions, ObjectProvider<ExtensionConfig> extensionConfigs) {
        DefaultConfiguration configuration = new DefaultConfiguration(resourceLoader.getClassLoader());
        MigrateDbProperties propertiesIfUnique = (MigrateDbProperties)properties.getIfUnique();
        DataSource dataSource = this.configureDataSource(configuration, propertiesIfUnique, (DataSource)applicationDataSource.getIfUnique(), (DataSource)migrateDbDataSource.getIfUnique());
        this.configureFromProperties(configuration, propertiesIfUnique);
        this.configureExtensions(resourceLoader, configuration, propertiesIfUnique, extensions, extensionConfigs);
        this.configureCallbacks(configuration, callbacks);
        this.configureJavaMigrations(configuration, javaMigrations);
        this.configureCustomizers(configuration, configurationCustomizers);
        configuration.setExtensionConfig(SpringIntegration.class, (ExtensionConfig)new SpringIntegration(dataSource));
        return new MigrateDb((Configuration)configuration);
    }

    @Bean
    public MigrateDbSchemaManagementProvider migrateDbSchemaManagementProvider(ObjectProvider<MigrateDb> migrateDb) {
        return new MigrateDbSchemaManagementProvider(migrateDb);
    }

    @Bean
    @ConditionalOnMissingBean
    public MigrateDbInitializer migrateDbInitializer(MigrateDb migrateDb, MigrateDbExecution migrateDbExecution) {
        return new MigrateDbInitializer(migrateDb, migrateDbExecution);
    }

    @Bean
    @ConditionalOnMissingBean
    public MigrateDbExecution migrateDbExecution(ObjectProvider<MigrateDbProperties> migrateDbProperties) {
        return new DefaultMigrateDbExecution((MigrateDbProperties)migrateDbProperties.getIfUnique());
    }

    private void configureFromProperties(DefaultConfiguration configuration, @Nullable MigrateDbProperties props) {
        if (props == null) {
            return;
        }
        PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        mapper.from(props::getBaselineDescription).to(arg_0 -> ((DefaultConfiguration)configuration).setBaselineDescription(arg_0));
        mapper.from(props::getBaselineMigrationPrefix).to(arg_0 -> ((DefaultConfiguration)configuration).setBaselineMigrationPrefix(arg_0));
        mapper.from(props::getBaselineOnMigrate).to(arg_0 -> ((DefaultConfiguration)configuration).setBaselineOnMigrate(arg_0));
        mapper.from(props::getBaselineVersion).as(Version::parse).to(arg_0 -> ((DefaultConfiguration)configuration).setBaselineVersion(arg_0));
        mapper.from(props.getCherryPick()).as(it -> it.stream().map(MigrationPattern::new).collect(Collectors.toUnmodifiableList())).to(arg_0 -> ((DefaultConfiguration)configuration).setCherryPick(arg_0));
        mapper.from((Object)props.getConnectRetries()).to(arg_0 -> ((DefaultConfiguration)configuration).setConnectRetries(arg_0));
        mapper.from((Object)props.getConnectRetriesInterval()).as(Duration::toSeconds).as(MigrateDbAutoConfiguration::saturatedCastToInt).to(arg_0 -> ((DefaultConfiguration)configuration).setConnectRetriesInterval(arg_0));
        mapper.from(props::getCreateSchemas).to(arg_0 -> ((DefaultConfiguration)configuration).setCreateSchemas(arg_0));
        mapper.from(props::getDefaultSchema).to(arg_0 -> ((DefaultConfiguration)configuration).setDefaultSchema(arg_0));
        mapper.from(props::getEncoding).to(arg_0 -> ((DefaultConfiguration)configuration).setEncoding(arg_0));
        mapper.from(props::getFailOnMissingLocations).to(arg_0 -> ((DefaultConfiguration)configuration).setFailOnMissingLocations(arg_0));
        mapper.from(props::getFailOnMissingTarget).to(arg_0 -> ((DefaultConfiguration)configuration).setFailOnMissingTarget(arg_0));
        mapper.from(props::getGroup).to(arg_0 -> ((DefaultConfiguration)configuration).setGroup(arg_0));
        mapper.from(props::getIgnoreFutureMigrations).to(arg_0 -> ((DefaultConfiguration)configuration).setIgnoreFutureMigrations(arg_0));
        mapper.from(props::getIgnoreMigrationPatterns).to(arg_0 -> ((DefaultConfiguration)configuration).setIgnoreMigrationPatterns(arg_0));
        mapper.from(props::getIgnoreMissingMigrations).to(arg_0 -> ((DefaultConfiguration)configuration).setIgnoreMissingMigrations(arg_0));
        mapper.from(props::getIgnorePendingMigrations).to(arg_0 -> ((DefaultConfiguration)configuration).setIgnorePendingMigrations(arg_0));
        mapper.from(props::getInitSql).to(arg_0 -> ((DefaultConfiguration)configuration).setInitSql(arg_0));
        mapper.from(props::getInstalledBy).to(arg_0 -> ((DefaultConfiguration)configuration).setInstalledBy(arg_0));
        mapper.from(props::getLiberateOnMigrate).to(arg_0 -> ((DefaultConfiguration)configuration).setLiberateOnMigrate(arg_0));
        mapper.from(props::getLocations).to(arg_0 -> ((DefaultConfiguration)configuration).setLocationsAsStrings(arg_0));
        mapper.from(props::getLockRetryCount).to(arg_0 -> ((DefaultConfiguration)configuration).setLockRetryCount(arg_0));
        mapper.from(props::getMixed).to(arg_0 -> ((DefaultConfiguration)configuration).setMixed(arg_0));
        mapper.from(props::getOldTable).to(arg_0 -> ((DefaultConfiguration)configuration).setOldTable(arg_0));
        mapper.from(props::getOutOfOrder).to(arg_0 -> ((DefaultConfiguration)configuration).setOutOfOrder(arg_0));
        mapper.from(props::getOutputQueryResults).to(arg_0 -> ((DefaultConfiguration)configuration).setOutputQueryResults(arg_0));
        mapper.from(props::getPlaceholderPrefix).to(arg_0 -> ((DefaultConfiguration)configuration).setPlaceholderPrefix(arg_0));
        mapper.from(props::getPlaceholderReplacement).to(arg_0 -> ((DefaultConfiguration)configuration).setPlaceholderReplacement(arg_0));
        mapper.from(props::getPlaceholders).to(arg_0 -> ((DefaultConfiguration)configuration).setPlaceholders(arg_0));
        mapper.from(props::getPlaceholderSuffix).to(arg_0 -> ((DefaultConfiguration)configuration).setPlaceholderSuffix(arg_0));
        mapper.from(props::getRepeatableSqlMigrationPrefix).to(arg_0 -> ((DefaultConfiguration)configuration).setRepeatableSqlMigrationPrefix(arg_0));
        mapper.from(props::getSchemas).to(arg_0 -> ((DefaultConfiguration)configuration).setSchemas(arg_0));
        mapper.from(props::getScriptPlaceholderPrefix).to(arg_0 -> ((DefaultConfiguration)configuration).setScriptPlaceholderPrefix(arg_0));
        mapper.from(props::getScriptPlaceholderSuffix).to(arg_0 -> ((DefaultConfiguration)configuration).setScriptPlaceholderSuffix(arg_0));
        mapper.from(props::getSkipDefaultCallbacks).to(arg_0 -> ((DefaultConfiguration)configuration).setSkipDefaultCallbacks(arg_0));
        mapper.from(props::getSkipDefaultResolvers).to(arg_0 -> ((DefaultConfiguration)configuration).setSkipDefaultResolvers(arg_0));
        mapper.from(props::getSkipExecutingMigrations).to(arg_0 -> ((DefaultConfiguration)configuration).setSkipExecutingMigrations(arg_0));
        mapper.from(props::getSqlMigrationPrefix).to(arg_0 -> ((DefaultConfiguration)configuration).setSqlMigrationPrefix(arg_0));
        mapper.from(props::getSqlMigrationSeparator).to(arg_0 -> ((DefaultConfiguration)configuration).setSqlMigrationSeparator(arg_0));
        mapper.from(props::getSqlMigrationSuffixes).to(arg_0 -> ((DefaultConfiguration)configuration).setSqlMigrationSuffixes(arg_0));
        mapper.from(props::getTable).to(arg_0 -> ((DefaultConfiguration)configuration).setTable(arg_0));
        mapper.from(props::getTablespace).to(arg_0 -> ((DefaultConfiguration)configuration).setTablespace(arg_0));
        mapper.from(props::getTarget).as(TargetVersion::parse).to(arg_0 -> ((DefaultConfiguration)configuration).setTarget(arg_0));
        mapper.from(props::getValidateMigrationNaming).to(arg_0 -> ((DefaultConfiguration)configuration).setValidateMigrationNaming(arg_0));
        mapper.from(props::getValidateOnMigrate).to(arg_0 -> ((DefaultConfiguration)configuration).setValidateOnMigrate(arg_0));
    }

    private void configureExtensions(ResourceLoader resourceLoader, DefaultConfiguration configuration, @Nullable MigrateDbProperties props, ObjectProvider<MigrateDbExtension> extensions, ObjectProvider<ExtensionConfig> extensionConfigs) {
        extensions.forEach(arg_0 -> ((DefaultConfiguration)configuration).useExtension(arg_0));
        if (props != null && props.isUseServiceLoader()) {
            MigrateDbAutoConfiguration.addExtensionsFromServiceLoader(resourceLoader, configuration);
        }
        if (props != null && props.getExtensionConfig() != null) {
            HashMap extensionConfigAsProperties = new HashMap();
            props.getExtensionConfig().forEach((key, value) -> extensionConfigAsProperties.put("migratedb." + key, value));
            configuration.configure(extensionConfigAsProperties);
        }
        extensionConfigs.forEach(it -> configuration.setExtensionConfig(it.getClass().asSubclass(ExtensionConfig.class), it));
    }

    private static void addExtensionsFromServiceLoader(ResourceLoader resourceLoader, DefaultConfiguration configuration) {
        ClassLoader classLoader = resourceLoader.getClassLoader();
        ServiceLoader<MigrateDbExtension> serviceLoader = classLoader == null ? ServiceLoader.load(MigrateDbExtension.class) : ServiceLoader.load(MigrateDbExtension.class, classLoader);
        configuration.useExtensions(serviceLoader);
    }

    private void configureCustomizers(DefaultConfiguration configuration, ObjectProvider<MigrateDbConfigurationCustomizer> configurationCustomizers) {
        configurationCustomizers.orderedStream().forEach(customizer -> customizer.customize(configuration));
    }

    private @Nullable DataSource configureDataSource(DefaultConfiguration configuration, @Nullable MigrateDbProperties properties, @Nullable DataSource applicationDataSource, @Nullable DataSource migrateDbDataSource) {
        if (configuration.getDataSource() != null) {
            throw new IllegalStateException("MigrateDB configuration already has a data source set, which is unexpected");
        }
        Map<String, Supplier<DataSource>> specializedDataSourcesByName = this.describeSpecializedMigrationDataSources(properties, applicationDataSource, migrateDbDataSource);
        DataSource singleSpecializedDataSource = this.takeSingleDataSourceOrThrow(specializedDataSourcesByName);
        if (singleSpecializedDataSource != null) {
            configuration.setDataSource(singleSpecializedDataSource);
            return singleSpecializedDataSource;
        }
        if (applicationDataSource != null) {
            configuration.setDataSource(applicationDataSource);
            return applicationDataSource;
        }
        return null;
    }

    private Map<String, @Nullable Supplier<DataSource>> describeSpecializedMigrationDataSources(@Nullable MigrateDbProperties properties, @Nullable DataSource applicationDataSource, @Nullable DataSource migrateDbDataSource) {
        LinkedHashMap<String, Supplier<DataSource>> dataSourcesByName = new LinkedHashMap<String, Supplier<DataSource>>();
        dataSourcesByName.put("@" + MigrateDbDataSource.class.getSimpleName() + " bean", this.asDataSourceSupplier(migrateDbDataSource));
        DataSourceBuilder springPropertiesDataSource = Optional.ofNullable(properties).map(MigrateDbProperties::getDataSource).map(DataSourceProperties::initializeDataSourceBuilder).orElse(null);
        dataSourcesByName.put("Spring properties data source [migratedb.data-source]", this.asDataSourceSupplier(springPropertiesDataSource));
        if (properties != null && properties.getUser() != null) {
            if (applicationDataSource == null) {
                throw new MissingApplicationDataSourceException();
            }
            DerivedDataSource derivedDataSource = new DerivedDataSource(applicationDataSource, properties.getUser(), properties.getPassword());
            dataSourcesByName.put("Data source derived from application data source using credentials [migratedb.(user,password)]", this.asDataSourceSupplier(derivedDataSource));
        }
        return dataSourcesByName;
    }

    private @Nullable DataSource takeSingleDataSourceOrThrow(Map<String, @Nullable Supplier<DataSource>> dataSourcesByName) {
        Supplier<DataSource> result = null;
        ArrayList<String> eligibleDataSources = new ArrayList<String>();
        for (Map.Entry<String, Supplier<DataSource>> entry : dataSourcesByName.entrySet()) {
            String name = entry.getKey();
            Supplier<DataSource> dataSourceSupplier = entry.getValue();
            if (dataSourceSupplier == null) continue;
            eligibleDataSources.add(name);
            result = dataSourceSupplier;
        }
        if (eligibleDataSources.size() > 1) {
            throw new ConflictingDataSourcesException(eligibleDataSources);
        }
        return result == null ? null : (DataSource)result.get();
    }

    private @Nullable Supplier<DataSource> asDataSourceSupplier(@Nullable DataSource dataSource) {
        return dataSource == null ? null : () -> dataSource;
    }

    private @Nullable Supplier<DataSource> asDataSourceSupplier(@Nullable DataSourceBuilder<?> builder) {
        if (builder == null) {
            return null;
        }
        DataSource[] dataSource = new DataSource[]{null};
        return () -> {
            if (dataSource[0] == null) {
                dataSource[0] = builder.build();
            }
            return dataSource[0];
        };
    }

    private void configureCallbacks(DefaultConfiguration configuration, ObjectProvider<Callback> callbacks) {
        Callback[] callbacksArray = (Callback[])callbacks.orderedStream().toArray(Callback[]::new);
        if (callbacksArray.length > 0) {
            configuration.setCallbacks(callbacksArray);
        }
    }

    private void configureJavaMigrations(DefaultConfiguration configuration, ObjectProvider<JavaMigration> migrations) {
        JavaMigration[] migrationsArray = (JavaMigration[])migrations.orderedStream().toArray(JavaMigration[]::new);
        if (migrationsArray.length > 0) {
            configuration.setJavaMigrations(migrationsArray);
        }
    }

    private static Integer saturatedCastToInt(Long it) {
        return it > Integer.MAX_VALUE ? Integer.MAX_VALUE : (it < Integer.MIN_VALUE ? Integer.MIN_VALUE : it.intValue());
    }

    static final class MigrateDbDataSourceCondition
    extends AnyNestedCondition {
        MigrateDbDataSourceCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="migratedb.data-source", name={"url"})
        static final class UrlCondition {
            UrlCondition() {
            }
        }

        @ConditionalOnBean(value={DataSource.class})
        static final class DataSourceBeanCondition {
            DataSourceBeanCondition() {
            }
        }
    }
}

