/*
 * Decompiled with CFR 0.152.
 */
package migratedb.v1.spring.boot.v3.autoconfig;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ConnectionBuilder;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.ShardingKeyBuilder;
import java.util.Objects;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.Nullable;

final class DerivedDataSource
implements DataSource {
    private final DataSource delegate;
    private final String user;
    private final @Nullable String password;

    DerivedDataSource(DataSource delegate, String user, @Nullable String password) {
        this.delegate = Objects.requireNonNull(delegate);
        this.user = Objects.requireNonNull(user);
        this.password = password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.delegate.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public ConnectionBuilder createConnectionBuilder() throws SQLException {
        return this.delegate.createConnectionBuilder();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    @Override
    public ShardingKeyBuilder createShardingKeyBuilder() throws SQLException {
        return this.delegate.createShardingKeyBuilder();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == DataSource.class) {
            return (T)this.delegate;
        }
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == DataSource.class || this.delegate.isWrapperFor(iface);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DerivedDataSource other = (DerivedDataSource)o;
        return Objects.equals(this.delegate, other.delegate) && Objects.equals(this.user, other.user) && Objects.equals(this.password, other.password);
    }

    public int hashCode() {
        return Objects.hash(this.delegate, this.user, this.password);
    }

    public String toString() {
        return "DerivedDataSource{delegate=" + this.delegate + "}";
    }
}

