/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import com.diffplug.common.swt.os.SwtPlatform;
import dev.equo.solstice.p2.CacheLocations;
import dev.equo.solstice.p2.P2Client;
import dev.equo.solstice.p2.P2ClientCache;
import dev.equo.solstice.p2.P2Query;
import dev.equo.solstice.p2.P2QueryCache;
import dev.equo.solstice.p2.P2QueryResult;
import dev.equo.solstice.p2.P2Session;
import dev.equo.solstice.p2.QueryCacheOnDisk;
import dev.equo.solstice.p2.Unchecked;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;

public class P2Model {
    private final TreeSet<String> p2repo = new TreeSet();
    private final TreeSet<String> install = new TreeSet();
    private final TreeMap<String, Filter> filters = new TreeMap();
    public static final String WILDCARD = "*";
    private static final String OSGI_OS = "osgi.os";
    private static final String OSGI_WS = "osgi.ws";
    private static final String OSGI_ARCH = "osgi.arch";

    public TreeSet<String> getP2repo() {
        return this.p2repo;
    }

    public TreeSet<String> getInstall() {
        return this.install;
    }

    public TreeMap<String, Filter> getFilters() {
        return this.filters;
    }

    public boolean isEmpty() {
        return this.p2repo.isEmpty() && this.install.isEmpty() && this.filters.isEmpty();
    }

    public void addP2Repo(String p2url) {
        if (!p2url.endsWith("/")) {
            throw new IllegalArgumentException("Must end with /\n  " + p2url + "   <- WRONG\n  " + p2url + "/  <- CORRECT\n");
        }
        if (p2url.endsWith("//")) {
            throw new IllegalArgumentException("Must end with a single /\n  " + p2url + "  <- WRONG\n  " + p2url.substring(0, p2url.length() - 1) + "   <- CORRECT\n");
        }
        this.p2repo.add(p2url);
    }

    public void applyNativeFilterIfNoPlatformFilter() {
        boolean hasAnyPlatformFilter = this.filters.values().stream().anyMatch(filter -> filter.props.containsKey(OSGI_OS) || filter.props.containsKey(OSGI_WS) || filter.props.containsKey(OSGI_ARCH));
        if (!hasAnyPlatformFilter) {
            this.addFilterAndValidate("platform-specific-for-running", new Filter().platformRunning());
        }
    }

    public P2Model deepCopy() {
        P2Model deepCopy = new P2Model();
        deepCopy.p2repo.addAll(this.p2repo);
        deepCopy.install.addAll(this.install);
        for (Map.Entry<String, Filter> filterEntry : this.filters.entrySet()) {
            deepCopy.filters.put(filterEntry.getKey(), filterEntry.getValue().deepCopy());
        }
        return deepCopy;
    }

    public P2Query queryRaw(P2ClientCache cachingPolicy) throws Exception {
        this.validateFilters();
        P2Session session = new P2Session();
        try (P2Client client = new P2Client(cachingPolicy);){
            for (String repo : this.p2repo) {
                session.populateFrom(client, repo);
            }
        }
        P2Query query = session.query();
        for (Filter filter : this.filters.values()) {
            filter.exclude.forEach(query::exclude);
            filter.excludePrefix.forEach(query::excludePrefix);
            filter.excludeSuffix.forEach(query::excludeSuffix);
            for (Map.Entry<String, String> prop : filter.getProps().entrySet()) {
                if (WILDCARD.equals(prop.getValue())) continue;
                query.filterProp(prop.getKey(), prop.getValue());
            }
        }
        for (String target : this.install) {
            query.install(target);
        }
        return query;
    }

    public P2QueryResult query(P2ClientCache clientCachingPolicy, P2QueryCache queryCachingPolicy) {
        QueryCacheOnDisk onDisk;
        P2QueryResult queryResult;
        if (queryCachingPolicy.allowRead() && (queryResult = (onDisk = new QueryCacheOnDisk(CacheLocations.p2Queries(), this)).get()) != null) {
            return queryResult;
        }
        try {
            P2Query query = this.queryRaw(clientCachingPolicy);
            queryResult = new P2QueryResult(query, clientCachingPolicy);
            if (queryCachingPolicy.allowWrite()) {
                QueryCacheOnDisk onDisk2 = new QueryCacheOnDisk(CacheLocations.p2Queries(), this);
                onDisk2.put(queryResult);
            }
            return queryResult;
        }
        catch (Exception e) {
            throw Unchecked.wrap(e);
        }
    }

    public void validateFilters() {
        ArrayList<Map.Entry<String, Filter>> entryList = new ArrayList<Map.Entry<String, Filter>>(this.filters.entrySet());
        for (int i = 0; i < entryList.size(); ++i) {
            Map.Entry<String, Filter> first = entryList.get(i);
            for (int j = i + 1; j < entryList.size(); ++j) {
                Map.Entry<String, Filter> second = entryList.get(j);
                String conflictMsg = first.getValue().conflictsWith(first.getKey(), second.getKey(), second.getValue());
                if (conflictMsg == null) continue;
                throw new IllegalArgumentException(conflictMsg);
            }
        }
    }

    public void addFilterAndValidate(String filterName, Consumer<Filter> filterSetup) {
        Filter filter = new Filter();
        filterSetup.accept(filter);
        this.addFilterAndValidate(filterName, filter);
    }

    public void addFilterAndValidate(String filterName, Filter filter) {
        Filter existingForThisName = this.filters.get(filterName);
        if (existingForThisName != null) {
            if (existingForThisName.equals(filter)) {
                return;
            }
            throw new IllegalArgumentException("We already have a filter named " + filterName + "\n   existing: " + existingForThisName + "\n  attempted: " + filter + "\nYou can fix this by removing or renaming one of the filters.");
        }
        for (Map.Entry<String, Filter> existing : this.filters.entrySet()) {
            String conflictMsg = filter.conflictsWith(filterName, existing.getKey(), existing.getValue());
            if (conflictMsg == null) continue;
            throw new IllegalArgumentException(conflictMsg);
        }
        this.filters.put(filterName, filter);
    }

    public void removeFilter(String name) {
        Filter existing = this.filters.remove(name);
        if (existing == null) {
            throw new IllegalArgumentException("You tried to remove a filter with name '" + name + "' but no such filter exists");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        if (!this.p2repo.isEmpty()) {
            P2Model.appendSet(buf, "p2repo", this.p2repo);
        }
        if (!this.install.isEmpty()) {
            P2Model.appendSet(buf, "install", this.install);
        }
        if (!this.filters.isEmpty()) {
            String START___ = "filters: { '";
            String START = ",\n            '";
            boolean isFirst = true;
            for (Map.Entry<String, Filter> entry : this.filters.entrySet()) {
                String lead;
                if (isFirst) {
                    lead = START___;
                    isFirst = false;
                } else {
                    lead = START;
                }
                buf.append(lead + entry.getKey() + "': " + entry.getValue());
            }
            buf.append(" },\n");
        }
        return P2Model.closeJson(buf);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        P2Model model = (P2Model)o;
        return this.p2repo.equals(model.p2repo) && this.install.equals(model.install) && this.filters.equals(model.filters);
    }

    public int hashCode() {
        return Objects.hash(this.p2repo, this.install, this.filters);
    }

    private static void appendSet(StringBuilder buf, String name, Set<String> toAdd) {
        buf.append(name);
        buf.append(": ['");
        buf.append(String.join((CharSequence)"', '", toAdd));
        buf.append("'],\n");
    }

    private static String closeJson(StringBuilder buf) {
        if (buf.charAt(buf.length() - 1) == '\n') {
            buf.setLength(buf.length() - 1);
            buf.setCharAt(buf.length() - 1, '}');
        } else {
            buf.append('}');
        }
        return buf.toString();
    }

    public static class Filter {
        private final TreeSet<String> exclude = new TreeSet();
        private final TreeSet<String> excludePrefix = new TreeSet();
        private final TreeSet<String> excludeSuffix = new TreeSet();
        private final TreeMap<String, String> props = new TreeMap();

        public static Filter create(Consumer<Filter> filter) {
            Filter f = new Filter();
            filter.accept(f);
            return f;
        }

        public Filter deepCopy() {
            Filter deepCopy = new Filter();
            deepCopy.exclude.addAll(this.exclude);
            deepCopy.excludePrefix.addAll(this.excludePrefix);
            deepCopy.excludeSuffix.addAll(this.excludeSuffix);
            deepCopy.props.putAll(this.props);
            return deepCopy;
        }

        public TreeSet<String> getExclude() {
            return this.exclude;
        }

        public Filter exclude(String unit) {
            this.exclude.add(unit);
            return this;
        }

        public TreeSet<String> getExcludePrefix() {
            return this.excludePrefix;
        }

        public Filter excludePrefix(String prefix) {
            this.excludePrefix.add(prefix);
            return this;
        }

        public TreeSet<String> getExcludeSuffix() {
            return this.excludeSuffix;
        }

        public Filter excludeSuffix(String suffix) {
            this.excludeSuffix.add(suffix);
            return this;
        }

        public TreeMap<String, String> getProps() {
            return this.props;
        }

        public Filter prop(String key, String value) {
            this.props.put(key, value);
            return this;
        }

        public Filter platformAll() {
            this.props.put(P2Model.OSGI_OS, P2Model.WILDCARD);
            this.props.put(P2Model.OSGI_WS, P2Model.WILDCARD);
            this.props.put(P2Model.OSGI_ARCH, P2Model.WILDCARD);
            return this;
        }

        public Filter platformNone() {
            this.props.put(P2Model.OSGI_OS, "dont-include-platform-specific-artifacts");
            this.props.put(P2Model.OSGI_WS, "dont-include-platform-specific-artifacts");
            this.props.put(P2Model.OSGI_ARCH, "dont-include-platform-specific-artifacts");
            return this;
        }

        public Filter platform(SwtPlatform platform) {
            this.props.put(P2Model.OSGI_OS, platform.getOs());
            this.props.put(P2Model.OSGI_WS, platform.getWs());
            this.props.put(P2Model.OSGI_ARCH, platform.getArch());
            return this;
        }

        public Filter platformNative() {
            return this.platform(SwtPlatform.getNative());
        }

        public Filter platformRunning() {
            return this.platform(SwtPlatform.getRunning());
        }

        public String conflictsWith(String nameThis, String nameOther, Filter other) {
            for (Map.Entry<String, String> prop : this.props.entrySet()) {
                String otherVal = other.getProps().get(prop.getKey());
                if (otherVal == null && !other.getProps().containsKey(prop.getKey()) || Objects.equals(prop.getValue(), otherVal)) continue;
                return "conflict for prop " + prop.getKey() + "! " + nameThis + " has " + prop.getValue() + " but " + nameOther + " has " + otherVal;
            }
            return null;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append('{');
            if (!this.exclude.isEmpty()) {
                P2Model.appendSet(buf, "exclude", this.exclude);
            }
            if (!this.excludePrefix.isEmpty()) {
                P2Model.appendSet(buf, "excludePrefix", this.excludePrefix);
            }
            if (!this.excludeSuffix.isEmpty()) {
                P2Model.appendSet(buf, "excludeSuffix", this.excludeSuffix);
            }
            if (!this.props.isEmpty()) {
                String START___ = "props: { '";
                String START = ",\n          '";
                boolean isFirst = true;
                for (Map.Entry<String, String> entry : this.props.entrySet()) {
                    String lead;
                    if (isFirst) {
                        lead = START___;
                        isFirst = false;
                    } else {
                        lead = START;
                    }
                    buf.append(lead + entry.getKey() + "': '" + entry.getValue() + "'");
                }
                buf.append(" },\n");
            }
            return P2Model.closeJson(buf);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Filter filter = (Filter)o;
            return this.exclude.equals(filter.exclude) && this.excludePrefix.equals(filter.excludePrefix) && this.excludeSuffix.equals(filter.excludeSuffix) && this.props.equals(filter.props);
        }

        public int hashCode() {
            return Objects.hash(this.exclude, this.excludePrefix, this.excludeSuffix, this.props);
        }
    }
}

