/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.http.manager.ivt;

import com.google.gson.JsonObject;
import dev.galasa.Test;
import dev.galasa.core.manager.Logger;
import dev.galasa.http.HttpClient;
import dev.galasa.http.HttpClientException;
import dev.galasa.http.HttpClientResponse;
import dev.galasa.http.IHttpClient;
import dev.galasa.http.StandAloneHttpClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.assertj.core.api.Assertions;

@Test
public class HttpManagerIVT {
    @Logger
    public Log logger;
    @HttpClient
    public IHttpClient client;

    @Test
    public void checkNotNull() {
        Assertions.assertThat((Object)this.logger).isNotNull();
        Assertions.assertThat((Object)this.client).isNotNull();
    }

    @Test
    public void testStandalone() {
        IHttpClient standaloneClient = StandAloneHttpClient.getHttpClient((int)10, (Log)this.logger);
        Assertions.assertThat((Object)standaloneClient).isInstanceOf(IHttpClient.class);
    }

    @Test
    public void SSLContextTest() throws HttpClientException {
        this.client.setTrustingSSLContext();
        Assertions.assertThat((Object)this.client.getSSLContext()).isNotNull();
    }

    @Test
    public void getTests() throws Exception {
        this.client.setURI(new URI("https://httpbin.org"));
        String sResponse = (String)this.client.getText("/get").getContent();
        Assertions.assertThat((String)sResponse).startsWith((CharSequence)"{");
        Assertions.assertThat((String)sResponse).contains(new CharSequence[]{"\"url\": \"https://httpbin.org/get\""});
        JsonObject jResponse = (JsonObject)this.client.getJson("/get").getContent();
        Assertions.assertThat((String)jResponse.get("url").getAsString()).isEqualTo((Object)"https://httpbin.org/get");
    }

    @Test
    public void headerTest() throws Exception {
        String headerName = "Hobbit-Header";
        String headerValue = "Frodo";
        this.client.setURI(new URI("https://httpbin.org"));
        this.client.addCommonHeader(headerName, headerValue);
        HttpClientResponse response = this.client.getJson("/get");
        Map headers = response.getheaders();
        this.logger.info((Object)("Response headers: " + headers));
        Assertions.assertThat((Map)headers).isNotNull();
        Assertions.assertThat((Map)headers).containsKey((Object)"Content-Type");
        Assertions.assertThat((Object)response.getHeader("Content-Type")).isEqualTo((Object)"application/json");
        Assertions.assertThat((String)response.getProtocolVersion()).contains(new CharSequence[]{"HTTP"});
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(200);
        Assertions.assertThat((String)response.getStatusMessage()).isEqualTo((Object)"OK");
        Assertions.assertThat((String)response.getStatusLine()).contains(new CharSequence[]{"HTTP", "200 OK"});
        JsonObject json = (JsonObject)response.getContent();
        this.logger.info((Object)json.toString());
        Assertions.assertThat((String)json.toString()).contains(new CharSequence[]{headerName});
        Assertions.assertThat((String)json.toString()).contains(new CharSequence[]{headerValue});
    }

    @Test
    public void authTest() throws Exception {
        String user = "hobbit";
        String pword = "passw0rd";
        String path = "/basic-auth/" + user + "/" + pword;
        URI httpbin = new URI("https://httpbin.org");
        this.client.setAuthorisation(user, pword);
        this.client.setAuthorisation(user, pword, httpbin);
        Assertions.assertThat((String)this.client.getUsername()).isEqualTo((Object)user);
        Assertions.assertThat((String)this.client.getUsername(httpbin)).isEqualTo((Object)user);
        HttpClientResponse response = this.client.getJson(path);
        Assertions.assertThat((int)response.getStatusCode()).isEqualTo(200);
        Assertions.assertThat((boolean)((JsonObject)response.getContent()).get("authenticated").getAsBoolean()).isTrue();
        Assertions.assertThat((String)((JsonObject)response.getContent()).get("user").getAsString()).isEqualTo((Object)user);
    }

    @Test
    public void postTests() throws Exception {
        String key = "Project";
        String value = "Galasa";
        this.client.setURI(new URI("https://httpbin.org"));
        JsonObject json = new JsonObject();
        json.addProperty(key, value);
        HttpClientResponse jResponse = this.client.postJson("/post", json);
        Assertions.assertThat((int)jResponse.getStatusCode()).isEqualTo(200);
        this.logger.info((Object)((JsonObject)jResponse.getContent()).toString());
        Assertions.assertThat((String)((JsonObject)jResponse.getContent()).get("data").getAsString()).isEqualTo((Object)json.toString());
        HttpClientResponse sResponse = this.client.postText("/post", json.toString());
        Assertions.assertThat((int)sResponse.getStatusCode()).isEqualTo(200);
        this.logger.info((Object)((String)sResponse.getContent()).toString());
        Assertions.assertThat((String)((String)sResponse.getContent())).contains(new CharSequence[]{key});
        Assertions.assertThat((String)((String)sResponse.getContent())).contains(new CharSequence[]{value});
    }

    @Test
    public void deleteTests() throws HttpClientException {
        HttpClientResponse textResponse = this.client.deleteText("/anything");
        Assertions.assertThat((String)((String)textResponse.getContent())).contains(new CharSequence[]{"DELETE"});
        Assertions.assertThat((int)textResponse.getStatusCode()).isEqualTo(200);
        byte[] bytes = "bytes".getBytes();
        HttpClientResponse binResponse = this.client.deleteBinary("/delete", bytes);
        Assertions.assertThat((int)binResponse.getStatusCode()).isEqualTo(200);
    }

    @Test
    public void putTests() throws HttpClientException {
        HttpClientResponse textResponse = this.client.putText("/anything", "");
        Assertions.assertThat((String)((String)textResponse.getContent())).contains(new CharSequence[]{"PUT"});
        Assertions.assertThat((int)textResponse.getStatusCode()).isEqualTo(200);
        byte[] bytes = "bytes".getBytes();
        HttpClientResponse binResponse = this.client.putBinary("/put", bytes);
        Assertions.assertThat((int)binResponse.getStatusCode()).isEqualTo(200);
    }

    @Test
    public void testBinary() throws HttpClientException {
        byte[] bytes = "bytes".getBytes();
        HttpClientResponse response = this.client.getBinary("/bytes/8", bytes);
        Assertions.assertThat((Object)response.getHeader("Content-Length")).isEqualTo((Object)"8");
        Assertions.assertThat((int)((byte[])response.getContent()).length).isEqualTo(8);
        Assertions.assertThat((Object)response.getHeader("Content-Type")).isEqualTo((Object)"application/octet-stream");
    }

    @Test
    public void downloadFileTest() throws Exception {
        int count;
        boolean fileExists = false;
        File f = new File("/tmp/jenkins.hpi");
        this.client.setURI(new URI("https://resources.galasa.dev"));
        InputStream in = this.client.getFile("/jenkins.hpi").getEntity().getContent();
        FileOutputStream out = new FileOutputStream(f);
        byte[] data = new byte[2048];
        while ((count = in.read(data)) != -1) {
            ((OutputStream)out).write(data, 0, count);
        }
        out.flush();
        ((OutputStream)out).close();
        if (f.exists() && !f.isDirectory() && f.getTotalSpace() > 0L) {
            fileExists = true;
        }
        Assertions.assertThat((boolean)fileExists).isTrue();
        f.delete();
    }

    @Test
    public void buildURITest() {
        HttpClientException expected = null;
        try {
            this.client.getText("http://httpbin.org/anything?should==fail");
        }
        catch (HttpClientException e) {
            this.logger.info((Object)("Caught expected exception: " + e.getMessage()));
            expected = e;
        }
        Assertions.assertThat(expected).isNotNull();
        expected = null;
        try {
            this.client.getText("http://httpbin.org/anything?thisparam=ok&&oops=yes");
        }
        catch (HttpClientException e) {
            this.logger.info((Object)("Caught expected exception: " + e.getMessage()));
            expected = e;
        }
        Assertions.assertThat((Throwable)expected).isNotNull();
    }
}

