/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.boot;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class BootLogger {
    private static Level bootlogLevel = Level.ALL;

    public void debug(String message) {
        this.log(Level.DEBUG, message);
    }

    public void info(String message) {
        this.log(Level.INFO, message);
    }

    public void trace(String message) {
        this.log(Level.TRACE, message);
    }

    public void error(String message) {
        this.log(Level.ERROR, message);
    }

    public void error(String message, Throwable e) {
        this.log(Level.ERROR, message);
        e.printStackTrace(System.out);
    }

    public void fatal(String message) {
        this.log(Level.FATAL, message);
    }

    public void fatal(String message, Throwable e) {
        this.log(Level.FATAL, message);
        e.printStackTrace(System.out);
    }

    public boolean isTraceEnabled() {
        return bootlogLevel.getValue() >= Level.TRACE.getValue();
    }

    private void log(Level level, String message) {
        if (level.getValue() <= bootlogLevel.getValue()) {
            StringBuilder sb = new StringBuilder();
            sb.append(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS").format(new Date()));
            sb.append(' ');
            sb.append((Object)level);
            sb.append(' ');
            sb.append(Thread.currentThread().getStackTrace()[3].getClassName());
            sb.append('.');
            sb.append(Thread.currentThread().getStackTrace()[3].getMethodName());
            sb.append(" - ");
            sb.append(message);
            System.out.println(sb.toString());
        }
    }

    public void setLevel(Level level) {
        bootlogLevel = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String log4jFileName = "log4j.properties";
        Properties log4jProps = new Properties();
        InputStream input = null;
        try {
            input = BootLogger.class.getClassLoader().getResourceAsStream(log4jFileName);
            if (input == null) {
                input = BootLogger.class.getClass().getResourceAsStream("/" + log4jFileName);
            }
            if (input != null) {
                String[] parts;
                log4jProps.load(input);
                String rootLogger = log4jProps.getProperty("log4j.rootLogger");
                if (rootLogger != null && (parts = rootLogger.split(",")).length >= 1 && Level.isValid(parts[0])) {
                    bootlogLevel = Level.valueOf(parts[0]);
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static enum Level {
        FATAL(0),
        ERROR(1),
        WARN(2),
        INFO(3),
        DEBUG(4),
        TRACE(5),
        ALL(9);

        private final int name;

        private Level(int level) {
            this.name = level;
        }

        public int getValue() {
            return this.name;
        }

        public static boolean isValid(String level) {
            for (Level lvl : Level.values()) {
                if (!lvl.name().equalsIgnoreCase(level)) continue;
                return true;
            }
            return false;
        }
    }
}

