/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.boot;

import dev.galasa.boot.BootLogger;
import dev.galasa.boot.LauncherException;
import dev.galasa.boot.felix.FelixFramework;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Launcher {
    private static final String OBR_OPTION = "obr";
    private static final String BOOTSTRAP_OPTION = "bootstrap";
    private static final String OVERRIDES_OPTION = "overrides";
    private static final String RESOURCEMANAGEMENT_OPTION = "resourcemanagement";
    private static final String K8SCONTROLLER_OPTION = "k8scontroller";
    private static final String API_OPTION = "api";
    private static final String DOCKERCONTROLLER_OPTION = "dockercontroller";
    private static final String METRICSERVER_OPTION = "metricserver";
    private static final String TEST_OPTION = "test";
    private static final String RUN_OPTION = "run";
    private static final String GHERKIN_OPTION = "gherkin";
    private static final String BUNDLE_OPTION = "bundle";
    private static final String METRICS_OPTION = "metrics";
    private static final String HEALTH_OPTION = "health";
    private static final String LOCALMAVEN_OPTION = "localmaven";
    private static final String REMOTEMAVEN_OPTION = "remotemaven";
    private static final String TRACE_OPTION = "trace";
    private static final String BACKUPCPS_OPTION = "backupcps";
    private static final String RESTORECPS_OPTION = "restorecps";
    private static final String FILE_OPTION = "f";
    private static final String FILE_OPTION_LONG = "file";
    private static final String DRY_RUN_OPTION = "dryrun";
    private static final String SETUPECO_OPTION = "setupeco";
    private static final String VALIDATEECO_OPTION = "validateeco";
    private static final String USER_HOME = "user.home";
    private static final BootLogger logger = new BootLogger();
    private List<String> bundleRepositories = new ArrayList<String>();
    private String testName;
    private String testBundleName;
    private String testClassName;
    private String runName;
    private String gherkinName;
    private String filePath;
    private FelixFramework felixFramework;
    private Properties boostrapProperties;
    private Properties overridesProperties;
    private boolean testRun;
    private boolean resourceManagement;
    private boolean k8sController;
    private boolean dockerController;
    private boolean metricsServer;
    private boolean api;
    private boolean backupCPS;
    private boolean restoreCPS;
    private boolean dryRun;
    private boolean setupEco;
    private boolean validateEco;
    private Integer metrics;
    private Integer health;
    private List<String> bundles = new ArrayList<String>();
    private URL localMavenRepo;
    private List<URL> remoteMavenRepos = new ArrayList<URL>();

    public static void main(String[] args) {
        Launcher launcher = new Launcher();
        try {
            launcher.launch(args);
        }
        catch (Exception e) {
            logger.error("Exiting launcher due to exception", e);
            System.exit(16);
        }
        System.exit(0);
    }

    protected void launch(String[] args) throws LauncherException, InterruptedException {
        this.felixFramework = new FelixFramework();
        try {
            this.processCommandLine(args);
        }
        catch (ParseException e) {
            throw new LauncherException("Unable to parse command line arguments", e);
        }
        logger.debug("OBR Repository Files: " + this.bundleRepositories);
        logger.debug("Launching Framework...");
        try {
            this.buildFramework();
            if (this.testRun) {
                if (this.testBundleName != null && this.testClassName != null) {
                    logger.debug("Test Bundle: " + this.testBundleName);
                    logger.debug("Test Class: " + this.testClassName);
                    this.overridesProperties.setProperty("framework.run.testbundleclass", this.testName);
                } else if (this.runName != null) {
                    logger.debug("Test Run: " + this.runName);
                    this.overridesProperties.setProperty("framework.run.name", this.runName);
                } else {
                    logger.debug("Gherkin Run: " + this.gherkinName.toString());
                    this.overridesProperties.setProperty("framework.run.gherkintest", this.gherkinName);
                }
                this.felixFramework.runTest(this.boostrapProperties, this.overridesProperties);
            } else if (this.resourceManagement) {
                logger.debug("Resource Management");
                this.felixFramework.runResourceManagement(this.boostrapProperties, this.overridesProperties, this.bundles, this.metrics, this.health);
            } else if (this.k8sController) {
                logger.debug("Kubernetes Controller");
                this.felixFramework.runK8sController(this.boostrapProperties, this.overridesProperties, this.bundles, this.metrics, this.health);
            } else if (this.dockerController) {
                logger.debug("Docker Controller");
                this.felixFramework.runDockerController(this.boostrapProperties, this.overridesProperties, this.bundles, this.metrics, this.health);
            } else if (this.metricsServer) {
                logger.debug("Metrics Server");
                this.felixFramework.runMetricsServer(this.boostrapProperties, this.overridesProperties, this.bundles, this.metrics, this.health);
            } else if (this.api) {
                logger.debug("Web API Server");
                this.felixFramework.runWebApiServer(this.boostrapProperties, this.overridesProperties, this.bundles, this.metrics, this.health);
            } else if (this.backupCPS) {
                logger.debug("Back Up CPS Properties");
                this.felixFramework.runBackupCPS(this.boostrapProperties, this.overridesProperties, this.filePath);
            } else if (this.restoreCPS) {
                this.felixFramework.runRestoreCPS(this.boostrapProperties, this.overridesProperties, this.filePath, this.dryRun);
            } else if (this.setupEco) {
                this.felixFramework.runSetupEcosystem(this.boostrapProperties, this.overridesProperties);
            } else if (this.validateEco) {
                this.felixFramework.runValidateEcosystem(this.boostrapProperties, this.overridesProperties);
            }
        }
        catch (LauncherException e) {
            logger.error("Unable to run test class", e);
            throw e;
        }
        finally {
            if (this.felixFramework != null) {
                this.felixFramework.stopFramework();
            }
        }
        logger.info("Boot complete");
    }

    private void buildFramework() throws LauncherException {
        logger.debug("Launching Framework...");
        try {
            this.felixFramework.buildFramework(this.bundleRepositories, this.boostrapProperties, this.localMavenRepo, this.remoteMavenRepos);
        }
        catch (Exception e) {
            throw new LauncherException("Unable to create and initialize Felix framework", e);
        }
    }

    private void processCommandLine(String[] args) throws ParseException {
        StringBuilder messageBuffer = new StringBuilder();
        messageBuffer.append("Supplied command line arguments: ");
        for (String arg : args) {
            messageBuffer.append(arg + " ");
        }
        logger.debug(messageBuffer.toString());
        Options options = new Options();
        Option propertyOption = Option.builder().longOpt("D").argName("property=value").hasArgs().valueSeparator().numberOfArgs(2).desc("use value for given properties").build();
        options.addOption(propertyOption);
        options.addOption(null, OBR_OPTION, true, "Felix OBR Repository File name");
        options.addOption(null, BOOTSTRAP_OPTION, true, "Bootstrap properties file url");
        options.addOption(null, OVERRIDES_OPTION, true, "Overrides properties file url");
        options.addOption(null, RESOURCEMANAGEMENT_OPTION, false, "A Resource Management server");
        options.addOption(null, K8SCONTROLLER_OPTION, false, "A k8s Controller server");
        options.addOption(null, API_OPTION, false, "A Web App server, list bundles to load or ALL");
        options.addOption(null, DOCKERCONTROLLER_OPTION, false, "A Docker Controller server");
        options.addOption(null, METRICSERVER_OPTION, false, "A Metrics server");
        options.addOption(null, TEST_OPTION, true, "The test to run");
        options.addOption(null, RUN_OPTION, true, "The run name");
        options.addOption(null, GHERKIN_OPTION, true, "The gherkin test to run");
        options.addOption(null, BUNDLE_OPTION, true, "Extra bundles to load");
        options.addOption(null, METRICS_OPTION, true, "The port the metrics server will open, 0 to disable");
        options.addOption(null, HEALTH_OPTION, true, "The port the health server will open, 0 to disable");
        options.addOption(null, LOCALMAVEN_OPTION, true, "The local maven repository, defaults to ~/.m2/repository");
        options.addOption(null, REMOTEMAVEN_OPTION, true, "The remote maven repositories, defaults to central");
        options.addOption(null, TRACE_OPTION, false, "Enable TRACE logging");
        options.addOption(null, BACKUPCPS_OPTION, false, "Back up CPS properties to file");
        options.addOption(null, RESTORECPS_OPTION, false, "Restore CPS properties from file");
        options.addOption(FILE_OPTION, FILE_OPTION_LONG, true, "File for data input/output");
        options.addOption(null, DRY_RUN_OPTION, false, "Perform a dry-run of the specified actions. Can be combined with \"file\"");
        options.addOption(null, SETUPECO_OPTION, false, "Setup the Galasa Ecosystem");
        options.addOption(null, VALIDATEECO_OPTION, false, "Validate the Galasa Ecosystem");
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = null;
        commandLine = parser.parse(options, args);
        if (commandLine.hasOption("D")) {
            String[] commandLinePropety = commandLine.getOptionProperties("D");
            Set<Object> keys = commandLinePropety.keySet();
            for (Object key : keys) {
                System.setProperty((String)key, commandLinePropety.getProperty((String)key));
            }
        }
        if (commandLine.hasOption(TRACE_OPTION)) {
            logger.setLevel(BootLogger.Level.TRACE);
            System.setProperty("log4j2.configurationFile", "trace-log4j2.properties");
        }
        if (commandLine.hasOption(OBR_OPTION)) {
            for (String option : commandLine.getOptionValues(OBR_OPTION)) {
                this.bundleRepositories.add(option);
            }
        }
        this.checkForBoostrap(commandLine);
        this.checkForOverrides(commandLine);
        this.checkForBundles(commandLine);
        this.checkForMetricsPort(commandLine);
        this.checkForHealthPort(commandLine);
        this.checkForLocalMaven(commandLine);
        this.checkForRemoteMaven(commandLine);
        this.testRun = commandLine.hasOption(TEST_OPTION) || commandLine.hasOption(RUN_OPTION) || commandLine.hasOption(GHERKIN_OPTION);
        this.resourceManagement = commandLine.hasOption(RESOURCEMANAGEMENT_OPTION);
        this.k8sController = commandLine.hasOption(K8SCONTROLLER_OPTION);
        this.dockerController = commandLine.hasOption(DOCKERCONTROLLER_OPTION);
        this.metricsServer = commandLine.hasOption(METRICSERVER_OPTION);
        this.api = commandLine.hasOption(API_OPTION);
        this.backupCPS = commandLine.hasOption(BACKUPCPS_OPTION);
        this.restoreCPS = commandLine.hasOption(RESTORECPS_OPTION);
        this.dryRun = commandLine.hasOption(DRY_RUN_OPTION);
        this.setupEco = commandLine.hasOption(SETUPECO_OPTION);
        this.validateEco = commandLine.hasOption(VALIDATEECO_OPTION);
        if (this.testRun) {
            this.runName = commandLine.getOptionValue(RUN_OPTION);
            this.testName = commandLine.getOptionValue(TEST_OPTION);
            this.gherkinName = commandLine.getOptionValue(GHERKIN_OPTION);
            if (this.runName != null) {
                this.runName = this.runName.toUpperCase();
            } else if (this.testName != null) {
                String[] bundleclass = this.testName.split("/");
                if (bundleclass.length != 2) {
                    this.commandLineError("Error: Invalid test name format");
                }
                this.testBundleName = bundleclass[0];
                this.testClassName = bundleclass[1];
                if (this.testBundleName.isEmpty() || this.testClassName.isEmpty()) {
                    this.commandLineError("Error: Invalid test name format");
                }
            } else {
                if (this.gherkinName != null) {
                    return;
                }
                this.commandLineError("Error: A valid run, java test or gherkin test must be supplied");
            }
            return;
        }
        if (this.resourceManagement) {
            return;
        }
        if (this.k8sController) {
            return;
        }
        if (this.dockerController) {
            return;
        }
        if (this.metricsServer) {
            return;
        }
        if (this.api) {
            return;
        }
        if (this.backupCPS || this.restoreCPS) {
            if (this.backupCPS && this.restoreCPS) {
                this.commandLineError("Cannot use options \"backupcps\" and \"restorecps\" together.");
            } else {
                this.filePath = commandLine.getOptionValue(FILE_OPTION);
                if (this.filePath == null) {
                    if (this.backupCPS) {
                        this.filePathError(BACKUPCPS_OPTION);
                    } else {
                        this.filePathError(RESTORECPS_OPTION);
                    }
                }
            }
            return;
        }
        if (this.setupEco) {
            return;
        }
        if (this.validateEco) {
            return;
        }
        if (this.dryRun) {
            this.commandLineError("Must be combined with \"restorecps\"");
            return;
        }
        this.commandLineError("Error: Must select either --test, --run, --gherkin, --k8scontroller, --metricserver, --resourcemanagement, --bundle, --backupcps, --setupeco, --validateeco, or --restorecps");
    }

    private void filePathError(String option) {
        this.commandLineError("The option \"" + option + "\" requires an output file (specify with --file <path> or -f <path>)");
    }

    private void checkForRemoteMaven(CommandLine commandLine) {
        try {
            if (commandLine.hasOption(REMOTEMAVEN_OPTION)) {
                for (String option : commandLine.getOptionValues(REMOTEMAVEN_OPTION)) {
                    this.remoteMavenRepos.add(new URL(option.replaceFirst("/*$", "")));
                }
            }
            this.remoteMavenRepos.add(new URL("https://repo.maven.apache.org/maven2"));
        }
        catch (MalformedURLException e) {
            logger.error("invalid remote maven urls", e);
            this.commandLineError(null);
        }
    }

    private void checkForLocalMaven(CommandLine commandLine) {
        if (commandLine.hasOption(LOCALMAVEN_OPTION)) {
            String repo = commandLine.getOptionValue(LOCALMAVEN_OPTION);
            if (repo != null) {
                if ("disable".equals(repo)) {
                    this.localMavenRepo = null;
                } else {
                    try {
                        this.localMavenRepo = new URL(repo.replaceFirst("/*$", ""));
                    }
                    catch (MalformedURLException e) {
                        logger.error("--localmaven has an invalid URL", e);
                        this.commandLineError(null);
                    }
                    if (!FILE_OPTION_LONG.equals(this.localMavenRepo.getProtocol())) {
                        this.commandLineError("--localmaven must be a file: URL");
                    }
                }
            }
        } else {
            try {
                this.localMavenRepo = new File(System.getProperty(USER_HOME) + File.separator + ".m2" + File.separator + "repository").toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.error("internal error", e);
                this.commandLineError(null);
            }
        }
    }

    private void checkForMetricsPort(CommandLine commandLine) {
        if (commandLine.hasOption(METRICS_OPTION)) {
            String port = commandLine.getOptionValue(METRICS_OPTION);
            this.metrics = Integer.parseInt(port);
        }
    }

    private void checkForHealthPort(CommandLine commandLine) {
        if (commandLine.hasOption(HEALTH_OPTION)) {
            String port = commandLine.getOptionValue(HEALTH_OPTION);
            this.health = Integer.parseInt(port);
        }
    }

    private void checkForBundles(CommandLine commandLine) {
        if (commandLine.hasOption(BUNDLE_OPTION)) {
            for (String option : commandLine.getOptionValues(BUNDLE_OPTION)) {
                this.bundles.add(option);
            }
        }
    }

    private void checkForBoostrap(CommandLine commandLine) {
        URI bootstrapUri = null;
        if (commandLine.hasOption(BOOTSTRAP_OPTION)) {
            String uri = commandLine.getOptionValue(BOOTSTRAP_OPTION);
            try {
                bootstrapUri = new URI(uri);
            }
            catch (URISyntaxException e) {
                logger.error("Invalid bootstrap URI provided", e);
                this.commandLineError(null);
            }
        } else {
            Path path = Paths.get(System.getProperty(USER_HOME), ".galasa", "bootstrap.properties");
            try {
                if (!path.toFile().exists()) {
                    if (!path.getParent().toFile().exists()) {
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    }
                    Files.createFile(path, new FileAttribute[0]);
                }
                bootstrapUri = path.toUri();
            }
            catch (IOException e) {
                logger.error("Unable to create empty default bootstrap file " + path.toUri().toString(), e);
                this.commandLineError(null);
            }
        }
        try {
            URLConnection bootstrapConnection = bootstrapUri.toURL().openConnection();
            bootstrapConnection.setConnectTimeout(30000);
            bootstrapConnection.setReadTimeout(30000);
            try (InputStream is = bootstrapConnection.getInputStream();){
                this.boostrapProperties = new Properties();
                this.boostrapProperties.load(is);
            }
        }
        catch (IOException e) {
            logger.error("Unable to load bootstrap properties", e);
            this.commandLineError(null);
        }
    }

    private void checkForOverrides(CommandLine commandLine) {
        URI overridesUri = null;
        if (commandLine.hasOption(OVERRIDES_OPTION)) {
            String uri = commandLine.getOptionValue(OVERRIDES_OPTION);
            try {
                overridesUri = new URI(uri);
            }
            catch (URISyntaxException e) {
                logger.error("Invalid overrides URI provided", e);
                this.commandLineError(null);
            }
        } else {
            Path path = Paths.get(System.getProperty(USER_HOME), ".galasa", "overrides.properties");
            if (!path.toFile().exists()) {
                this.overridesProperties = new Properties();
                return;
            }
            overridesUri = path.toUri();
        }
        try (InputStream is = overridesUri.toURL().openStream();){
            this.overridesProperties = new Properties();
            this.overridesProperties.load(is);
        }
        catch (IOException e) {
            logger.error("Unable to load overrides properties", e);
            this.commandLineError(null);
        }
    }

    private void commandLineError(String message) {
        if (message != null) {
            logger.error(message);
        }
        logger.error("\nExample test run arguments: --obr infra.obr --obr test.obr --test test.bundle/test.package.TestClass\nExample Resource Management arguments: --obr infra.obr --obr test.obr --resourcemanagement");
        System.exit(-1);
    }
}

