/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Property;
import org.apache.felix.bundlerepository.impl.FelixPropertyAdapter;
import org.apache.felix.bundlerepository.impl.NamespaceTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiCapabilityAdapter
implements Capability {
    private final org.osgi.resource.Capability capability;

    public OSGiCapabilityAdapter(org.osgi.resource.Capability capability) {
        this.capability = capability;
    }

    public boolean equals(Object o) {
        return this.capability.equals(o);
    }

    @Override
    public String getName() {
        return NamespaceTranslator.getFelixNamespace(this.capability.getNamespace());
    }

    @Override
    public Property[] getProperties() {
        Map<String, Object> attributes = this.capability.getAttributes();
        ArrayList<FelixPropertyAdapter> result = new ArrayList<FelixPropertyAdapter>(attributes.size());
        for (Map.Entry<String, Object> entry : this.capability.getAttributes().entrySet()) {
            if (entry.getKey().equals(this.capability.getNamespace())) {
                result.add(new FelixPropertyAdapter(this.getName(), entry.getValue()));
                continue;
            }
            result.add(new FelixPropertyAdapter(entry));
        }
        return result.toArray(new Property[result.size()]);
    }

    @Override
    public Map<String, Object> getPropertiesAsMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.capability.getAttributes());
        result.put(this.getName(), result.get(this.capability.getNamespace()));
        return result;
    }

    @Override
    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.capability.getDirectives());
    }

    public int hashCode() {
        return this.capability.hashCode();
    }
}

