/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.FelixCapabilityAdapter;
import org.apache.felix.bundlerepository.impl.FelixResourceAdapter;
import org.apache.felix.bundlerepository.impl.LazyHashMap;
import org.apache.felix.bundlerepository.impl.OSGiCapabilityImpl;
import org.apache.felix.bundlerepository.impl.OSGiRequirementAdapter;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OSGiRepositoryImpl
implements org.osgi.service.repository.Repository {
    private final RepositoryAdmin repository;

    OSGiRepositoryImpl(RepositoryAdmin repository) {
        this.repository = repository;
    }

    @Override
    public Map<org.osgi.resource.Requirement, Collection<org.osgi.resource.Capability>> findProviders(Collection<? extends org.osgi.resource.Requirement> requirements) {
        HashMap<org.osgi.resource.Requirement, Collection<org.osgi.resource.Capability>> m = new HashMap<org.osgi.resource.Requirement, Collection<org.osgi.resource.Capability>>();
        for (org.osgi.resource.Requirement requirement : requirements) {
            m.put(requirement, this.findProviders(requirement));
        }
        return m;
    }

    private Collection<org.osgi.resource.Capability> findProviders(org.osgi.resource.Requirement req) {
        ArrayList<org.osgi.resource.Capability> caps = new ArrayList<org.osgi.resource.Capability>();
        if ("osgi.identity".equals(req.getNamespace())) {
            for (Repository repo : this.repository.listRepositories()) {
                for (Resource res : repo.getResources()) {
                    String f = req.getDirectives().get("filter");
                    try {
                        this.addResourceForIdentity(res, f == null ? null : FrameworkUtil.createFilter(f), caps);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        } else {
            Resource[] resources = this.repository.discoverResources(new Requirement[]{new OSGiRequirementAdapter(req)});
            OSGiRequirementAdapter adapter = new OSGiRequirementAdapter(req);
            for (Resource resource : resources) {
                for (Capability cap : resource.getCapabilities()) {
                    if (!adapter.isSatisfied(cap)) continue;
                    caps.add(new FelixCapabilityAdapter(cap, new FelixResourceAdapter(resource)));
                }
            }
        }
        return caps;
    }

    private void addResourceForIdentity(Resource res, Filter filter, List<org.osgi.resource.Capability> caps) throws Exception {
        List<org.osgi.resource.Capability> idCaps = new FelixResourceAdapter(res).getCapabilities("osgi.identity");
        if (idCaps.size() == 0) {
            return;
        }
        org.osgi.resource.Capability idCap = idCaps.get(0);
        if (filter != null && !filter.matches(idCap.getAttributes())) {
            return;
        }
        caps.add(idCap);
    }

    static OSGiCapabilityImpl newOSGiIdentityCapability(Resource res) {
        HashMap<String, Object> idAttrs = new HashMap<String, Object>(res.getProperties());
        idAttrs.put("osgi.identity", res.getSymbolicName());
        if (idAttrs.get("type") == null) {
            idAttrs.put("type", "osgi.bundle");
        }
        return new OSGiCapabilityImpl("osgi.identity", idAttrs, Collections.<String, String>emptyMap());
    }

    static OSGiCapabilityImpl newOSGiContentCapability(Resource resource) {
        final String uri = resource.getURI();
        LazyHashMap.LazyValue<String, Object> lazyValue = new LazyHashMap.LazyValue<String, Object>("osgi.content", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return OSGiRepositoryImpl.getSHA256(uri);
            }
        });
        Object mime = resource.getProperties().get("mime");
        if (mime == null) {
            mime = "application/vnd.osgi.bundle";
        }
        LazyHashMap<String, Object> contentAttrs = new LazyHashMap<String, Object>(Collections.singleton(lazyValue));
        contentAttrs.put("mime", mime);
        contentAttrs.put("size", resource.getSize());
        contentAttrs.put("url", uri);
        return new OSGiCapabilityImpl("osgi.content", contentAttrs, Collections.<String, String>emptyMap());
    }

    static String getSHA256(String uri) throws IOException, NoSuchAlgorithmException {
        InputStream is = new URL(uri).openStream();
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        DigestInputStream dis = new DigestInputStream(is, md);
        byte[] buffer = new byte[16384];
        while (dis.read(buffer) != -1) {
        }
        StringBuilder sb = new StringBuilder(64);
        for (byte b : md.digest()) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

