/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.model.googleai.GeminiSchema;
import dev.langchain4j.model.googleai.GeminiThinkingConfig;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
class GeminiGenerationConfig {
    @JsonProperty(value="stopSequences")
    private final List<String> stopSequences;
    @JsonProperty(value="responseMimeType")
    private final String responseMimeType;
    @JsonProperty(value="responseSchema")
    private final GeminiSchema responseSchema;
    @JsonProperty(value="candidateCount")
    private final Integer candidateCount;
    @JsonProperty(value="maxOutputTokens")
    private final Integer maxOutputTokens;
    @JsonProperty(value="temperature")
    private final Double temperature;
    @JsonProperty(value="topK")
    private final Integer topK;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="topP")
    private final Double topP;
    @JsonProperty(value="presencePenalty")
    private final Double presencePenalty;
    @JsonProperty(value="frequencyPenalty")
    private final Double frequencyPenalty;
    @JsonProperty(value="thinkingConfig")
    private final GeminiThinkingConfig thinkingConfig;
    @JsonProperty(value="responseLogprobs")
    private final Boolean responseLogprobs;
    @JsonProperty(value="enableEnhancedCivicAnswers")
    private final Boolean enableEnhancedCivicAnswers;
    @JsonProperty(value="logprobs")
    private final Integer logprobs;

    GeminiGenerationConfig(GeminiGenerationConfigBuilder builder) {
        this.stopSequences = builder.stopSequences;
        this.responseMimeType = builder.responseMimeType;
        this.responseSchema = builder.responseSchema;
        this.candidateCount = builder.candidateCount;
        this.maxOutputTokens = builder.maxOutputTokens;
        this.temperature = builder.temperature;
        this.topK = builder.topK;
        this.seed = builder.seed;
        this.topP = builder.topP;
        this.presencePenalty = builder.presencePenalty;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.responseLogprobs = builder.responseLogprobs;
        this.enableEnhancedCivicAnswers = builder.enableEnhancedCivicAnswers;
        this.thinkingConfig = builder.thinkingConfig;
        this.logprobs = builder.logprobs;
    }

    static GeminiGenerationConfigBuilder builder() {
        return new GeminiGenerationConfigBuilder();
    }

    static class GeminiGenerationConfigBuilder {
        private List<String> stopSequences;
        private String responseMimeType;
        private GeminiSchema responseSchema;
        private Integer candidateCount;
        private Integer maxOutputTokens;
        private Double temperature;
        private Integer topK;
        private Integer seed;
        private Double topP;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Boolean responseLogprobs;
        private Boolean enableEnhancedCivicAnswers;
        private GeminiThinkingConfig thinkingConfig;
        private Integer logprobs;

        GeminiGenerationConfigBuilder() {
        }

        GeminiGenerationConfigBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        GeminiGenerationConfigBuilder responseMimeType(String responseMimeType) {
            this.responseMimeType = responseMimeType;
            return this;
        }

        GeminiGenerationConfigBuilder responseSchema(GeminiSchema responseSchema) {
            this.responseSchema = responseSchema;
            return this;
        }

        GeminiGenerationConfigBuilder candidateCount(Integer candidateCount) {
            this.candidateCount = candidateCount;
            return this;
        }

        GeminiGenerationConfigBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        GeminiGenerationConfigBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        GeminiGenerationConfigBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        GeminiGenerationConfigBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        GeminiGenerationConfigBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        GeminiGenerationConfigBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        GeminiGenerationConfigBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        GeminiGenerationConfigBuilder thinkingConfig(GeminiThinkingConfig thinkingConfig) {
            this.thinkingConfig = thinkingConfig;
            return this;
        }

        GeminiGenerationConfigBuilder responseLogprobs(Boolean responseLogprobs) {
            this.responseLogprobs = responseLogprobs;
            return this;
        }

        GeminiGenerationConfigBuilder enableEnhancedCivicAnswers(Boolean enableEnhancedCivicAnswers) {
            this.enableEnhancedCivicAnswers = enableEnhancedCivicAnswers;
            return this;
        }

        GeminiGenerationConfigBuilder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        GeminiGenerationConfig build() {
            return new GeminiGenerationConfig(this);
        }
    }
}

