/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.junit.extension.extensions;

import dev.resteasy.junit.extension.annotations.RestClientConfig;
import dev.resteasy.junit.extension.api.InjectionProducer;
import dev.resteasy.junit.extension.extensions.Extensions;
import jakarta.ws.rs.client.Client;
import java.lang.annotation.Annotation;
import org.junit.jupiter.api.extension.ExtensionContext;

public class RestClientProducer
implements InjectionProducer {
    @Override
    public boolean canInject(ExtensionContext context, Class<?> clazz, Annotation ... qualifiers) {
        return Client.class.isAssignableFrom(clazz);
    }

    @Override
    public Object produce(ExtensionContext context, Class<?> clazz, Annotation ... qualifiers) {
        if (Client.class.isAssignableFrom(clazz)) {
            RestClientConfig restClient = Extensions.findQualifier(RestClientConfig.class, qualifiers);
            return Extensions.findOrCreateClient(context, restClient);
        }
        throw new IllegalArgumentException(String.format("Type %s is not assignable to %s", clazz.getName(), Client.class));
    }
}

