/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.junit.extension.extensions;

import dev.resteasy.junit.extension.extensions.InstanceManager;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class SeBootstrapExtension
implements BeforeAllCallback,
AfterAllCallback {
    private final Lock lock = new ReentrantLock();

    public void beforeAll(ExtensionContext context) throws Exception {
        this.lock.lock();
        try {
            InstanceManager.getOrCreateInstance(context).startInstance();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void afterAll(ExtensionContext context) {
        this.lock.lock();
        try {
            InstanceManager.removeInstance(context).ifPresent(InstanceManager::stopInstance);
        }
        finally {
            this.lock.unlock();
        }
    }
}

