/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.junit.extension.extensions;

import dev.resteasy.junit.extension.annotations.RequestPath;
import dev.resteasy.junit.extension.api.InjectionProducer;
import dev.resteasy.junit.extension.extensions.Extensions;
import dev.resteasy.junit.extension.extensions.InstanceManager;
import jakarta.ws.rs.core.UriBuilder;
import java.lang.annotation.Annotation;
import java.net.URI;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class UriProducer
implements InjectionProducer {
    @Override
    public boolean canInject(ExtensionContext context, Class<?> clazz, Annotation ... qualifiers) {
        return URI.class.isAssignableFrom(clazz);
    }

    @Override
    public Object produce(ExtensionContext context, Class<?> clazz, Annotation ... qualifiers) {
        if (URI.class.isAssignableFrom(clazz)) {
            RequestPath requestPath = Extensions.findQualifier(RequestPath.class, qualifiers);
            UriBuilder uriBuilder = InstanceManager.getInstance(context).orElseThrow(() -> new ParameterResolutionException("Could not find associated SeBootstrap instance")).instance().configuration().baseUriBuilder();
            if (requestPath != null) {
                return uriBuilder.path(requestPath.value()).build(new Object[0]);
            }
            return uriBuilder.build(new Object[0]);
        }
        throw new IllegalArgumentException(String.format("Type %s is not assignable to %s", clazz.getName(), URI.class));
    }
}

