/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import dev.snowdrop.buildpack.Logger;
import java.nio.charset.StandardCharsets;

public class ContainerLogReader
extends ResultCallback.Adapter<Frame> {
    private final Logger logger;

    public ContainerLogReader(Logger logger) {
        this.logger = logger;
    }

    public void onNext(Frame object) {
        if (StreamType.STDOUT == object.getStreamType() || StreamType.STDERR == object.getStreamType()) {
            String payload = new String(object.getPayload(), StandardCharsets.UTF_8);
            if (StreamType.STDOUT == object.getStreamType()) {
                this.logger.stdout(payload);
            } else if (StreamType.STDERR == object.getStreamType()) {
                this.logger.stderr(payload);
            }
        }
    }
}

