/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.buildpack;

import dev.snowdrop.buildpack.EditableSystemLogger;
import dev.snowdrop.buildpack.SystemLogger;
import dev.snowdrop.buildpack.SystemLoggerFluent;
import dev.snowdrop.buildpack.SystemLoggerFluentImpl;
import dev.snowdrop.buildpack.builder.VisitableBuilder;
import java.util.Objects;

public class SystemLoggerBuilder
extends SystemLoggerFluentImpl<SystemLoggerBuilder>
implements VisitableBuilder<SystemLogger, SystemLoggerBuilder> {
    SystemLoggerFluent<?> fluent;
    Boolean validationEnabled;

    public SystemLoggerBuilder() {
        this(false);
    }

    public SystemLoggerBuilder(Boolean validationEnabled) {
        this(new SystemLogger(), validationEnabled);
    }

    public SystemLoggerBuilder(SystemLoggerFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public SystemLoggerBuilder(SystemLoggerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SystemLogger(), validationEnabled);
    }

    public SystemLoggerBuilder(SystemLoggerFluent<?> fluent, SystemLogger instance) {
        this(fluent, instance, false);
    }

    public SystemLoggerBuilder(SystemLoggerFluent<?> fluent, SystemLogger instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAnsiColorEnabled(instance.isAnsiColorEnabled());
        this.validationEnabled = validationEnabled;
    }

    public SystemLoggerBuilder(SystemLogger instance) {
        this(instance, (Boolean)false);
    }

    public SystemLoggerBuilder(SystemLogger instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAnsiColorEnabled(instance.isAnsiColorEnabled());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EditableSystemLogger build() {
        EditableSystemLogger buildable = new EditableSystemLogger(this.fluent.isAnsiColorEnabled());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SystemLoggerBuilder that = (SystemLoggerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

