/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.test;

import dev.snowdrop.vertx.http.test.VertxWebTestClientContextCustomizer;
import java.util.List;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;

public class VertxWebTestClientContextCustomizerFactory
implements ContextCustomizerFactory {
    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        if (this.isEmbeddedSpringBootTest(testClass)) {
            return new VertxWebTestClientContextCustomizer();
        }
        return null;
    }

    private boolean isEmbeddedSpringBootTest(Class<?> testClass) {
        SpringBootTest annotation = (SpringBootTest)AnnotatedElementUtils.getMergedAnnotation(testClass, SpringBootTest.class);
        return annotation != null && annotation.webEnvironment().isEmbedded();
    }
}

