/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.vertx.http.server;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import reactor.core.publisher.Mono;

public class VertxWebServer
implements WebServer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Vertx vertx;
    private final HttpServerOptions httpServerOptions;
    private final Handler<RoutingContext> requestHandler;
    private HttpServer server;

    public VertxWebServer(Vertx vertx, HttpServerOptions httpServerOptions, Handler<RoutingContext> requestHandler) {
        this.vertx = vertx;
        this.httpServerOptions = httpServerOptions;
        this.requestHandler = requestHandler;
    }

    public void start() throws WebServerException {
        if (this.server != null) {
            return;
        }
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler(this.requestHandler);
        this.server = this.vertx.createHttpServer(this.httpServerOptions).requestHandler((Handler)router);
        Mono future = Mono.create(sink -> this.server.listen(result -> {
            if (result.succeeded()) {
                this.logger.info("Vert.x HTTP server started on port {}", (Object)this.getPort());
                sink.success();
            } else {
                sink.error(result.cause());
            }
        }));
        future.block(Duration.ofSeconds(5L));
    }

    public void stop() throws WebServerException {
        if (this.server == null) {
            return;
        }
        Mono future = Mono.create(sink -> this.server.close(result -> {
            if (result.succeeded()) {
                sink.success();
            } else {
                sink.error(result.cause());
            }
        }));
        future.doOnTerminate(() -> {
            this.server = null;
        }).block(Duration.ofSeconds(5L));
    }

    public int getPort() {
        if (this.server != null) {
            return this.server.actualPort();
        }
        return 0;
    }
}

