/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup.codec;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.examples.sumup.message.AbstractMessage;
import org.apache.mina.protocol.ProtocolDecoderOutput;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.ProtocolViolationException;
import org.apache.mina.protocol.codec.MessageDecoder;
import org.apache.mina.protocol.codec.MessageDecoderResult;

public abstract class AbstractMessageDecoder
implements MessageDecoder {
    private final int type;
    private int sequence;
    private boolean readHeader;

    protected AbstractMessageDecoder(int type) {
        this.type = type;
    }

    public MessageDecoderResult decodable(ProtocolSession session, ByteBuffer in) {
        if (in.remaining() < 6) {
            return MessageDecoderResult.NEED_DATA;
        }
        if (this.type == in.getShort()) {
            return MessageDecoderResult.OK;
        }
        return MessageDecoderResult.NOT_OK;
    }

    public MessageDecoderResult decode(ProtocolSession session, ByteBuffer in, ProtocolDecoderOutput out) throws ProtocolViolationException {
        AbstractMessage m;
        if (!this.readHeader) {
            in.getShort();
            this.sequence = in.getInt();
            this.readHeader = true;
        }
        if ((m = this.decodeBody(session, in)) == null) {
            return MessageDecoderResult.NEED_DATA;
        }
        this.readHeader = false;
        m.setSequence(this.sequence);
        out.write(m);
        return MessageDecoderResult.OK;
    }

    protected abstract AbstractMessage decodeBody(ProtocolSession var1, ByteBuffer var2);
}

