/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.tennis;

import org.apache.mina.examples.tennis.TennisBall;
import org.apache.mina.protocol.ProtocolCodecFactory;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolHandlerAdapter;
import org.apache.mina.protocol.ProtocolProvider;
import org.apache.mina.protocol.ProtocolSession;

public class TennisPlayer
implements ProtocolProvider {
    private final ProtocolHandler HANDLER = new TennisPlayerHandler();

    public ProtocolCodecFactory getCodecFactory() {
        throw new UnsupportedOperationException();
    }

    public ProtocolHandler getHandler() {
        return this.HANDLER;
    }

    private static class TennisPlayerHandler
    extends ProtocolHandlerAdapter {
        private static int nextId = 0;
        private final int id = nextId++;

        private TennisPlayerHandler() {
        }

        public void sessionOpened(ProtocolSession session) {
            System.out.println("Player-" + this.id + ": READY");
        }

        public void sessionClosed(ProtocolSession session) {
            System.out.println("Player-" + this.id + ": QUIT");
        }

        public void messageReceived(ProtocolSession session, Object message) {
            System.out.println("Player-" + this.id + ": RCVD " + message);
            TennisBall ball = (TennisBall)message;
            ball = ball.stroke();
            if (ball.getTTL() > 0) {
                session.write(ball);
            } else {
                System.out.println("Player-" + this.id + ": LOSE");
                session.close();
            }
        }

        public void messageSent(ProtocolSession session, Object message) {
            System.out.println("Player-" + this.id + ": SENT " + message);
        }
    }
}

