/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.handler;

import java.io.IOException;
import java.io.InputStream;
import org.apache.mina.common.ByteBuffer;

class IoSessionInputStream
extends InputStream {
    private final ByteBuffer buf = ByteBuffer.allocate(16);
    private boolean closed;
    private boolean released;
    private IOException exception;
    private int waiters;

    IoSessionInputStream() {
        this.buf.setAutoExpand(true);
        this.buf.limit(0);
    }

    public synchronized int available() {
        if (this.released) {
            return 0;
        }
        return this.buf.remaining();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.releaseBuffer();
        if (this.waiters != 0) {
            this.notifyAll();
        }
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized int read() throws IOException {
        this.waitForData();
        if (this.released) {
            return -1;
        }
        int ret = this.buf.get() & 0xFF;
        return ret;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.waitForData();
        if (this.released) {
            return -1;
        }
        int readBytes = len > this.buf.remaining() ? this.buf.remaining() : len;
        this.buf.get(b, off, readBytes);
        return readBytes;
    }

    public synchronized void reset() throws IOException {
        throw new IOException("Mark is not supported.");
    }

    private void waitForData() throws IOException {
        if (this.released) {
            throw new IOException("Stream is closed.");
        }
        ++this.waiters;
        while (!this.released && this.buf.remaining() == 0 && this.exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.waiters;
        if (this.exception != null) {
            this.releaseBuffer();
            throw this.exception;
        }
        if (this.closed && this.buf.remaining() == 0) {
            this.releaseBuffer();
        }
    }

    private void releaseBuffer() {
        if (this.released) {
            return;
        }
        this.released = true;
        this.buf.release();
    }

    synchronized void write(ByteBuffer src) {
        if (this.closed) {
            return;
        }
        if (this.buf.hasRemaining()) {
            this.buf.compact();
            this.buf.put(src);
            this.buf.flip();
        } else {
            this.buf.clear();
            this.buf.put(src);
            this.buf.flip();
            this.notify();
        }
    }

    synchronized void throwException(IOException e) {
        if (this.exception == null) {
            this.exception = e;
            if (this.waiters != 0) {
                this.notifyAll();
            }
        }
    }
}

