/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.mina.protocol.ProtocolHandlerAdapter;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.handler.MessageHandler;
import org.apache.mina.protocol.handler.UnknownMessageTypeException;

public class DemuxingProtocolHandler
extends ProtocolHandlerAdapter {
    private final Map type2handler = new HashMap();

    protected DemuxingProtocolHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageHandler addMessageHandler(Class type, MessageHandler handler) {
        Map map = this.type2handler;
        synchronized (map) {
            return this.type2handler.put(type, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageHandler removeMessageHandler(Class type) {
        Map map = this.type2handler;
        synchronized (map) {
            return (MessageHandler)this.type2handler.remove(type);
        }
    }

    public MessageHandler getMessageHandler(Class type) {
        return (MessageHandler)this.type2handler.get(type);
    }

    public Map getMessageHandlerMap() {
        return Collections.unmodifiableMap(this.type2handler);
    }

    public void messageReceived(ProtocolSession session, Object message) throws Exception {
        MessageHandler handler = this.findHandler(message.getClass());
        if (handler == null) {
            throw new UnknownMessageTypeException("No message handler found for message: " + message);
        }
        handler.messageReceived(session, message);
    }

    private MessageHandler findHandler(Class type) {
        MessageHandler handler = (MessageHandler)this.type2handler.get(type);
        if (handler == null) {
            handler = this.findHandler(type, new HashSet());
        }
        return handler;
    }

    private MessageHandler findHandler(Class type, Set triedClasses) {
        if (triedClasses.contains(type)) {
            return null;
        }
        triedClasses.add(type);
        MessageHandler handler = (MessageHandler)this.type2handler.get(type);
        if (handler == null) {
            handler = this.findHandler(type, triedClasses);
            if (handler != null) {
                return handler;
            }
            Class<?>[] interfaces = type.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                handler = this.findHandler(interfaces[i], triedClasses);
                if (handler == null) continue;
                return handler;
            }
            return null;
        }
        return handler;
    }
}

