/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.BaseSession;
import org.apache.mina.common.SessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.protocol.ProtocolDecoder;
import org.apache.mina.protocol.ProtocolEncoder;
import org.apache.mina.protocol.ProtocolFilterChain;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.ProtocolSessionFilterChain;
import org.apache.mina.protocol.vmpipe.VmPipeAcceptor;
import org.apache.mina.protocol.vmpipe.VmPipeSessionConfig;
import org.apache.mina.protocol.vmpipe.VmPipeSessionManagerFilterChain;
import org.apache.mina.util.ExceptionUtil;

class VmPipeSession
extends BaseSession
implements ProtocolSession {
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final ProtocolHandler handler;
    private final VmPipeSessionConfig config = new VmPipeSessionConfig();
    private final ProtocolSessionFilterChain filterChain;
    private final VmPipeSessionManagerFilterChain managerFilterChain;
    final VmPipeSession remoteSession;
    final Object lock;
    boolean closed;

    VmPipeSession(Object lock, SocketAddress localAddress, VmPipeSessionManagerFilterChain managerFilterChain, ProtocolHandler handler, VmPipeAcceptor.Entry remoteEntry) throws IOException {
        this.lock = lock;
        this.localAddress = localAddress;
        this.remoteAddress = remoteEntry.address;
        this.handler = handler;
        this.filterChain = new ProtocolSessionFilterChain(managerFilterChain);
        this.managerFilterChain = managerFilterChain;
        this.remoteSession = new VmPipeSession(this, remoteEntry);
        try {
            remoteEntry.handler.sessionCreated(this.remoteSession);
        }
        catch (Throwable t) {
            remoteEntry.acceptor.getExceptionMonitor().exceptionCaught(remoteEntry.acceptor, t);
            IOException e = new IOException("Failed to initialize remote session.");
            e.initCause(t);
            throw e;
        }
        try {
            handler.sessionCreated(this);
        }
        catch (Throwable t) {
            ExceptionUtil.throwException(t);
        }
        remoteEntry.managerFilterChain.sessionOpened(this.remoteSession);
        managerFilterChain.sessionOpened(this);
    }

    VmPipeSession(VmPipeSession remoteSession, VmPipeAcceptor.Entry entry) {
        this.lock = remoteSession.lock;
        this.localAddress = remoteSession.remoteAddress;
        this.remoteAddress = remoteSession.localAddress;
        this.handler = entry.handler;
        this.managerFilterChain = entry.managerFilterChain;
        this.filterChain = new ProtocolSessionFilterChain(entry.managerFilterChain);
        this.remoteSession = remoteSession;
    }

    VmPipeSessionManagerFilterChain getManagerFilterChain() {
        return this.managerFilterChain;
    }

    public ProtocolFilterChain getFilterChain() {
        return this.filterChain;
    }

    public ProtocolHandler getHandler() {
        return this.handler;
    }

    public ProtocolEncoder getEncoder() {
        return null;
    }

    public ProtocolDecoder getDecoder() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean wait) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.remoteSession.closed = true;
            this.closed = true;
            this.managerFilterChain.sessionClosed(this);
            this.remoteSession.getManagerFilterChain().sessionClosed(this.remoteSession);
        }
    }

    public void write(Object message) {
        this.filterChain.filterWrite(this, message);
    }

    public int getScheduledWriteRequests() {
        return 0;
    }

    public TransportType getTransportType() {
        return TransportType.VM_PIPE;
    }

    public boolean isConnected() {
        return !this.closed;
    }

    public SessionConfig getConfig() {
        return this.config;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }
}

