/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import org.apache.mina.common.Session;
import org.apache.mina.io.IoSession;
import org.apache.mina.protocol.ProtocolSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionLog {
    public static final String PREFIX = SessionLog.class.getName() + ".prefix";
    public static final String LOGGER = SessionLog.class.getName() + ".logger";

    public static Logger getLogger(Session session) {
        Logger log = (Logger)session.getAttribute(LOGGER);
        if (log == null) {
            log = LoggerFactory.getLogger((Class)SessionLog.getClass(session));
            String prefix = (String)session.getAttribute(PREFIX);
            if (prefix == null) {
                prefix = "[" + session.getRemoteAddress() + "] ";
                session.setAttribute(PREFIX, prefix);
            }
            session.setAttribute(LOGGER, log);
        }
        return log;
    }

    private static Class getClass(Session session) {
        if (session instanceof IoSession) {
            return ((IoSession)session).getHandler().getClass();
        }
        return ((ProtocolSession)session).getHandler().getClass();
    }

    public static void debug(Session session, String message) {
        Logger log = SessionLog.getLogger(session);
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(session.getAttribute(PREFIX)) + message);
        }
    }

    public static void debug(Session session, String message, Throwable cause) {
        Logger log = SessionLog.getLogger(session);
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(session.getAttribute(PREFIX)) + message, cause);
        }
    }

    public static void info(Session session, String message) {
        Logger log = SessionLog.getLogger(session);
        if (log.isInfoEnabled()) {
            log.info(String.valueOf(session.getAttribute(PREFIX)) + message);
        }
    }

    public static void info(Session session, String message, Throwable cause) {
        Logger log = SessionLog.getLogger(session);
        if (log.isInfoEnabled()) {
            log.info(String.valueOf(session.getAttribute(PREFIX)) + message, cause);
        }
    }

    public static void warn(Session session, String message) {
        Logger log = SessionLog.getLogger(session);
        if (log.isWarnEnabled()) {
            log.warn(String.valueOf(session.getAttribute(PREFIX)) + message);
        }
    }

    public static void warn(Session session, String message, Throwable cause) {
        Logger log = SessionLog.getLogger(session);
        if (log.isWarnEnabled()) {
            log.warn(String.valueOf(session.getAttribute(PREFIX)) + message, cause);
        }
    }

    public static void error(Session session, String message) {
        Logger log = SessionLog.getLogger(session);
        if (log.isErrorEnabled()) {
            log.error(String.valueOf(session.getAttribute(PREFIX)) + message);
        }
    }

    public static void error(Session session, String message, Throwable cause) {
        Logger log = SessionLog.getLogger(session);
        if (log.isErrorEnabled()) {
            log.error(String.valueOf(session.getAttribute(PREFIX)) + message, cause);
        }
    }
}

