/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.Session;

public abstract class BaseSession
implements Session {
    private final Map attributes = new HashMap();
    private final long creationTime;
    private long readBytes;
    private long writtenBytes;
    private long writtenWriteRequests;
    private long lastReadTime;
    private long lastWriteTime;
    private int idleCountForBoth;
    private int idleCountForRead;
    private int idleCountForWrite;
    private long lastIdleTimeForBoth;
    private long lastIdleTimeForRead = this.lastIdleTimeForWrite = System.currentTimeMillis();
    private long lastIdleTimeForWrite;

    protected BaseSession() {
        this.lastIdleTimeForBoth = this.lastIdleTimeForWrite;
        this.lastWriteTime = this.lastIdleTimeForWrite;
        this.lastReadTime = this.lastIdleTimeForWrite;
        this.creationTime = this.lastIdleTimeForWrite;
    }

    public void close() {
        this.close(false);
    }

    public Object getAttachment() {
        return this.attributes.get("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttachment(Object attachment) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.put("", attachment);
        }
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttribute(String key, Object value) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAttribute(String key) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAttributeKeys() {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.keySet();
        }
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    public long getWrittenWriteRequests() {
        return this.writtenWriteRequests;
    }

    public void increaseReadBytes(int increment) {
        this.readBytes += (long)increment;
        this.lastReadTime = System.currentTimeMillis();
    }

    public void increaseWrittenBytes(int increment) {
        this.writtenBytes += (long)increment;
        this.lastWriteTime = System.currentTimeMillis();
    }

    public void increaseWrittenWriteRequests() {
        ++this.writtenWriteRequests;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastIoTime() {
        return Math.max(this.lastReadTime, this.lastWriteTime);
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public boolean isIdle(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleCountForBoth > 0;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleCountForRead > 0;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleCountForWrite > 0;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    public int getIdleCount(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleCountForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleCountForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleCountForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    public long getLastIdleTime(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.lastIdleTimeForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.lastIdleTimeForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.lastIdleTimeForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    public void increaseIdleCount(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            ++this.idleCountForBoth;
            this.lastIdleTimeForBoth = System.currentTimeMillis();
        } else if (status == IdleStatus.READER_IDLE) {
            ++this.idleCountForRead;
            this.lastIdleTimeForRead = System.currentTimeMillis();
        } else if (status == IdleStatus.WRITER_IDLE) {
            ++this.idleCountForWrite;
            this.lastIdleTimeForWrite = System.currentTimeMillis();
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + status);
        }
    }

    public void resetIdleCount(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            this.idleCountForBoth = 0;
        } else if (status == IdleStatus.READER_IDLE) {
            this.idleCountForRead = 0;
        } else if (status == IdleStatus.WRITER_IDLE) {
            this.idleCountForWrite = 0;
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + status);
        }
    }
}

