/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.echoserver;

import org.apache.mina.common.TransportType;
import org.apache.mina.examples.echoserver.EchoProtocolHandler;
import org.apache.mina.examples.echoserver.ssl.BogusSSLContextFactory;
import org.apache.mina.io.IoAcceptor;
import org.apache.mina.io.filter.IoLoggingFilter;
import org.apache.mina.io.filter.SSLFilter;
import org.apache.mina.registry.Service;
import org.apache.mina.registry.ServiceRegistry;
import org.apache.mina.registry.SimpleServiceRegistry;

public class Main {
    private static final int PORT = 8080;
    private static final boolean USE_SSL = false;

    public static void main(String[] args) throws Exception {
        SimpleServiceRegistry registry = new SimpleServiceRegistry();
        Main.addLogger(registry);
        Service service = new Service("echo", TransportType.SOCKET, 8080);
        registry.bind(service, new EchoProtocolHandler());
        System.out.println("Listening on port 8080");
    }

    private static void addSSLSupport(ServiceRegistry registry) throws Exception {
        SSLFilter sslFilter = new SSLFilter(BogusSSLContextFactory.getInstance(true));
        IoAcceptor acceptor = registry.getIoAcceptor(TransportType.SOCKET);
        acceptor.getFilterChain().addLast("sslFilter", sslFilter);
        System.out.println("SSL ON");
    }

    private static void addLogger(ServiceRegistry registry) {
        IoAcceptor acceptor = registry.getIoAcceptor(TransportType.SOCKET);
        acceptor.getFilterChain().addLast("logger", new IoLoggingFilter());
        System.out.println("Logging ON");
    }
}

