/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup.codec;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.examples.sumup.message.AbstractMessage;
import org.apache.mina.protocol.ProtocolEncoderOutput;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.ProtocolViolationException;
import org.apache.mina.protocol.codec.MessageEncoder;

public abstract class AbstractMessageEncoder
implements MessageEncoder {
    private final int type;

    protected AbstractMessageEncoder(int type) {
        this.type = type;
    }

    public void encode(ProtocolSession session, Object message, ProtocolEncoderOutput out) throws ProtocolViolationException {
        AbstractMessage m = (AbstractMessage)message;
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.setAutoExpand(true);
        buf.putShort((short)this.type);
        buf.putInt(m.getSequence());
        this.encodeBody(session, m, buf);
        buf.flip();
        out.write(buf);
    }

    protected abstract void encodeBody(ProtocolSession var1, AbstractMessage var2, ByteBuffer var3);
}

