/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.registry;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.TransportType;
import org.apache.mina.protocol.vmpipe.VmPipeAddress;

public class Service
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3258407344110383155L;
    private final String name;
    private final TransportType transportType;
    private final SocketAddress address;

    public Service(String name, TransportType transportType, int port) {
        this(name, transportType, new InetSocketAddress(port));
    }

    public Service(String name, TransportType transportType, SocketAddress address) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (transportType == null) {
            throw new NullPointerException("transportType");
        }
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (transportType == TransportType.VM_PIPE && !(address instanceof VmPipeAddress)) {
            throw new IllegalArgumentException("VM_PIPE transport type accepts only VmPipeAddress: " + address.getClass());
        }
        this.name = name;
        this.transportType = transportType;
        this.address = address;
    }

    public String getName() {
        return this.name;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public int hashCode() {
        return this.name.hashCode() * 37 ^ this.transportType.hashCode() * 37 ^ this.address.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Service)) {
            return false;
        }
        Service that = (Service)o;
        return this.name.equals(that.name) && this.transportType == that.transportType && this.address.equals(that.address);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return "(" + this.transportType + ", " + this.name + ", " + this.address + ')';
    }
}

