/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import jcmdline.AbstractParameter;
import jcmdline.CmdLineException;
import jcmdline.OptionTakesNoValue;
import jcmdline.Strings;

public class BooleanParam
extends AbstractParameter
implements OptionTakesNoValue {
    private String trueValue = Strings.get("BooleanParam.true");
    private String falseValue = Strings.get("BooleanParam.false");

    public BooleanParam(String tag, String desc) {
        this(tag, desc, false);
    }

    public BooleanParam(String tag, String desc, boolean hidden) {
        this.setTag(tag);
        this.setDesc(desc);
        this.setOptional(this.optional);
        this.setMultiValued(false);
        this.setHidden(hidden);
        this.setOptionLabel("");
        this.setAcceptableValues(new String[]{this.trueValue, this.falseValue});
        try {
            this.addValue(this.falseValue);
            this.set = false;
        }
        catch (Exception e) {
            throw new RuntimeException(Strings.get("BooleanParam.setValueProgError"));
        }
    }

    public void addValue(String value) throws CmdLineException {
        this.validateValue(value);
        this.values.clear();
        this.values.add(value);
        this.set = true;
    }

    public String getDefaultValue() {
        return this.trueValue;
    }

    public boolean isTrue() {
        return this.values.get(0).equals(this.trueValue);
    }

    public void validateValue(String value) throws CmdLineException {
        super.validateValue(value);
    }
}

