/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.AddressFromPublicKeyScriptResult;
import fr.acinq.bitcoin.AddressToPublicKeyScriptResult;
import fr.acinq.bitcoin.Base58Check;
import fr.acinq.bitcoin.Bech32;
import fr.acinq.bitcoin.Block;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.OP_0;
import fr.acinq.bitcoin.OP_1;
import fr.acinq.bitcoin.OP_10;
import fr.acinq.bitcoin.OP_11;
import fr.acinq.bitcoin.OP_12;
import fr.acinq.bitcoin.OP_13;
import fr.acinq.bitcoin.OP_14;
import fr.acinq.bitcoin.OP_15;
import fr.acinq.bitcoin.OP_16;
import fr.acinq.bitcoin.OP_2;
import fr.acinq.bitcoin.OP_3;
import fr.acinq.bitcoin.OP_4;
import fr.acinq.bitcoin.OP_5;
import fr.acinq.bitcoin.OP_6;
import fr.acinq.bitcoin.OP_7;
import fr.acinq.bitcoin.OP_8;
import fr.acinq.bitcoin.OP_9;
import fr.acinq.bitcoin.OP_EQUAL;
import fr.acinq.bitcoin.OP_HASH160;
import fr.acinq.bitcoin.OP_PUSHDATA;
import fr.acinq.bitcoin.PublicKey;
import fr.acinq.bitcoin.Script;
import fr.acinq.bitcoin.ScriptElt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0017"}, d2={"Lfr/acinq/bitcoin/Bitcoin;", "", "()V", "addressFromPublicKeyScript", "Lfr/acinq/bitcoin/AddressFromPublicKeyScriptResult;", "chainHash", "Lfr/acinq/bitcoin/ByteVector32;", "pubkeyScript", "", "", "Lfr/acinq/bitcoin/ScriptElt;", "addressToPublicKeyScript", "Lfr/acinq/bitcoin/AddressToPublicKeyScriptResult;", "address", "", "computeBIP44Address", "pub", "Lfr/acinq/bitcoin/PublicKey;", "computeBIP49Address", "computeBIP84Address", "computeP2PkhAddress", "computeP2ShOfP2WpkhAddress", "computeP2WpkhAddress", "bitcoin-kmp"})
@SourceDebugExtension(value={"SMAP\nBitcoin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bitcoin.kt\nfr/acinq/bitcoin/Bitcoin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
public final class Bitcoin {
    @NotNull
    public static final Bitcoin INSTANCE = new Bitcoin();

    private Bitcoin() {
    }

    @JvmStatic
    @NotNull
    public static final String computeP2PkhAddress(@NotNull PublicKey pub, @NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return pub.p2pkhAddress(chainHash);
    }

    @JvmStatic
    @NotNull
    public static final String computeBIP44Address(@NotNull PublicKey pub, @NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return Bitcoin.computeP2PkhAddress(pub, chainHash);
    }

    @JvmStatic
    @NotNull
    public static final String computeP2ShOfP2WpkhAddress(@NotNull PublicKey pub, @NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return pub.p2shOfP2wpkhAddress(chainHash);
    }

    @JvmStatic
    @NotNull
    public static final String computeBIP49Address(@NotNull PublicKey pub, @NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return Bitcoin.computeP2ShOfP2WpkhAddress(pub, chainHash);
    }

    @JvmStatic
    @NotNull
    public static final String computeP2WpkhAddress(@NotNull PublicKey pub, @NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return pub.p2wpkhAddress(chainHash);
    }

    @JvmStatic
    @NotNull
    public static final String computeBIP84Address(@NotNull PublicKey pub, @NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return Bitcoin.computeP2WpkhAddress(pub, chainHash);
    }

    @JvmStatic
    @NotNull
    public static final AddressFromPublicKeyScriptResult addressFromPublicKeyScript(@NotNull ByteVector32 chainHash, @NotNull List<? extends ScriptElt> pubkeyScript) {
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        Intrinsics.checkNotNullParameter(pubkeyScript, (String)"pubkeyScript");
        try {
            AddressFromPublicKeyScriptResult addressFromPublicKeyScriptResult;
            if (Script.isPay2pkh(pubkeyScript)) {
                byte by;
                ByteVector32 byteVector32 = chainHash;
                if (Intrinsics.areEqual((Object)byteVector32, (Object)Block.LivenetGenesisBlock.hash)) {
                    by = 0;
                } else if ((Intrinsics.areEqual((Object)byteVector32, (Object)Block.TestnetGenesisBlock.hash) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.RegtestGenesisBlock.hash)) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.SignetGenesisBlock.hash)) {
                    by = 111;
                } else {
                    return AddressFromPublicKeyScriptResult.Failure.InvalidChainHash.INSTANCE;
                }
                byte prefix = by;
                ScriptElt scriptElt = pubkeyScript.get(2);
                Intrinsics.checkNotNull((Object)scriptElt, (String)"null cannot be cast to non-null type fr.acinq.bitcoin.OP_PUSHDATA");
                addressFromPublicKeyScriptResult = new AddressFromPublicKeyScriptResult.Success(Base58Check.encode(prefix, ((OP_PUSHDATA)scriptElt).data));
            } else if (Script.isPay2sh(pubkeyScript)) {
                byte by;
                ByteVector32 byteVector32 = chainHash;
                if (Intrinsics.areEqual((Object)byteVector32, (Object)Block.LivenetGenesisBlock.hash)) {
                    by = 5;
                } else if ((Intrinsics.areEqual((Object)byteVector32, (Object)Block.TestnetGenesisBlock.hash) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.RegtestGenesisBlock.hash)) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.SignetGenesisBlock.hash)) {
                    by = -60;
                } else {
                    return AddressFromPublicKeyScriptResult.Failure.InvalidChainHash.INSTANCE;
                }
                byte prefix = by;
                ScriptElt scriptElt = pubkeyScript.get(1);
                Intrinsics.checkNotNull((Object)scriptElt, (String)"null cannot be cast to non-null type fr.acinq.bitcoin.OP_PUSHDATA");
                addressFromPublicKeyScriptResult = new AddressFromPublicKeyScriptResult.Success(Base58Check.encode(prefix, ((OP_PUSHDATA)scriptElt).data));
            } else if (Script.isNativeWitnessScript(pubkeyScript)) {
                String hrp = Bech32.hrp(chainHash);
                ScriptElt scriptElt = pubkeyScript.get(1);
                Intrinsics.checkNotNull((Object)scriptElt, (String)"null cannot be cast to non-null type fr.acinq.bitcoin.OP_PUSHDATA");
                byte[] witnessScript = ((OP_PUSHDATA)scriptElt).data.toByteArray();
                ScriptElt scriptElt2 = pubkeyScript.get(0);
                addressFromPublicKeyScriptResult = scriptElt2 instanceof OP_0 ? (Script.isPay2wpkh(pubkeyScript) || Script.isPay2wsh(pubkeyScript) ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)0, witnessScript)) : (AddressFromPublicKeyScriptResult)AddressFromPublicKeyScriptResult.Failure.InvalidScript.INSTANCE) : (scriptElt2 instanceof OP_1 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)1, witnessScript)) : (scriptElt2 instanceof OP_2 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)2, witnessScript)) : (scriptElt2 instanceof OP_3 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)3, witnessScript)) : (scriptElt2 instanceof OP_4 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)4, witnessScript)) : (scriptElt2 instanceof OP_5 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)5, witnessScript)) : (scriptElt2 instanceof OP_6 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)6, witnessScript)) : (scriptElt2 instanceof OP_7 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)7, witnessScript)) : (scriptElt2 instanceof OP_8 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)8, witnessScript)) : (scriptElt2 instanceof OP_9 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)9, witnessScript)) : (scriptElt2 instanceof OP_10 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)10, witnessScript)) : (scriptElt2 instanceof OP_11 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)11, witnessScript)) : (scriptElt2 instanceof OP_12 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)12, witnessScript)) : (scriptElt2 instanceof OP_13 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)13, witnessScript)) : (scriptElt2 instanceof OP_14 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)14, witnessScript)) : (scriptElt2 instanceof OP_15 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)15, witnessScript)) : (scriptElt2 instanceof OP_16 ? (AddressFromPublicKeyScriptResult)new AddressFromPublicKeyScriptResult.Success(Bech32.encodeWitnessAddress(hrp, (byte)16, witnessScript)) : (AddressFromPublicKeyScriptResult)AddressFromPublicKeyScriptResult.Failure.InvalidScript.INSTANCE))))))))))))))));
            } else {
                addressFromPublicKeyScriptResult = AddressFromPublicKeyScriptResult.Failure.InvalidScript.INSTANCE;
            }
            return addressFromPublicKeyScriptResult;
        }
        catch (Throwable t) {
            return new AddressFromPublicKeyScriptResult.Failure.GenericError(t);
        }
    }

    @JvmStatic
    @NotNull
    public static final AddressFromPublicKeyScriptResult addressFromPublicKeyScript(@NotNull ByteVector32 chainHash, @NotNull byte[] pubkeyScript) {
        AddressFromPublicKeyScriptResult addressFromPublicKeyScriptResult;
        Object it;
        Object $this$addressFromPublicKeyScript_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        Intrinsics.checkNotNullParameter((Object)pubkeyScript, (String)"pubkeyScript");
        Object object = INSTANCE;
        try {
            $this$addressFromPublicKeyScript_u24lambda_u240 = object;
            boolean bl = false;
            $this$addressFromPublicKeyScript_u24lambda_u240 = Result.constructor-impl(Script.parse(pubkeyScript));
        }
        catch (Throwable bl) {
            $this$addressFromPublicKeyScript_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$addressFromPublicKeyScript_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            it = (List)object;
            boolean bl = false;
            addressFromPublicKeyScriptResult = Bitcoin.addressFromPublicKeyScript(chainHash, (List<? extends ScriptElt>)it);
        } else {
            it = throwable;
            boolean bl = false;
            addressFromPublicKeyScriptResult = AddressFromPublicKeyScriptResult.Failure.InvalidScript.INSTANCE;
        }
        return addressFromPublicKeyScriptResult;
    }

    @JvmStatic
    @NotNull
    public static final AddressToPublicKeyScriptResult addressToPublicKeyScript(@NotNull ByteVector32 chainHash, @NotNull String address) {
        AddressToPublicKeyScriptResult addressToPublicKeyScriptResult;
        Object $this$addressToPublicKeyScript_u24lambda_u243;
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Object object = new Pair[]{TuplesKt.to((Object)0, (Object)OP_0.INSTANCE), TuplesKt.to((Object)1, (Object)OP_1.INSTANCE), TuplesKt.to((Object)2, (Object)OP_2.INSTANCE), TuplesKt.to((Object)3, (Object)OP_3.INSTANCE), TuplesKt.to((Object)4, (Object)OP_4.INSTANCE), TuplesKt.to((Object)5, (Object)OP_5.INSTANCE), TuplesKt.to((Object)6, (Object)OP_6.INSTANCE), TuplesKt.to((Object)7, (Object)OP_7.INSTANCE), TuplesKt.to((Object)8, (Object)OP_8.INSTANCE), TuplesKt.to((Object)9, (Object)OP_9.INSTANCE), TuplesKt.to((Object)10, (Object)OP_10.INSTANCE), TuplesKt.to((Object)11, (Object)OP_11.INSTANCE), TuplesKt.to((Object)12, (Object)OP_12.INSTANCE), TuplesKt.to((Object)13, (Object)OP_13.INSTANCE), TuplesKt.to((Object)14, (Object)OP_14.INSTANCE), TuplesKt.to((Object)15, (Object)OP_15.INSTANCE), TuplesKt.to((Object)16, (Object)OP_16.INSTANCE)};
        Map witnessVersions = MapsKt.mapOf((Pair[])object);
        object = INSTANCE;
        try {
            $this$addressToPublicKeyScript_u24lambda_u243 = object;
            boolean bl = false;
            $this$addressToPublicKeyScript_u24lambda_u243 = Result.constructor-impl(Base58Check.decode(address));
        }
        catch (Throwable bl) {
            $this$addressToPublicKeyScript_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$addressToPublicKeyScript_u24lambda_u243;
        if (Result.exceptionOrNull-impl((Object)object) == null) {
            Pair it = (Pair)object;
            boolean bl = false;
            if (((Number)it.getFirst()).byteValue() == 111 && (Intrinsics.areEqual((Object)chainHash, (Object)Block.TestnetGenesisBlock.hash) || Intrinsics.areEqual((Object)chainHash, (Object)Block.RegtestGenesisBlock.hash) || Intrinsics.areEqual((Object)chainHash, (Object)Block.SignetGenesisBlock.hash))) {
                addressToPublicKeyScriptResult = new AddressToPublicKeyScriptResult.Success(Script.pay2pkh((byte[])it.getSecond()));
            } else if (((Number)it.getFirst()).byteValue() == 0 && Intrinsics.areEqual((Object)chainHash, (Object)Block.LivenetGenesisBlock.hash)) {
                addressToPublicKeyScriptResult = new AddressToPublicKeyScriptResult.Success(Script.pay2pkh((byte[])it.getSecond()));
            } else if (((Number)it.getFirst()).byteValue() == -60 && (Intrinsics.areEqual((Object)chainHash, (Object)Block.TestnetGenesisBlock.hash) || Intrinsics.areEqual((Object)chainHash, (Object)Block.RegtestGenesisBlock.hash) || Intrinsics.areEqual((Object)chainHash, (Object)Block.SignetGenesisBlock.hash))) {
                Object[] objectArray = new ScriptElt[]{OP_HASH160.INSTANCE, new OP_PUSHDATA((byte[])it.getSecond()), OP_EQUAL.INSTANCE};
                addressToPublicKeyScriptResult = new AddressToPublicKeyScriptResult.Success(CollectionsKt.listOf((Object[])objectArray));
            } else if (((Number)it.getFirst()).byteValue() == 5 && Intrinsics.areEqual((Object)chainHash, (Object)Block.LivenetGenesisBlock.hash)) {
                Object[] objectArray = new ScriptElt[]{OP_HASH160.INSTANCE, new OP_PUSHDATA((byte[])it.getSecond()), OP_EQUAL.INSTANCE};
                addressToPublicKeyScriptResult = new AddressToPublicKeyScriptResult.Success(CollectionsKt.listOf((Object[])objectArray));
            } else {
                addressToPublicKeyScriptResult = AddressToPublicKeyScriptResult.Failure.ChainHashMismatch.INSTANCE;
            }
        } else {
            Throwable it;
            Object $this$addressToPublicKeyScript_u24lambda_u248_u24lambda_u245;
            boolean bl = false;
            Object object2 = INSTANCE;
            try {
                $this$addressToPublicKeyScript_u24lambda_u248_u24lambda_u245 = object2;
                boolean bl2 = false;
                $this$addressToPublicKeyScript_u24lambda_u248_u24lambda_u245 = Result.constructor-impl(Bech32.decodeWitnessAddress(address));
            }
            catch (Throwable bl2) {
                $this$addressToPublicKeyScript_u24lambda_u248_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = $this$addressToPublicKeyScript_u24lambda_u248_u24lambda_u245;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) {
                it = (Triple)object2;
                boolean bl3 = false;
                ScriptElt witnessVersion = (ScriptElt)witnessVersions.get(it.getSecond());
                if (witnessVersion == null) {
                    addressToPublicKeyScriptResult = new AddressToPublicKeyScriptResult.Failure.InvalidWitnessVersion(((Number)it.getSecond()).byteValue());
                } else if (((byte[])it.getThird()).length != 20 && ((byte[])it.getThird()).length != 32) {
                    addressToPublicKeyScriptResult = AddressToPublicKeyScriptResult.Failure.InvalidBech32Address.INSTANCE;
                } else if (Intrinsics.areEqual((Object)it.getFirst(), (Object)"bc") && Intrinsics.areEqual((Object)chainHash, (Object)Block.LivenetGenesisBlock.hash)) {
                    Object[] objectArray = new ScriptElt[]{witnessVersion, new OP_PUSHDATA((byte[])it.getThird())};
                    addressToPublicKeyScriptResult = new AddressToPublicKeyScriptResult.Success(CollectionsKt.listOf((Object[])objectArray));
                } else if (Intrinsics.areEqual((Object)it.getFirst(), (Object)"tb") && Intrinsics.areEqual((Object)chainHash, (Object)Block.TestnetGenesisBlock.hash)) {
                    Object[] objectArray = new ScriptElt[]{witnessVersion, new OP_PUSHDATA((byte[])it.getThird())};
                    addressToPublicKeyScriptResult = new AddressToPublicKeyScriptResult.Success(CollectionsKt.listOf((Object[])objectArray));
                } else if (Intrinsics.areEqual((Object)it.getFirst(), (Object)"tb") && Intrinsics.areEqual((Object)chainHash, (Object)Block.SignetGenesisBlock.hash)) {
                    Object[] objectArray = new ScriptElt[]{witnessVersion, new OP_PUSHDATA((byte[])it.getThird())};
                    addressToPublicKeyScriptResult = new AddressToPublicKeyScriptResult.Success(CollectionsKt.listOf((Object[])objectArray));
                } else if (Intrinsics.areEqual((Object)it.getFirst(), (Object)"bcrt") && Intrinsics.areEqual((Object)chainHash, (Object)Block.RegtestGenesisBlock.hash)) {
                    Object[] objectArray = new ScriptElt[]{witnessVersion, new OP_PUSHDATA((byte[])it.getThird())};
                    addressToPublicKeyScriptResult = new AddressToPublicKeyScriptResult.Success(CollectionsKt.listOf((Object[])objectArray));
                } else {
                    addressToPublicKeyScriptResult = AddressToPublicKeyScriptResult.Failure.ChainHashMismatch.INSTANCE;
                }
            } else {
                it = throwable;
                boolean bl4 = false;
                addressToPublicKeyScriptResult = AddressToPublicKeyScriptResult.Failure.InvalidAddress.INSTANCE;
            }
        }
        return addressToPublicKeyScriptResult;
    }
}

