/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.secp256k1.Hex;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 :2\u00020\u0001:\u0001:B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003J\u0014\u0010\u0010\u001a\u00020\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0003J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tJ\u0013\u0010\u001d\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0011\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\tH\u0086\u0002J\b\u0010 \u001a\u00020\tH\u0016J\u0006\u0010!\u001a\u00020\u0017J1\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\u001e\u0010$\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H#0%\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\tJ\u000e\u0010*\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\tJ\u0011\u0010+\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010+\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\b\u0010,\u001a\u00020\u0000H\u0016J\u0006\u0010-\u001a\u00020\u0000J\u0006\u0010.\u001a\u00020/J\u0006\u0010\n\u001a\u00020\tJ\u0016\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\tJ\u000e\u00103\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tJ\u000e\u00104\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tJ\u0006\u00105\u001a\u00020\u0003J\u0006\u00106\u001a\u00020\u0006J\b\u00107\u001a\u00020\u0006H\u0016J\u0018\u00108\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\t2\u0006\u00109\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lfr/acinq/bitcoin/ByteVector;", "", "bytes", "", "([B)V", "input", "", "(Ljava/lang/String;)V", "offset", "", "size", "([BII)V", "getBytes$bitcoin_kmp", "()[B", "getOffset$bitcoin_kmp", "()I", "concat", "other", "value", "", "others", "", "contentEquals", "", "inputOffset", "inputSize", "drop", "n", "dropRight", "equals", "get", "i", "hashCode", "isEmpty", "map", "T", "f", "Lkotlin/Function3;", "(Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "or", "padLeft", "length", "padRight", "plus", "reversed", "ripemd160", "sha256", "Lfr/acinq/bitcoin/ByteVector32;", "slice", "from", "to", "take", "takeRight", "toByteArray", "toHex", "toString", "update", "b", "Companion", "bitcoin-kmp"})
@SourceDebugExtension(value={"SMAP\nByteVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteVector.kt\nfr/acinq/bitcoin/ByteVector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1#2:181\n1789#3,3:182\n*S KotlinDebug\n*F\n+ 1 ByteVector.kt\nfr/acinq/bitcoin/ByteVector\n*L\n87#1:182,3\n*E\n"})
public class ByteVector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] bytes;
    private final int offset;
    private final int size;
    @JvmField
    @NotNull
    public static final ByteVector empty = new ByteVector(new byte[0]);

    public ByteVector(@NotNull byte[] bytes, int offset, int size) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        this.offset = offset;
        this.size = size;
        if (!(this.offset >= 0)) {
            boolean $i$a$-require-ByteVector$42 = false;
            String $i$a$-require-ByteVector$42 = "offset (" + this.offset + ") must be > 0";
            throw new IllegalArgumentException($i$a$-require-ByteVector$42.toString());
        }
        if (!(this.size >= 0)) {
            boolean $i$a$-require-ByteVector$52 = false;
            String $i$a$-require-ByteVector$52 = "size (" + this.size + ") must be > 0";
            throw new IllegalArgumentException($i$a$-require-ByteVector$52.toString());
        }
        if (!(this.offset + this.size <= this.bytes.length)) {
            boolean bl = false;
            String string = "offset (" + this.offset + ") + size (" + this.size + ") must be <= buffer size (" + this.bytes.length + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final byte[] getBytes$bitcoin_kmp() {
        return this.bytes;
    }

    public final int getOffset$bitcoin_kmp() {
        return this.offset;
    }

    public ByteVector(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this(bytes, 0, bytes.length);
    }

    public ByteVector(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this(Hex.decode((String)input));
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final byte get(int i) {
        return this.bytes[this.offset + i];
    }

    @NotNull
    public final ByteVector take(int n) {
        return new ByteVector(this.bytes, this.offset, n);
    }

    @NotNull
    public final ByteVector drop(int n) {
        return new ByteVector(this.bytes, this.offset + n, this.size - n);
    }

    @NotNull
    public final ByteVector takeRight(int n) {
        return this.drop(this.size - n);
    }

    @NotNull
    public final ByteVector dropRight(int n) {
        return this.take(this.size - n);
    }

    @NotNull
    public final ByteVector slice(int from, int to) {
        return this.drop(from).take(to - from);
    }

    @NotNull
    public ByteVector update(int i, byte b) {
        byte[] newbytes = this.toByteArray();
        newbytes[i] = b;
        return new ByteVector(newbytes);
    }

    @NotNull
    public final ByteVector plus(@NotNull ByteVector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.concat(other);
    }

    @NotNull
    public final ByteVector plus(@NotNull byte[] other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.concat(other);
    }

    @NotNull
    public final ByteVector or(@NotNull ByteVector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.size == other.size)) {
            boolean $i$a$-require-ByteVector$or$22 = false;
            String $i$a$-require-ByteVector$or$22 = "cannot call or() on byte vectors of different sizes";
            throw new IllegalArgumentException($i$a$-require-ByteVector$or$22.toString());
        }
        byte[] data = this.toByteArray();
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = (byte)(data[i] | other.get(i));
        }
        return new ByteVector(data);
    }

    @NotNull
    public final ByteVector padLeft(int length) {
        if (!(this.size <= length)) {
            boolean bl = false;
            String string = "byte vector larger than padding target";
            throw new IllegalArgumentException(string.toString());
        }
        if (length == this.size) {
            return this;
        }
        return new ByteVector(ArraysKt.plus((byte[])new byte[length - this.size], (byte[])this.toByteArray()));
    }

    @NotNull
    public final ByteVector padRight(int length) {
        if (!(this.size <= length)) {
            boolean bl = false;
            String string = "byte vector larger than padding target";
            throw new IllegalArgumentException(string.toString());
        }
        if (length == this.size) {
            return this;
        }
        return new ByteVector(ArraysKt.plus((byte[])this.toByteArray(), (byte[])new byte[length - this.size]));
    }

    @NotNull
    public final ByteVector concat(byte value) {
        return new ByteVector(ArraysKt.plus((byte[])this.toByteArray(), (byte)value));
    }

    @NotNull
    public final ByteVector concat(@NotNull byte[] other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new ByteVector(ArraysKt.plus((byte[])this.toByteArray(), (byte[])other));
    }

    @NotNull
    public final ByteVector concat(@NotNull ByteVector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.concat(other.toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteVector concat(@NotNull List<? extends ByteVector> others) {
        Intrinsics.checkNotNullParameter(others, (String)"others");
        Iterable $this$fold$iv = others;
        boolean $i$f$fold = false;
        ByteVector accumulator$iv = this;
        for (Object element$iv : $this$fold$iv) {
            void next;
            ByteVector byteVector = (ByteVector)element$iv;
            ByteVector current = accumulator$iv;
            boolean bl = false;
            accumulator$iv = current.concat((ByteVector)next);
        }
        return accumulator$iv;
    }

    @NotNull
    public ByteVector reversed() {
        return new ByteVector(ArraysKt.reversedArray((byte[])this.toByteArray()));
    }

    public final boolean contentEquals(@NotNull byte[] input, int inputOffset, int inputSize) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (this.size != inputSize) {
            return false;
        }
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (this.bytes[this.offset + i] == input[inputOffset + i]) continue;
            return false;
        }
        return true;
    }

    public final boolean contentEquals(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.contentEquals(input, 0, input.length);
    }

    public final <T> T map(@NotNull Function3<? super byte[], ? super Integer, ? super Integer, ? extends T> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return (T)f.invoke((Object)this.bytes, (Object)this.offset, (Object)this.size);
    }

    @NotNull
    public final ByteVector32 sha256() {
        return (ByteVector32)this.map(sha256.1.INSTANCE);
    }

    @NotNull
    public final ByteVector ripemd160() {
        return (ByteVector)this.map(ripemd160.1.INSTANCE);
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = this.bytes;
        int n = this.offset;
        int n2 = this.offset + this.size;
        return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
    }

    @NotNull
    public final String toHex() {
        return Hex.encode((byte[])this.bytes, (int)this.offset, (int)this.size);
    }

    @NotNull
    public String toString() {
        return this.toHex();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ByteVector)) {
            return false;
        }
        return this.contentEquals(((ByteVector)other).bytes, ((ByteVector)other).offset, ((ByteVector)other).size);
    }

    public int hashCode() {
        int result = 1;
        int n = this.offset + this.size;
        for (int index = this.offset; index < n; ++index) {
            result = 31 * result + this.bytes[index];
        }
        return result;
    }

    @JvmStatic
    @NotNull
    public static final ByteVector fromHex(@NotNull String hex) {
        return Companion.fromHex(hex);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lfr/acinq/bitcoin/ByteVector$Companion;", "", "()V", "empty", "Lfr/acinq/bitcoin/ByteVector;", "fromHex", "hex", "", "bitcoin-kmp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ByteVector fromHex(@NotNull String hex) {
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            return new ByteVector(Hex.decode((String)hex));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

