/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.Base58Check;
import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.ByteVectorKt;
import fr.acinq.bitcoin.Crypto;
import fr.acinq.bitcoin.KeyPath;
import fr.acinq.bitcoin.PrivateKey;
import fr.acinq.bitcoin.PublicKey;
import fr.acinq.bitcoin.crypto.Pack;
import fr.acinq.bitcoin.io.ByteArrayInput;
import fr.acinq.bitcoin.io.ByteArrayOutput;
import fr.acinq.bitcoin.io.Input;
import fr.acinq.bitcoin.io.Output;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002./B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0018H\u0007J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aH\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0018H\u0007J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u001c2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aH\u0007J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0006H\u0007J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0006H\u0007J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0013H\u0007J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001cH\u0007J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0007J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020&H\u0007J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0010\u0010(\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0013H\u0007J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lfr/acinq/bitcoin/DeterministicWallet;", "", "()V", "hardenedKeyIndex", "", "tprv", "", "tpub", "uprv", "upub", "vprv", "vpub", "xprv", "xpub", "yprv", "ypub", "zprv", "zpub", "derivePrivateKey", "Lfr/acinq/bitcoin/DeterministicWallet$ExtendedPrivateKey;", "parent", "keyPath", "Lfr/acinq/bitcoin/KeyPath;", "index", "", "chain", "", "derivePublicKey", "Lfr/acinq/bitcoin/DeterministicWallet$ExtendedPublicKey;", "encode", "input", "testnet", "", "prefix", "fingerprint", "generate", "seed", "Lfr/acinq/bitcoin/ByteVector;", "", "hardened", "isHardened", "publicKey", "write", "", "out", "Lfr/acinq/bitcoin/io/Output;", "ExtendedPrivateKey", "ExtendedPublicKey", "bitcoin-kmp"})
@SourceDebugExtension(value={"SMAP\nDeterministicWallet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeterministicWallet.kt\nfr/acinq/bitcoin/DeterministicWallet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n1#2:344\n1789#3,3:345\n1789#3,3:348\n*S KotlinDebug\n*F\n+ 1 DeterministicWallet.kt\nfr/acinq/bitcoin/DeterministicWallet\n*L\n251#1:345,3\n263#1:348,3\n*E\n"})
public final class DeterministicWallet {
    @NotNull
    public static final DeterministicWallet INSTANCE = new DeterministicWallet();
    public static final long hardenedKeyIndex = 0x80000000L;
    public static final int xprv = 76066276;
    public static final int xpub = 76067358;
    public static final int yprv = 77428856;
    public static final int ypub = 77429938;
    public static final int zprv = 78791436;
    public static final int zpub = 78792518;
    public static final int tprv = 70615956;
    public static final int tpub = 70617039;
    public static final int uprv = 71978536;
    public static final int upub = 71979618;
    public static final int vprv = 73341116;
    public static final int vpub = 73342198;

    private DeterministicWallet() {
    }

    @JvmStatic
    public static final long hardened(long index) {
        return 0x80000000L + index;
    }

    @JvmStatic
    public static final boolean isHardened(long index) {
        return index >= 0x80000000L;
    }

    @JvmStatic
    @NotNull
    public static final String encode(@NotNull ExtendedPrivateKey input, boolean testnet) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return DeterministicWallet.encode(input, testnet ? 70615956 : 76066276);
    }

    @JvmStatic
    @NotNull
    public static final String encode(@NotNull ExtendedPrivateKey input, int prefix) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ByteArrayOutput out = new ByteArrayOutput();
        out.write(input.depth);
        Pack.writeInt32BE((int)input.parent, out);
        Pack.writeInt32BE((int)input.path.getLastChildNumber(), out);
        Output.DefaultImpls.write$default(out, input.chaincode.toByteArray(), 0, 0, 6, null);
        out.write(0);
        Output.DefaultImpls.write$default(out, input.secretkeybytes.toByteArray(), 0, 0, 6, null);
        byte[] buffer = out.toByteArray();
        return Base58Check.encode(prefix, buffer);
    }

    @JvmStatic
    @NotNull
    public static final String encode(@NotNull ExtendedPublicKey input, boolean testnet) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return DeterministicWallet.encode(input, testnet ? 70617039 : 76067358);
    }

    @JvmStatic
    @NotNull
    public static final String encode(@NotNull ExtendedPublicKey input, int prefix) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ByteArrayOutput out = new ByteArrayOutput();
        DeterministicWallet.write(input, out);
        byte[] buffer = out.toByteArray();
        return Base58Check.encode(prefix, buffer);
    }

    @JvmStatic
    public static final void write(@NotNull ExtendedPublicKey input, @NotNull Output out) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.write(input.depth);
        Pack.writeInt32BE((int)input.parent, out);
        Pack.writeInt32BE((int)input.path.getLastChildNumber(), out);
        Output.DefaultImpls.write$default(out, input.chaincode.toByteArray(), 0, 0, 6, null);
        Output.DefaultImpls.write$default(out, input.publickeybytes.toByteArray(), 0, 0, 6, null);
    }

    @JvmStatic
    @NotNull
    public static final ExtendedPrivateKey generate(@NotNull byte[] seed) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        byte[] I = Crypto.hmac512(StringsKt.encodeToByteArray((String)"Bitcoin seed"), seed);
        ByteVector32 IL = ByteVectorKt.byteVector32(CollectionsKt.toByteArray((Collection)ArraysKt.take((byte[])I, (int)32)));
        ByteVector32 IR = ByteVectorKt.byteVector32(CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])I, (int)32)));
        return new ExtendedPrivateKey(IL, IR, 0, KeyPath.Companion.getEmpty(), 0L);
    }

    @JvmStatic
    @NotNull
    public static final ExtendedPrivateKey generate(@NotNull ByteVector seed) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        return DeterministicWallet.generate(seed.toByteArray());
    }

    @JvmStatic
    @NotNull
    public static final ExtendedPublicKey publicKey(@NotNull ExtendedPrivateKey input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new ExtendedPublicKey(input.getPublicKey().value, input.chaincode, input.depth, input.path, input.parent);
    }

    @JvmStatic
    public static final long fingerprint(@NotNull ExtendedPublicKey input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return Pack.int32LE(new ByteArrayInput(CollectionsKt.toByteArray((Collection)CollectionsKt.reversed((Iterable)ArraysKt.take((byte[])Crypto.hash160(input.publickeybytes), (int)4)))));
    }

    @JvmStatic
    public static final long fingerprint(@NotNull ExtendedPrivateKey input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return DeterministicWallet.fingerprint(DeterministicWallet.publicKey(input));
    }

    @JvmStatic
    @NotNull
    public static final ExtendedPrivateKey derivePrivateKey(@NotNull ExtendedPrivateKey parent, long index) {
        byte[] byArray;
        byte[] data;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (DeterministicWallet.isHardened(index)) {
            Byte[] byteArray = new Byte[]{(byte)0};
            data = ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.toByteArray((Byte[])byteArray), (byte[])parent.secretkeybytes.toByteArray()), (byte[])Pack.writeInt32BE((int)index));
            byArray = Crypto.hmac512(parent.chaincode.toByteArray(), data);
        } else {
            data = ArraysKt.plus((byte[])DeterministicWallet.publicKey((ExtendedPrivateKey)parent).publickeybytes.toByteArray(), (byte[])Pack.writeInt32BE((int)index));
            byArray = Crypto.hmac512(parent.chaincode.toByteArray(), data);
        }
        byte[] I = byArray;
        byte[] IL = CollectionsKt.toByteArray((Collection)ArraysKt.take((byte[])I, (int)32));
        byte[] IR = CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])I, (int)32));
        if (!Crypto.isPrivKeyValid(IL)) {
            boolean bl = false;
            String string = "cannot generate child private key: IL is invalid";
            throw new IllegalArgumentException(string.toString());
        }
        PrivateKey key = new PrivateKey(IL).plus(parent.getPrivateKey());
        if (!Crypto.isPrivKeyValid(key.value.toByteArray())) {
            boolean bl = false;
            String string = "cannot generate child private key: resulting private key is invalid";
            throw new IllegalArgumentException(string.toString());
        }
        return new ExtendedPrivateKey(key.value, ByteVectorKt.byteVector32(IR), parent.depth + 1, parent.path.derive(index), DeterministicWallet.fingerprint(parent));
    }

    @JvmStatic
    @NotNull
    public static final ExtendedPublicKey derivePublicKey(@NotNull ExtendedPublicKey parent, long index) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!(!DeterministicWallet.isHardened(index))) {
            boolean $i$a$-require-DeterministicWallet$derivePublicKey$42 = false;
            String $i$a$-require-DeterministicWallet$derivePublicKey$42 = "Cannot derive public keys from public hardened keys";
            throw new IllegalArgumentException($i$a$-require-DeterministicWallet$derivePublicKey$42.toString());
        }
        byte[] I = Crypto.hmac512(parent.chaincode.toByteArray(), ArraysKt.plus((byte[])parent.publickeybytes.toByteArray(), (byte[])Pack.writeInt32BE((int)index)));
        byte[] IL = CollectionsKt.toByteArray((Collection)ArraysKt.take((byte[])I, (int)32));
        byte[] IR = CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])I, (int)32));
        if (!Crypto.isPrivKeyValid(IL)) {
            boolean bl = false;
            String string = "cannot generate child public key: IL is invalid";
            throw new IllegalArgumentException(string.toString());
        }
        PublicKey Ki = new PrivateKey(IL).publicKey().plus(parent.getPublicKey());
        if (!Crypto.isPubKeyValid(Ki.value.toByteArray())) {
            boolean bl = false;
            String string = "cannot generate child public key: resulting public key is invalid";
            throw new IllegalArgumentException(string.toString());
        }
        return new ExtendedPublicKey(Ki.value, ByteVectorKt.byteVector32(IR), parent.depth + 1, parent.path.derive(index), DeterministicWallet.fingerprint(parent));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final ExtendedPrivateKey derivePrivateKey(@NotNull ExtendedPrivateKey parent, @NotNull List<Long> chain) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Iterable $this$fold$iv = chain;
        boolean $i$f$fold = false;
        ExtendedPrivateKey accumulator$iv = parent;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            long l = ((Number)element$iv).longValue();
            ExtendedPrivateKey p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = DeterministicWallet.derivePrivateKey(p0, (long)p1);
        }
        return accumulator$iv;
    }

    @JvmStatic
    @NotNull
    public static final ExtendedPrivateKey derivePrivateKey(@NotNull ExtendedPrivateKey parent, @NotNull KeyPath keyPath) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)keyPath, (String)"keyPath");
        return DeterministicWallet.derivePrivateKey(parent, keyPath.path);
    }

    @JvmStatic
    @NotNull
    public static final ExtendedPrivateKey derivePrivateKey(@NotNull ExtendedPrivateKey parent, @NotNull String keyPath) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)keyPath, (String)"keyPath");
        return DeterministicWallet.derivePrivateKey(parent, KeyPath.Companion.fromPath(keyPath));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final ExtendedPublicKey derivePublicKey(@NotNull ExtendedPublicKey parent, @NotNull List<Long> chain) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Iterable $this$fold$iv = chain;
        boolean $i$f$fold = false;
        ExtendedPublicKey accumulator$iv = parent;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            long l = ((Number)element$iv).longValue();
            ExtendedPublicKey p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = DeterministicWallet.derivePublicKey(p0, (long)p1);
        }
        return accumulator$iv;
    }

    @JvmStatic
    @NotNull
    public static final ExtendedPublicKey derivePublicKey(@NotNull ExtendedPublicKey parent, @NotNull KeyPath keyPath) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)keyPath, (String)"keyPath");
        return DeterministicWallet.derivePublicKey(parent, keyPath.path);
    }

    @JvmStatic
    @NotNull
    public static final ExtendedPublicKey derivePublicKey(@NotNull ExtendedPublicKey parent, @NotNull String keyPath) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)keyPath, (String)"keyPath");
        return DeterministicWallet.derivePublicKey(parent, KeyPath.Companion.fromPath(keyPath));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lfr/acinq/bitcoin/DeterministicWallet$ExtendedPrivateKey;", "", "secretkeybytes", "Lfr/acinq/bitcoin/ByteVector32;", "chaincode", "depth", "", "path", "Lfr/acinq/bitcoin/KeyPath;", "parent", "", "(Lfr/acinq/bitcoin/ByteVector32;Lfr/acinq/bitcoin/ByteVector32;ILfr/acinq/bitcoin/KeyPath;J)V", "privateKey", "Lfr/acinq/bitcoin/PrivateKey;", "getPrivateKey", "()Lfr/acinq/bitcoin/PrivateKey;", "publicKey", "Lfr/acinq/bitcoin/PublicKey;", "getPublicKey", "()Lfr/acinq/bitcoin/PublicKey;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "bitcoin-kmp"})
    @SourceDebugExtension(value={"SMAP\nDeterministicWallet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeterministicWallet.kt\nfr/acinq/bitcoin/DeterministicWallet$ExtendedPrivateKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1#2:344\n*E\n"})
    public static final class ExtendedPrivateKey {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final ByteVector32 secretkeybytes;
        @JvmField
        @NotNull
        public final ByteVector32 chaincode;
        @JvmField
        public final int depth;
        @JvmField
        @NotNull
        public final KeyPath path;
        @JvmField
        public final long parent;

        public ExtendedPrivateKey(@NotNull ByteVector32 secretkeybytes, @NotNull ByteVector32 chaincode, int depth, @NotNull KeyPath path, long parent) {
            Intrinsics.checkNotNullParameter((Object)secretkeybytes, (String)"secretkeybytes");
            Intrinsics.checkNotNullParameter((Object)chaincode, (String)"chaincode");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.secretkeybytes = secretkeybytes;
            this.chaincode = chaincode;
            this.depth = depth;
            this.path = path;
            this.parent = parent;
            if (!Crypto.isPrivKeyValid(this.secretkeybytes.toByteArray())) {
                boolean $i$a$-require-DeterministicWallet$ExtendedPrivateKey$42 = false;
                String $i$a$-require-DeterministicWallet$ExtendedPrivateKey$42 = "private key is invalid";
                throw new IllegalArgumentException($i$a$-require-DeterministicWallet$ExtendedPrivateKey$42.toString());
            }
            if (!(this.depth != 0 || this.parent == 0L)) {
                boolean $i$a$-require-DeterministicWallet$ExtendedPrivateKey$52 = false;
                String $i$a$-require-DeterministicWallet$ExtendedPrivateKey$52 = "zero depth with non-zero parent fingerprint";
                throw new IllegalArgumentException($i$a$-require-DeterministicWallet$ExtendedPrivateKey$52.toString());
            }
            if (!(this.depth != 0 || this.path.getLastChildNumber() == 0L)) {
                boolean bl = false;
                String string = "zero depth with non-zero child number";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final PrivateKey getPrivateKey() {
            return new PrivateKey(this.secretkeybytes);
        }

        @NotNull
        public final PublicKey getPublicKey() {
            return this.getPrivateKey().publicKey();
        }

        @NotNull
        public String toString() {
            return "<extended_private_key>";
        }

        @NotNull
        public final ByteVector32 component1() {
            return this.secretkeybytes;
        }

        @NotNull
        public final ByteVector32 component2() {
            return this.chaincode;
        }

        public final int component3() {
            return this.depth;
        }

        @NotNull
        public final KeyPath component4() {
            return this.path;
        }

        public final long component5() {
            return this.parent;
        }

        @NotNull
        public final ExtendedPrivateKey copy(@NotNull ByteVector32 secretkeybytes, @NotNull ByteVector32 chaincode, int depth, @NotNull KeyPath path, long parent) {
            Intrinsics.checkNotNullParameter((Object)secretkeybytes, (String)"secretkeybytes");
            Intrinsics.checkNotNullParameter((Object)chaincode, (String)"chaincode");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new ExtendedPrivateKey(secretkeybytes, chaincode, depth, path, parent);
        }

        public static /* synthetic */ ExtendedPrivateKey copy$default(ExtendedPrivateKey extendedPrivateKey, ByteVector32 byteVector32, ByteVector32 byteVector322, int n, KeyPath keyPath, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                byteVector32 = extendedPrivateKey.secretkeybytes;
            }
            if ((n2 & 2) != 0) {
                byteVector322 = extendedPrivateKey.chaincode;
            }
            if ((n2 & 4) != 0) {
                n = extendedPrivateKey.depth;
            }
            if ((n2 & 8) != 0) {
                keyPath = extendedPrivateKey.path;
            }
            if ((n2 & 0x10) != 0) {
                l = extendedPrivateKey.parent;
            }
            return extendedPrivateKey.copy(byteVector32, byteVector322, n, keyPath, l);
        }

        public int hashCode() {
            int result = this.secretkeybytes.hashCode();
            result = result * 31 + this.chaincode.hashCode();
            result = result * 31 + Integer.hashCode(this.depth);
            result = result * 31 + this.path.hashCode();
            result = result * 31 + Long.hashCode(this.parent);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExtendedPrivateKey)) {
                return false;
            }
            ExtendedPrivateKey extendedPrivateKey = (ExtendedPrivateKey)other;
            if (!Intrinsics.areEqual((Object)this.secretkeybytes, (Object)extendedPrivateKey.secretkeybytes)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.chaincode, (Object)extendedPrivateKey.chaincode)) {
                return false;
            }
            if (this.depth != extendedPrivateKey.depth) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)extendedPrivateKey.path)) {
                return false;
            }
            return this.parent == extendedPrivateKey.parent;
        }

        @JvmStatic
        @NotNull
        public static final Pair<Integer, ExtendedPrivateKey> decode(@NotNull String input, @NotNull KeyPath parentPath) {
            return Companion.decode(input, parentPath);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lfr/acinq/bitcoin/DeterministicWallet$ExtendedPrivateKey$Companion;", "", "()V", "decode", "Lkotlin/Pair;", "", "Lfr/acinq/bitcoin/DeterministicWallet$ExtendedPrivateKey;", "input", "", "parentPath", "Lfr/acinq/bitcoin/KeyPath;", "bitcoin-kmp"})
        @SourceDebugExtension(value={"SMAP\nDeterministicWallet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeterministicWallet.kt\nfr/acinq/bitcoin/DeterministicWallet$ExtendedPrivateKey$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1#2:344\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Pair<Integer, ExtendedPrivateKey> decode(@NotNull String input, @NotNull KeyPath parentPath) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
                Pair<Integer, byte[]> pair = Base58Check.decodeWithIntPrefix(input);
                int prefix = ((Number)pair.component1()).intValue();
                byte[] bin = (byte[])pair.component2();
                if (!(prefix == 76066276 || prefix == 77428856 || prefix == 78791436 || prefix == 70615956 || prefix == 71978536 || prefix == 73341116)) {
                    boolean $i$a$-require-DeterministicWallet$ExtendedPrivateKey$Companion$decode$22 = false;
                    String $i$a$-require-DeterministicWallet$ExtendedPrivateKey$Companion$decode$22 = "invalid prefix";
                    throw new IllegalArgumentException($i$a$-require-DeterministicWallet$ExtendedPrivateKey$Companion$decode$22.toString());
                }
                ByteArrayInput bis = new ByteArrayInput(bin);
                int depth = bis.read();
                long parent = (long)Pack.int32BE(bis) & 0xFFFFFFFFL;
                long childNumber = (long)Pack.int32BE(bis) & 0xFFFFFFFFL;
                byte[] chaincode = new byte[32];
                Input.DefaultImpls.read$default(bis, chaincode, 0, 0, 4, null);
                if (!(bis.read() == 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                byte[] secretKeyBytes = new byte[32];
                Input.DefaultImpls.read$default(bis, secretKeyBytes, 0, 0, 4, null);
                return new Pair((Object)prefix, (Object)new ExtendedPrivateKey(ByteVectorKt.byteVector32(secretKeyBytes), ByteVectorKt.byteVector32(chaincode), depth, parentPath.derive(childNumber), parent));
            }

            public static /* synthetic */ Pair decode$default(Companion companion, String string, KeyPath keyPath, int n, Object object) {
                if ((n & 2) != 0) {
                    keyPath = KeyPath.Companion.getEmpty();
                }
                return companion.decode(string, keyPath);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lfr/acinq/bitcoin/DeterministicWallet$ExtendedPublicKey;", "", "publickeybytes", "Lfr/acinq/bitcoin/ByteVector;", "chaincode", "Lfr/acinq/bitcoin/ByteVector32;", "depth", "", "path", "Lfr/acinq/bitcoin/KeyPath;", "parent", "", "(Lfr/acinq/bitcoin/ByteVector;Lfr/acinq/bitcoin/ByteVector32;ILfr/acinq/bitcoin/KeyPath;J)V", "publicKey", "Lfr/acinq/bitcoin/PublicKey;", "getPublicKey", "()Lfr/acinq/bitcoin/PublicKey;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "bitcoin-kmp"})
    @SourceDebugExtension(value={"SMAP\nDeterministicWallet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeterministicWallet.kt\nfr/acinq/bitcoin/DeterministicWallet$ExtendedPublicKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1#2:344\n*E\n"})
    public static final class ExtendedPublicKey {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final ByteVector publickeybytes;
        @JvmField
        @NotNull
        public final ByteVector32 chaincode;
        @JvmField
        public final int depth;
        @JvmField
        @NotNull
        public final KeyPath path;
        @JvmField
        public final long parent;

        public ExtendedPublicKey(@NotNull ByteVector publickeybytes, @NotNull ByteVector32 chaincode, int depth, @NotNull KeyPath path, long parent) {
            Intrinsics.checkNotNullParameter((Object)publickeybytes, (String)"publickeybytes");
            Intrinsics.checkNotNullParameter((Object)chaincode, (String)"chaincode");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.publickeybytes = publickeybytes;
            this.chaincode = chaincode;
            this.depth = depth;
            this.path = path;
            this.parent = parent;
            if (!(this.publickeybytes.size() == 33)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!Crypto.isPubKeyValid(this.publickeybytes.toByteArray())) {
                boolean $i$a$-require-DeterministicWallet$ExtendedPublicKey$42 = false;
                String $i$a$-require-DeterministicWallet$ExtendedPublicKey$42 = "public key is invalid";
                throw new IllegalArgumentException($i$a$-require-DeterministicWallet$ExtendedPublicKey$42.toString());
            }
            if (!(this.depth != 0 || this.parent == 0L)) {
                boolean $i$a$-require-DeterministicWallet$ExtendedPublicKey$52 = false;
                String $i$a$-require-DeterministicWallet$ExtendedPublicKey$52 = "zero depth with non-zero parent fingerprint";
                throw new IllegalArgumentException($i$a$-require-DeterministicWallet$ExtendedPublicKey$52.toString());
            }
            if (!(this.depth != 0 || this.path.getLastChildNumber() == 0L)) {
                boolean bl = false;
                String string = "zero depth with non-zero child number";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final PublicKey getPublicKey() {
            return new PublicKey(this.publickeybytes);
        }

        @NotNull
        public final ByteVector component1() {
            return this.publickeybytes;
        }

        @NotNull
        public final ByteVector32 component2() {
            return this.chaincode;
        }

        public final int component3() {
            return this.depth;
        }

        @NotNull
        public final KeyPath component4() {
            return this.path;
        }

        public final long component5() {
            return this.parent;
        }

        @NotNull
        public final ExtendedPublicKey copy(@NotNull ByteVector publickeybytes, @NotNull ByteVector32 chaincode, int depth, @NotNull KeyPath path, long parent) {
            Intrinsics.checkNotNullParameter((Object)publickeybytes, (String)"publickeybytes");
            Intrinsics.checkNotNullParameter((Object)chaincode, (String)"chaincode");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new ExtendedPublicKey(publickeybytes, chaincode, depth, path, parent);
        }

        public static /* synthetic */ ExtendedPublicKey copy$default(ExtendedPublicKey extendedPublicKey, ByteVector byteVector, ByteVector32 byteVector32, int n, KeyPath keyPath, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                byteVector = extendedPublicKey.publickeybytes;
            }
            if ((n2 & 2) != 0) {
                byteVector32 = extendedPublicKey.chaincode;
            }
            if ((n2 & 4) != 0) {
                n = extendedPublicKey.depth;
            }
            if ((n2 & 8) != 0) {
                keyPath = extendedPublicKey.path;
            }
            if ((n2 & 0x10) != 0) {
                l = extendedPublicKey.parent;
            }
            return extendedPublicKey.copy(byteVector, byteVector32, n, keyPath, l);
        }

        @NotNull
        public String toString() {
            return "ExtendedPublicKey(publickeybytes=" + this.publickeybytes + ", chaincode=" + this.chaincode + ", depth=" + this.depth + ", path=" + this.path + ", parent=" + this.parent + ')';
        }

        public int hashCode() {
            int result = this.publickeybytes.hashCode();
            result = result * 31 + this.chaincode.hashCode();
            result = result * 31 + Integer.hashCode(this.depth);
            result = result * 31 + this.path.hashCode();
            result = result * 31 + Long.hashCode(this.parent);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExtendedPublicKey)) {
                return false;
            }
            ExtendedPublicKey extendedPublicKey = (ExtendedPublicKey)other;
            if (!Intrinsics.areEqual((Object)this.publickeybytes, (Object)extendedPublicKey.publickeybytes)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.chaincode, (Object)extendedPublicKey.chaincode)) {
                return false;
            }
            if (this.depth != extendedPublicKey.depth) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)extendedPublicKey.path)) {
                return false;
            }
            return this.parent == extendedPublicKey.parent;
        }

        @JvmStatic
        @NotNull
        public static final Pair<Integer, ExtendedPublicKey> decode(@NotNull String input, @NotNull KeyPath parentPath) {
            return Companion.decode(input, parentPath);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lfr/acinq/bitcoin/DeterministicWallet$ExtendedPublicKey$Companion;", "", "()V", "decode", "Lkotlin/Pair;", "", "Lfr/acinq/bitcoin/DeterministicWallet$ExtendedPublicKey;", "input", "", "parentPath", "Lfr/acinq/bitcoin/KeyPath;", "bitcoin-kmp"})
        @SourceDebugExtension(value={"SMAP\nDeterministicWallet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeterministicWallet.kt\nfr/acinq/bitcoin/DeterministicWallet$ExtendedPublicKey$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1#2:344\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Pair<Integer, ExtendedPublicKey> decode(@NotNull String input, @NotNull KeyPath parentPath) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
                Pair<Integer, byte[]> pair = Base58Check.decodeWithIntPrefix(input);
                int prefix = ((Number)pair.component1()).intValue();
                byte[] bin = (byte[])pair.component2();
                if (!(prefix == 76067358 || prefix == 77429938 || prefix == 78792518 || prefix == 70617039 || prefix == 71979618 || prefix == 73342198)) {
                    boolean $i$a$-require-DeterministicWallet$ExtendedPublicKey$Companion$decode$22 = false;
                    String $i$a$-require-DeterministicWallet$ExtendedPublicKey$Companion$decode$22 = "invalid prefix";
                    throw new IllegalArgumentException($i$a$-require-DeterministicWallet$ExtendedPublicKey$Companion$decode$22.toString());
                }
                ByteArrayInput bis = new ByteArrayInput(bin);
                int depth = bis.read();
                long parent = (long)Pack.int32BE(bis) & 0xFFFFFFFFL;
                long childNumber = (long)Pack.int32BE(bis) & 0xFFFFFFFFL;
                byte[] chaincode = new byte[32];
                Input.DefaultImpls.read$default(bis, chaincode, 0, 0, 4, null);
                byte[] publicKeyBytes = new byte[33];
                Input.DefaultImpls.read$default(bis, publicKeyBytes, 0, 0, 4, null);
                return new Pair((Object)prefix, (Object)new ExtendedPublicKey(ByteVectorKt.byteVector(publicKeyBytes), ByteVectorKt.byteVector32(chaincode), depth, parentPath.derive(childNumber), parent));
            }

            public static /* synthetic */ Pair decode$default(Companion companion, String string, KeyPath keyPath, int n, Object object) {
                if ((n & 2) != 0) {
                    keyPath = KeyPath.Companion.getEmpty();
                }
                return companion.decode(string, keyPath);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

