/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.LexicographicalOrdering;
import fr.acinq.bitcoin.OutPoint;
import fr.acinq.bitcoin.PublicKey;
import fr.acinq.bitcoin.Transaction;
import fr.acinq.bitcoin.TxIn;
import fr.acinq.bitcoin.TxOut;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\tH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\rH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000eH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\tH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u000fH\u0007J\u0019\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u000fH\u0082\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u00a8\u0006\u0014"}, d2={"Lfr/acinq/bitcoin/LexicographicalOrdering;", "", "()V", "compare", "", "a", "Lfr/acinq/bitcoin/OutPoint;", "b", "Lfr/acinq/bitcoin/PublicKey;", "Lfr/acinq/bitcoin/TxIn;", "Lfr/acinq/bitcoin/TxOut;", "isLessThan", "", "Lfr/acinq/bitcoin/ByteVector;", "Lfr/acinq/bitcoin/ByteVector32;", "", "isLessThanInternal", "sort", "Lfr/acinq/bitcoin/Transaction;", "tx", "bitcoin-kmp"})
public final class LexicographicalOrdering {
    @NotNull
    public static final LexicographicalOrdering INSTANCE = new LexicographicalOrdering();

    private LexicographicalOrdering() {
    }

    private final boolean isLessThanInternal(byte[] a, byte[] b) {
        boolean bl;
        block4: {
            while (true) {
                if (a.length == 0 && b.length == 0) {
                    bl = false;
                    break block4;
                }
                if (a.length == 0) {
                    bl = true;
                    break block4;
                }
                if (b.length == 0) {
                    bl = false;
                    break block4;
                }
                if (ArraysKt.first((byte[])a) != ArraysKt.first((byte[])b)) break;
                LexicographicalOrdering lexicographicalOrdering = this_;
                byte[] byArray = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])a, (int)1));
                byte[] byArray2 = CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])b, (int)1));
                LexicographicalOrdering this_ = lexicographicalOrdering;
                a = byArray;
                b = byArray2;
            }
            bl = (ArraysKt.first((byte[])a) & 0xFF) < (ArraysKt.first((byte[])b) & 0xFF);
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isLessThan(@NotNull byte[] a, @NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return INSTANCE.isLessThanInternal(a, b);
    }

    @JvmStatic
    public static final boolean isLessThan(@NotNull ByteVector a, @NotNull ByteVector b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return LexicographicalOrdering.isLessThan(a.toByteArray(), b.toByteArray());
    }

    @JvmStatic
    public static final boolean isLessThan(@NotNull ByteVector32 a, @NotNull ByteVector32 b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return LexicographicalOrdering.isLessThan(a.toByteArray(), b.toByteArray());
    }

    @JvmStatic
    public static final boolean isLessThan(@NotNull OutPoint a, @NotNull OutPoint b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Intrinsics.areEqual((Object)a.txid, (Object)b.txid) ? a.index < b.index : LexicographicalOrdering.isLessThan(a.txid, b.txid);
    }

    @JvmStatic
    public static final int compare(@NotNull OutPoint a, @NotNull OutPoint b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Intrinsics.areEqual((Object)a, (Object)b) ? 0 : (LexicographicalOrdering.isLessThan(a, b) ? -1 : 1);
    }

    @JvmStatic
    public static final boolean isLessThan(@NotNull TxIn a, @NotNull TxIn b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return LexicographicalOrdering.isLessThan(a.outPoint, b.outPoint);
    }

    @JvmStatic
    public static final int compare(@NotNull TxIn a, @NotNull TxIn b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Intrinsics.areEqual((Object)a, (Object)b) ? 0 : (LexicographicalOrdering.isLessThan(a, b) ? -1 : 1);
    }

    @JvmStatic
    public static final boolean isLessThan(@NotNull TxOut a, @NotNull TxOut b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Intrinsics.areEqual((Object)a.amount, (Object)b.amount) ? LexicographicalOrdering.isLessThan(a.publicKeyScript, b.publicKeyScript) : a.amount.compareTo(b.amount) < 0;
    }

    @JvmStatic
    public static final int compare(@NotNull TxOut a, @NotNull TxOut b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Intrinsics.areEqual((Object)a, (Object)b) ? 0 : (LexicographicalOrdering.isLessThan(a, b) ? -1 : 1);
    }

    @JvmStatic
    public static final boolean isLessThan(@NotNull PublicKey a, @NotNull PublicKey b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return LexicographicalOrdering.isLessThan(a.value, b.value);
    }

    @JvmStatic
    public static final int compare(@NotNull PublicKey a, @NotNull PublicKey b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Intrinsics.areEqual((Object)a, (Object)b) ? 0 : (LexicographicalOrdering.isLessThan(a, b) ? -1 : 1);
    }

    @JvmStatic
    @NotNull
    public static final Transaction sort(@NotNull Transaction tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        return Transaction.copy$default(tx, 0L, CollectionsKt.sortedWith((Iterable)tx.txIn, (arg_0, arg_1) -> LexicographicalOrdering.sort$lambda$0(sort.1.INSTANCE, arg_0, arg_1)), CollectionsKt.sortedWith((Iterable)tx.txOut, (arg_0, arg_1) -> LexicographicalOrdering.sort$lambda$1(sort.2.INSTANCE, arg_0, arg_1)), 0L, 9, null);
    }

    private static final int sort$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final int sort$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

