/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.Base58Check;
import fr.acinq.bitcoin.Bech32;
import fr.acinq.bitcoin.Block;
import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.Crypto;
import fr.acinq.bitcoin.PrivateKey;
import fr.acinq.bitcoin.Script;
import fr.acinq.bitcoin.ScriptElt;
import fr.acinq.bitcoin.XonlyPublicKey;
import fr.acinq.secp256k1.Hex;
import fr.acinq.secp256k1.Secp256k1;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\b\u001a\u00020\u0006H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\r\u001a\u00020\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u000bJ\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u001dH\u0086\u0002J\u0006\u0010\u001e\u001a\u00020\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0006\u0010 \u001a\u00020\u0003J\t\u0010!\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\"\u001a\u00020#R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lfr/acinq/bitcoin/PublicKey;", "", "data", "", "([B)V", "value", "Lfr/acinq/bitcoin/ByteVector;", "(Lfr/acinq/bitcoin/ByteVector;)V", "component1", "copy", "equals", "", "other", "hash160", "hashCode", "", "isEven", "isOdd", "isValid", "minus", "that", "p2pkhAddress", "", "chainHash", "Lfr/acinq/bitcoin/ByteVector32;", "p2shOfP2wpkhAddress", "p2wpkhAddress", "plus", "times", "Lfr/acinq/bitcoin/PrivateKey;", "toHex", "toString", "toUncompressedBin", "unaryMinus", "xOnly", "Lfr/acinq/bitcoin/XonlyPublicKey;", "Companion", "bitcoin-kmp"})
@SourceDebugExtension(value={"SMAP\nPublicKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublicKey.kt\nfr/acinq/bitcoin/PublicKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public final class PublicKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final ByteVector value;
    @JvmField
    @NotNull
    public static final PublicKey Generator = Companion.parse(Hex.decode((String)"0479be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798483ada7726a3c4655da4fbfc0e1108a8fd17b448a68554199c47d08ffb10d4b8"));

    public PublicKey(@NotNull ByteVector value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        if (!(this.value.size() == 33)) {
            boolean bl = false;
            String string = "public key must be in compressed form";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public PublicKey(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this(new ByteVector(data));
    }

    public final boolean isValid() {
        return Crypto.isPubKeyValid(this.value.toByteArray());
    }

    public final boolean isEven() {
        return this.value.get(0) == 2;
    }

    public final boolean isOdd() {
        return !this.isEven();
    }

    @NotNull
    public final XonlyPublicKey xOnly() {
        return new XonlyPublicKey(this);
    }

    @NotNull
    public final PublicKey plus(@NotNull PublicKey that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        byte[][] byArrayArray = new byte[][]{this.value.toByteArray(), that.value.toByteArray()};
        byte[] pub = Secp256k1.Companion.pubKeyCombine((byte[][])byArrayArray);
        return new PublicKey(Companion.compress(pub));
    }

    @NotNull
    public final PublicKey unaryMinus() {
        byte[] pub = Secp256k1.Companion.pubKeyNegate(this.value.toByteArray());
        return new PublicKey(Companion.compress(pub));
    }

    @NotNull
    public final PublicKey minus(@NotNull PublicKey that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return this.plus(that.unaryMinus());
    }

    @NotNull
    public final PublicKey times(@NotNull PrivateKey that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        byte[] pub = Secp256k1.Companion.pubKeyTweakMul(this.value.toByteArray(), that.value.toByteArray());
        return new PublicKey(Companion.compress(pub));
    }

    @NotNull
    public final byte[] hash160() {
        return Crypto.hash160(this.value.toByteArray());
    }

    @NotNull
    public final byte[] toUncompressedBin() {
        return Secp256k1.Companion.pubkeyParse(this.value.toByteArray());
    }

    @NotNull
    public final String p2pkhAddress(@NotNull ByteVector32 chainHash) {
        String string;
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        ByteVector32 byteVector32 = chainHash;
        if ((Intrinsics.areEqual((Object)byteVector32, (Object)Block.TestnetGenesisBlock.hash) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.RegtestGenesisBlock.hash)) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.SignetGenesisBlock.hash)) {
            string = Base58Check.encode((byte)111, this.hash160());
        } else if (Intrinsics.areEqual((Object)byteVector32, (Object)Block.LivenetGenesisBlock.hash)) {
            string = Base58Check.encode((byte)0, this.hash160());
        } else {
            throw new IllegalStateException(("invalid chain hash " + chainHash).toString());
        }
        return string;
    }

    @NotNull
    public final String p2shOfP2wpkhAddress(@NotNull ByteVector32 chainHash) {
        String string;
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        List<ScriptElt> script = Script.pay2wpkh(this);
        byte[] hash = Crypto.hash160(Script.write(script));
        ByteVector32 byteVector32 = chainHash;
        if ((Intrinsics.areEqual((Object)byteVector32, (Object)Block.TestnetGenesisBlock.hash) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.RegtestGenesisBlock.hash)) ? true : Intrinsics.areEqual((Object)byteVector32, (Object)Block.SignetGenesisBlock.hash)) {
            string = Base58Check.encode((byte)-60, hash);
        } else if (Intrinsics.areEqual((Object)byteVector32, (Object)Block.LivenetGenesisBlock.hash)) {
            string = Base58Check.encode((byte)5, hash);
        } else {
            throw new IllegalStateException(("invalid chain hash " + chainHash).toString());
        }
        return string;
    }

    @NotNull
    public final String p2wpkhAddress(@NotNull ByteVector32 chainHash) {
        Intrinsics.checkNotNullParameter((Object)chainHash, (String)"chainHash");
        return Bech32.encodeWitnessAddress(Bech32.hrp(chainHash), (byte)0, this.hash160());
    }

    @NotNull
    public final String toHex() {
        return this.value.toHex();
    }

    @NotNull
    public String toString() {
        return this.value.toString();
    }

    @NotNull
    public final ByteVector component1() {
        return this.value;
    }

    @NotNull
    public final PublicKey copy(@NotNull ByteVector value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new PublicKey(value);
    }

    public static /* synthetic */ PublicKey copy$default(PublicKey publicKey, ByteVector byteVector, int n, Object object) {
        if ((n & 1) != 0) {
            byteVector = publicKey.value;
        }
        return publicKey.copy(byteVector);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PublicKey)) {
            return false;
        }
        PublicKey publicKey = (PublicKey)other;
        return Intrinsics.areEqual((Object)this.value, (Object)publicKey.value);
    }

    @JvmStatic
    @NotNull
    public static final PublicKey parse(@NotNull byte[] pub) {
        return Companion.parse(pub);
    }

    @JvmStatic
    @NotNull
    public static final byte[] compress(@NotNull byte[] pub) {
        return Companion.compress(pub);
    }

    @JvmStatic
    @NotNull
    public static final PublicKey fromHex(@NotNull String hex) {
        return Companion.fromHex(hex);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lfr/acinq/bitcoin/PublicKey$Companion;", "", "()V", "Generator", "Lfr/acinq/bitcoin/PublicKey;", "compress", "", "pub", "fromHex", "hex", "", "parse", "bitcoin-kmp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PublicKey parse(@NotNull byte[] pub) {
            Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
            return new PublicKey(this.compress(pub));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final byte[] compress(@NotNull byte[] pub) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
            if (Crypto.isPubKeyCompressed(pub)) {
                byArray = pub;
            } else {
                void var2_2;
                byte[] byArray2 = Arrays.copyOf(pub, 33);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, newSize)");
                byte[] compressed = byArray2;
                compressed[0] = ArraysKt.last((byte[])pub) % 2 == 0 ? 2 : 3;
                byArray = var2_2;
            }
            return byArray;
        }

        @JvmStatic
        @NotNull
        public final PublicKey fromHex(@NotNull String hex) {
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            return new PublicKey(Hex.decode((String)hex));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

