/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.Crypto;
import fr.acinq.bitcoin.LexicographicalOrdering;
import fr.acinq.bitcoin.ScriptLeaf;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u0005*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lfr/acinq/bitcoin/ScriptTree;", "T", "", "()V", "Branch", "Companion", "Leaf", "Lfr/acinq/bitcoin/ScriptTree$Branch;", "Lfr/acinq/bitcoin/ScriptTree$Leaf;", "bitcoin-kmp"})
public abstract class ScriptTree<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private ScriptTree() {
    }

    @JvmStatic
    @NotNull
    public static final ByteVector32 hash(@NotNull ScriptTree<ScriptLeaf> tree) {
        return Companion.hash(tree);
    }

    public /* synthetic */ ScriptTree(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H\u00c6\u0003J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H\u00c6\u0003J/\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lfr/acinq/bitcoin/ScriptTree$Branch;", "T", "Lfr/acinq/bitcoin/ScriptTree;", "left", "right", "(Lfr/acinq/bitcoin/ScriptTree;Lfr/acinq/bitcoin/ScriptTree;)V", "getLeft", "()Lfr/acinq/bitcoin/ScriptTree;", "getRight", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "bitcoin-kmp"})
    public static final class Branch<T>
    extends ScriptTree<T> {
        @NotNull
        private final ScriptTree<T> left;
        @NotNull
        private final ScriptTree<T> right;

        public Branch(@NotNull ScriptTree<T> left, @NotNull ScriptTree<T> right) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            super(null);
            this.left = left;
            this.right = right;
        }

        @NotNull
        public final ScriptTree<T> getLeft() {
            return this.left;
        }

        @NotNull
        public final ScriptTree<T> getRight() {
            return this.right;
        }

        @NotNull
        public final ScriptTree<T> component1() {
            return this.left;
        }

        @NotNull
        public final ScriptTree<T> component2() {
            return this.right;
        }

        @NotNull
        public final Branch<T> copy(@NotNull ScriptTree<T> left, @NotNull ScriptTree<T> right) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            return new Branch<T>(left, right);
        }

        public static /* synthetic */ Branch copy$default(Branch branch, ScriptTree scriptTree, ScriptTree scriptTree2, int n, Object object) {
            if ((n & 1) != 0) {
                scriptTree = branch.left;
            }
            if ((n & 2) != 0) {
                scriptTree2 = branch.right;
            }
            return branch.copy(scriptTree, scriptTree2);
        }

        @NotNull
        public String toString() {
            return "Branch(left=" + this.left + ", right=" + this.right + ')';
        }

        public int hashCode() {
            int result = this.left.hashCode();
            result = result * 31 + this.right.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Branch)) {
                return false;
            }
            Branch branch = (Branch)other;
            if (!Intrinsics.areEqual(this.left, branch.left)) {
                return false;
            }
            return Intrinsics.areEqual(this.right, branch.right);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a8\u0006\b"}, d2={"Lfr/acinq/bitcoin/ScriptTree$Companion;", "", "()V", "hash", "Lfr/acinq/bitcoin/ByteVector32;", "tree", "Lfr/acinq/bitcoin/ScriptTree;", "Lfr/acinq/bitcoin/ScriptLeaf;", "bitcoin-kmp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ByteVector32 hash(@NotNull ScriptTree<ScriptLeaf> tree) {
            ByteVector32 byteVector32;
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            ScriptTree<ScriptLeaf> scriptTree = tree;
            if (scriptTree instanceof Leaf) {
                byteVector32 = ((ScriptLeaf)((Leaf)tree).getValue()).getHash();
            } else if (scriptTree instanceof Branch) {
                ByteVector32 h2;
                ByteVector32 h1 = this.hash(((Branch)tree).getLeft());
                byteVector32 = Crypto.taggedHash((LexicographicalOrdering.isLessThan(h1, h2 = this.hash(((Branch)tree).getRight())) ? h1.plus(h2) : h2.plus(h1)).toByteArray(), "TapBranch");
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return byteVector32;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lfr/acinq/bitcoin/ScriptTree$Leaf;", "T", "Lfr/acinq/bitcoin/ScriptTree;", "value", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lfr/acinq/bitcoin/ScriptTree$Leaf;", "equals", "", "other", "", "hashCode", "", "toString", "", "bitcoin-kmp"})
    public static final class Leaf<T>
    extends ScriptTree<T> {
        private final T value;

        public Leaf(T value) {
            super(null);
            this.value = value;
        }

        public final T getValue() {
            return this.value;
        }

        public final T component1() {
            return this.value;
        }

        @NotNull
        public final Leaf<T> copy(T value) {
            return new Leaf<T>(value);
        }

        public static /* synthetic */ Leaf copy$default(Leaf leaf, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = leaf.value;
            }
            return leaf.copy(object);
        }

        @NotNull
        public String toString() {
            return "Leaf(value=" + this.value + ')';
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Leaf)) {
                return false;
            }
            Leaf leaf = (Leaf)other;
            return Intrinsics.areEqual(this.value, leaf.value);
        }
    }
}

