/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.BtcSerializable;
import fr.acinq.bitcoin.BtcSerializer;
import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.Script;
import fr.acinq.bitcoin.ScriptElt;
import fr.acinq.bitcoin.ScriptWitness;
import fr.acinq.bitcoin.io.Input;
import fr.acinq.bitcoin.io.Output;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u0019\u0010\b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0012\u001a\u00020\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lfr/acinq/bitcoin/ScriptWitness;", "Lfr/acinq/bitcoin/BtcSerializable;", "()V", "stack", "", "Lfr/acinq/bitcoin/ByteVector;", "(Ljava/util/List;)V", "component1", "copy", "equals", "", "other", "", "hashCode", "", "isNotNull", "isNull", "last", "push", "item", "", "script", "Lfr/acinq/bitcoin/ScriptElt;", "serializer", "Lfr/acinq/bitcoin/BtcSerializer;", "toString", "", "Companion", "bitcoin-kmp"})
public final class ScriptWitness
implements BtcSerializable<ScriptWitness> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final List<ByteVector> stack;
    @NotNull
    private static final ScriptWitness empty = new ScriptWitness(CollectionsKt.emptyList());

    public ScriptWitness(@NotNull List<? extends ByteVector> stack) {
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        this.stack = stack;
    }

    public ScriptWitness() {
        this(CollectionsKt.emptyList());
    }

    public final boolean isNull() {
        return this.stack.isEmpty();
    }

    public final boolean isNotNull() {
        return !this.isNull();
    }

    @NotNull
    public final ScriptWitness push(@NotNull ByteVector item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.copy(CollectionsKt.plus((Collection)this.stack, (Object)item));
    }

    @NotNull
    public final ScriptWitness push(@NotNull byte[] item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.push(new ByteVector(item));
    }

    @NotNull
    public final ScriptWitness push(@NotNull List<? extends ScriptElt> script) {
        Intrinsics.checkNotNullParameter(script, (String)"script");
        return this.push(Script.write(script));
    }

    @NotNull
    public final ByteVector last() {
        return (ByteVector)CollectionsKt.last(this.stack);
    }

    @Override
    @NotNull
    public BtcSerializer<ScriptWitness> serializer() {
        return Companion;
    }

    @NotNull
    public final List<ByteVector> component1() {
        return this.stack;
    }

    @NotNull
    public final ScriptWitness copy(@NotNull List<? extends ByteVector> stack) {
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        return new ScriptWitness(stack);
    }

    public static /* synthetic */ ScriptWitness copy$default(ScriptWitness scriptWitness, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = scriptWitness.stack;
        }
        return scriptWitness.copy(list);
    }

    @NotNull
    public String toString() {
        return "ScriptWitness(stack=" + this.stack + ')';
    }

    public int hashCode() {
        return ((Object)this.stack).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScriptWitness)) {
            return false;
        }
        ScriptWitness scriptWitness = (ScriptWitness)other;
        return Intrinsics.areEqual(this.stack, scriptWitness.stack);
    }

    @JvmStatic
    @NotNull
    public static ScriptWitness read(@NotNull Input input, long protocolVersion) {
        return Companion.read(input, protocolVersion);
    }

    @JvmStatic
    public static void write(@NotNull ScriptWitness t, @NotNull Output out, long protocolVersion) {
        Companion.write(t, out, protocolVersion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lfr/acinq/bitcoin/ScriptWitness$Companion;", "Lfr/acinq/bitcoin/BtcSerializer;", "Lfr/acinq/bitcoin/ScriptWitness;", "()V", "empty", "getEmpty", "()Lfr/acinq/bitcoin/ScriptWitness;", "read", "input", "Lfr/acinq/bitcoin/io/Input;", "protocolVersion", "", "write", "", "t", "out", "Lfr/acinq/bitcoin/io/Output;", "bitcoin-kmp"})
    public static final class Companion
    extends BtcSerializer<ScriptWitness> {
        private Companion() {
        }

        @NotNull
        public final ScriptWitness getEmpty() {
            return empty;
        }

        @Override
        @JvmStatic
        @NotNull
        public ScriptWitness read(@NotNull Input input, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return new ScriptWitness(BtcSerializer.Companion.readCollection(input, read.1.INSTANCE, null, protocolVersion));
        }

        @Override
        @JvmStatic
        public void write(@NotNull ScriptWitness t, @NotNull Output out, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            BtcSerializer.Companion.writeCollection(t.stack, out, write.1.INSTANCE, protocolVersion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

