/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.BtcSerializable;
import fr.acinq.bitcoin.BtcSerializer;
import fr.acinq.bitcoin.ByteVector;
import fr.acinq.bitcoin.ByteVectorKt;
import fr.acinq.bitcoin.OutPoint;
import fr.acinq.bitcoin.Script;
import fr.acinq.bitcoin.ScriptElt;
import fr.acinq.bitcoin.ScriptWitness;
import fr.acinq.bitcoin.io.Input;
import fr.acinq.bitcoin.io.Output;
import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001'B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\rH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u000fH\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\r2\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00000!H\u0016J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\rJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010&\u001a\u00020\u001fR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lfr/acinq/bitcoin/TxIn;", "Lfr/acinq/bitcoin/BtcSerializable;", "outPoint", "Lfr/acinq/bitcoin/OutPoint;", "signatureScript", "", "sequence", "", "(Lfr/acinq/bitcoin/OutPoint;[BJ)V", "(Lfr/acinq/bitcoin/OutPoint;J)V", "", "Lfr/acinq/bitcoin/ScriptElt;", "(Lfr/acinq/bitcoin/OutPoint;Ljava/util/List;J)V", "Lfr/acinq/bitcoin/ByteVector;", "witness", "Lfr/acinq/bitcoin/ScriptWitness;", "(Lfr/acinq/bitcoin/OutPoint;Lfr/acinq/bitcoin/ByteVector;JLfr/acinq/bitcoin/ScriptWitness;)V", "hasWitness", "", "getHasWitness", "()Z", "isFinal", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "serializer", "Lfr/acinq/bitcoin/BtcSerializer;", "toString", "", "updateSignatureScript", "updateWitness", "weight", "Companion", "bitcoin-kmp"})
public final class TxIn
implements BtcSerializable<TxIn> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final OutPoint outPoint;
    @JvmField
    @NotNull
    public final ByteVector signatureScript;
    @JvmField
    public final long sequence;
    @JvmField
    @NotNull
    public final ScriptWitness witness;
    public static final long SEQUENCE_FINAL = 0xFFFFFFFFL;
    public static final long SEQUENCE_LOCKTIME_DISABLE_FLAG = 0x80000000L;
    public static final long SEQUENCE_LOCKTIME_TYPE_FLAG = 0x400000L;
    public static final long SEQUENCE_LOCKTIME_MASK = 65535L;
    public static final long SEQUENCE_LOCKTIME_GRANULARITY = 9L;

    public TxIn(@NotNull OutPoint outPoint, @NotNull ByteVector signatureScript, long sequence, @NotNull ScriptWitness witness) {
        Intrinsics.checkNotNullParameter((Object)outPoint, (String)"outPoint");
        Intrinsics.checkNotNullParameter((Object)signatureScript, (String)"signatureScript");
        Intrinsics.checkNotNullParameter((Object)witness, (String)"witness");
        this.outPoint = outPoint;
        this.signatureScript = signatureScript;
        this.sequence = sequence;
        this.witness = witness;
    }

    public /* synthetic */ TxIn(OutPoint outPoint, ByteVector byteVector, long l, ScriptWitness scriptWitness, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            scriptWitness = ScriptWitness.Companion.getEmpty();
        }
        this(outPoint, byteVector, l, scriptWitness);
    }

    public TxIn(@NotNull OutPoint outPoint, @NotNull byte[] signatureScript, long sequence) {
        Intrinsics.checkNotNullParameter((Object)outPoint, (String)"outPoint");
        Intrinsics.checkNotNullParameter((Object)signatureScript, (String)"signatureScript");
        this(outPoint, ByteVectorKt.byteVector(signatureScript), sequence, null, 8, null);
    }

    public TxIn(@NotNull OutPoint outPoint, long sequence) {
        Intrinsics.checkNotNullParameter((Object)outPoint, (String)"outPoint");
        this(outPoint, ByteVector.empty, sequence, null, 8, null);
    }

    public TxIn(@NotNull OutPoint outPoint, @NotNull List<? extends ScriptElt> signatureScript, long sequence) {
        Intrinsics.checkNotNullParameter((Object)outPoint, (String)"outPoint");
        Intrinsics.checkNotNullParameter(signatureScript, (String)"signatureScript");
        this(outPoint, Script.write(signatureScript), sequence);
    }

    public final boolean isFinal() {
        return this.sequence == 0xFFFFFFFFL;
    }

    public final boolean getHasWitness() {
        return this.witness.isNotNull();
    }

    @NotNull
    public final TxIn updateSignatureScript(@NotNull ByteVector signatureScript) {
        Intrinsics.checkNotNullParameter((Object)signatureScript, (String)"signatureScript");
        return TxIn.copy$default(this, null, signatureScript, 0L, null, 13, null);
    }

    @NotNull
    public final TxIn updateSignatureScript(@NotNull byte[] signatureScript) {
        Intrinsics.checkNotNullParameter((Object)signatureScript, (String)"signatureScript");
        return TxIn.copy$default(this, null, new ByteVector(signatureScript), 0L, null, 13, null);
    }

    @NotNull
    public final TxIn updateWitness(@NotNull ScriptWitness witness) {
        Intrinsics.checkNotNullParameter((Object)witness, (String)"witness");
        return TxIn.copy$default(this, null, null, 0L, witness, 7, null);
    }

    public final int weight() {
        return fr.acinq.bitcoin.TxIn$Companion.weight$default(Companion, this, 0L, 2, null);
    }

    @Override
    @NotNull
    public BtcSerializer<TxIn> serializer() {
        return Companion;
    }

    @NotNull
    public final OutPoint component1() {
        return this.outPoint;
    }

    @NotNull
    public final ByteVector component2() {
        return this.signatureScript;
    }

    public final long component3() {
        return this.sequence;
    }

    @NotNull
    public final ScriptWitness component4() {
        return this.witness;
    }

    @NotNull
    public final TxIn copy(@NotNull OutPoint outPoint, @NotNull ByteVector signatureScript, long sequence, @NotNull ScriptWitness witness) {
        Intrinsics.checkNotNullParameter((Object)outPoint, (String)"outPoint");
        Intrinsics.checkNotNullParameter((Object)signatureScript, (String)"signatureScript");
        Intrinsics.checkNotNullParameter((Object)witness, (String)"witness");
        return new TxIn(outPoint, signatureScript, sequence, witness);
    }

    public static /* synthetic */ TxIn copy$default(TxIn txIn, OutPoint outPoint, ByteVector byteVector, long l, ScriptWitness scriptWitness, int n, Object object) {
        if ((n & 1) != 0) {
            outPoint = txIn.outPoint;
        }
        if ((n & 2) != 0) {
            byteVector = txIn.signatureScript;
        }
        if ((n & 4) != 0) {
            l = txIn.sequence;
        }
        if ((n & 8) != 0) {
            scriptWitness = txIn.witness;
        }
        return txIn.copy(outPoint, byteVector, l, scriptWitness);
    }

    @NotNull
    public String toString() {
        return "TxIn(outPoint=" + this.outPoint + ", signatureScript=" + this.signatureScript + ", sequence=" + this.sequence + ", witness=" + this.witness + ')';
    }

    public int hashCode() {
        int result = this.outPoint.hashCode();
        result = result * 31 + this.signatureScript.hashCode();
        result = result * 31 + Long.hashCode(this.sequence);
        result = result * 31 + this.witness.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TxIn)) {
            return false;
        }
        TxIn txIn = (TxIn)other;
        if (!Intrinsics.areEqual((Object)this.outPoint, (Object)txIn.outPoint)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signatureScript, (Object)txIn.signatureScript)) {
            return false;
        }
        if (this.sequence != txIn.sequence) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.witness, (Object)txIn.witness);
    }

    @JvmStatic
    @NotNull
    public static TxIn read(@NotNull Input input, long protocolVersion) {
        return Companion.read(input, protocolVersion);
    }

    @JvmStatic
    public static void write(@NotNull TxIn message, @NotNull Output out, long protocolVersion) {
        Companion.write(message, out, protocolVersion);
    }

    @JvmStatic
    public static void validate(@NotNull TxIn input) {
        Companion.validate(input);
    }

    @JvmStatic
    @NotNull
    public static final TxIn coinbase(@NotNull byte[] script) {
        return Companion.coinbase(script);
    }

    @JvmStatic
    @NotNull
    public static final TxIn coinbase(@NotNull List<? extends ScriptElt> script) {
        return Companion.coinbase(script);
    }

    @JvmStatic
    public static final int weight(@NotNull TxIn txIn, long protocolVersion) {
        return Companion.weight(txIn, protocolVersion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\n\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0002H\u0017J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u0005H\u0007J \u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lfr/acinq/bitcoin/TxIn$Companion;", "Lfr/acinq/bitcoin/BtcSerializer;", "Lfr/acinq/bitcoin/TxIn;", "()V", "SEQUENCE_FINAL", "", "SEQUENCE_LOCKTIME_DISABLE_FLAG", "SEQUENCE_LOCKTIME_GRANULARITY", "SEQUENCE_LOCKTIME_MASK", "SEQUENCE_LOCKTIME_TYPE_FLAG", "coinbase", "script", "", "", "Lfr/acinq/bitcoin/ScriptElt;", "read", "input", "Lfr/acinq/bitcoin/io/Input;", "protocolVersion", "validate", "", "weight", "", "txIn", "write", "message", "out", "Lfr/acinq/bitcoin/io/Output;", "bitcoin-kmp"})
    @SourceDebugExtension(value={"SMAP\nTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transaction.kt\nfr/acinq/bitcoin/TxIn$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,795:1\n1#2:796\n*E\n"})
    public static final class Companion
    extends BtcSerializer<TxIn> {
        private Companion() {
        }

        @Override
        @JvmStatic
        @NotNull
        public TxIn read(@NotNull Input input, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return new TxIn((OutPoint)OutPoint.Companion.read(input), BtcSerializer.Companion.script(input), (long)BtcSerializer.Companion.uint32-OGnWXxg(input) & 0xFFFFFFFFL);
        }

        @Override
        @JvmStatic
        public void write(@NotNull TxIn message, @NotNull Output out, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            OutPoint.Companion.write(message.outPoint, out);
            BtcSerializer.Companion.writeScript(message.signatureScript, out);
            BtcSerializer.Companion.writeUInt32-qim9Vi0(UInt.constructor-impl((int)((int)message.sequence)), out);
        }

        @Override
        @JvmStatic
        public void validate(@NotNull TxIn input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (!(input.signatureScript.size() <= 520)) {
                boolean bl = false;
                String string = "signature script is " + input.signatureScript.size() + " bytes, limit is " + Script.INSTANCE + ".MaxScriptElementSize bytes";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @JvmStatic
        @NotNull
        public final TxIn coinbase(@NotNull byte[] script) {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            int n = script.length;
            if (!(2 <= n ? n < 101 : false)) {
                boolean bl = false;
                String string = "coinbase script length must be between 2 and 100";
                throw new IllegalArgumentException(string.toString());
            }
            return new TxIn(new OutPoint(new byte[32], 0xFFFFFFFFL), script, 0xFFFFFFFFL);
        }

        @JvmStatic
        @NotNull
        public final TxIn coinbase(@NotNull List<? extends ScriptElt> script) {
            Intrinsics.checkNotNullParameter(script, (String)"script");
            return this.coinbase(Script.write(script));
        }

        @JvmStatic
        public final int weight(@NotNull TxIn txIn, long protocolVersion) {
            Intrinsics.checkNotNullParameter((Object)txIn, (String)"txIn");
            int witnessWeight = txIn.getHasWitness() ? ScriptWitness.Companion.write(txIn.witness, protocolVersion).length : 0;
            return 4 * this.write(txIn).length + witnessWeight;
        }

        public static /* synthetic */ int weight$default(Companion companion, TxIn txIn, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = 70015L;
            }
            return companion.weight(txIn, l);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

