/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin;

import fr.acinq.bitcoin.ByteVector32;
import fr.acinq.bitcoin.ByteVectorKt;
import fr.acinq.bitcoin.Crypto;
import fr.acinq.bitcoin.PrivateKey;
import fr.acinq.bitcoin.PublicKey;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0006H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0017\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lfr/acinq/bitcoin/XonlyPublicKey;", "", "pub", "Lfr/acinq/bitcoin/PublicKey;", "(Lfr/acinq/bitcoin/PublicKey;)V", "value", "Lfr/acinq/bitcoin/ByteVector32;", "(Lfr/acinq/bitcoin/ByteVector32;)V", "publicKey", "getPublicKey", "()Lfr/acinq/bitcoin/PublicKey;", "component1", "copy", "equals", "", "other", "hashCode", "", "outputKey", "Lkotlin/Pair;", "tapTweak", "Lfr/acinq/bitcoin/Crypto$TaprootTweak;", "plus", "that", "toString", "", "tweak", "bitcoin-kmp"})
public final class XonlyPublicKey {
    @JvmField
    @NotNull
    public final ByteVector32 value;
    @NotNull
    private final PublicKey publicKey;

    public XonlyPublicKey(@NotNull ByteVector32 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        byte[] byArray = new byte[]{2};
        this.publicKey = new PublicKey(ArraysKt.plus((byte[])byArray, (byte[])this.value.toByteArray()));
    }

    public XonlyPublicKey(@NotNull PublicKey pub) {
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        this(ByteVectorKt.byteVector32(pub.value.drop(1).toByteArray()));
    }

    @NotNull
    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    @NotNull
    public final ByteVector32 tweak(@NotNull Crypto.TaprootTweak tapTweak) {
        ByteVector32 byteVector32;
        Intrinsics.checkNotNullParameter((Object)tapTweak, (String)"tapTweak");
        Crypto.TaprootTweak taprootTweak = tapTweak;
        if (Intrinsics.areEqual((Object)taprootTweak, (Object)Crypto.TaprootTweak.NoScriptTweak.INSTANCE)) {
            byteVector32 = Crypto.taggedHash(this.value.toByteArray(), "TapTweak");
        } else if (taprootTweak instanceof Crypto.TaprootTweak.ScriptTweak) {
            byteVector32 = Crypto.taggedHash(ArraysKt.plus((byte[])this.value.toByteArray(), (byte[])((Crypto.TaprootTweak.ScriptTweak)tapTweak).getMerkleRoot().toByteArray()), "TapTweak");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return byteVector32;
    }

    @NotNull
    public final Pair<XonlyPublicKey, Boolean> outputKey(@NotNull Crypto.TaprootTweak tapTweak) {
        Intrinsics.checkNotNullParameter((Object)tapTweak, (String)"tapTweak");
        return this.plus(new PrivateKey(this.tweak(tapTweak)).publicKey());
    }

    @NotNull
    public final Pair<XonlyPublicKey, Boolean> plus(@NotNull PublicKey that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        PublicKey pub = this.publicKey.plus(that);
        return new Pair((Object)new XonlyPublicKey(pub), (Object)pub.isOdd());
    }

    @NotNull
    public final ByteVector32 component1() {
        return this.value;
    }

    @NotNull
    public final XonlyPublicKey copy(@NotNull ByteVector32 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new XonlyPublicKey(value);
    }

    public static /* synthetic */ XonlyPublicKey copy$default(XonlyPublicKey xonlyPublicKey, ByteVector32 byteVector32, int n, Object object) {
        if ((n & 1) != 0) {
            byteVector32 = xonlyPublicKey.value;
        }
        return xonlyPublicKey.copy(byteVector32);
    }

    @NotNull
    public String toString() {
        return "XonlyPublicKey(value=" + this.value + ')';
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof XonlyPublicKey)) {
            return false;
        }
        XonlyPublicKey xonlyPublicKey = (XonlyPublicKey)other;
        return Intrinsics.areEqual((Object)this.value, (Object)xonlyPublicKey.value);
    }
}

