/*
 * Decompiled with CFR 0.152.
 */
package fr.acinq.bitcoin.crypto;

import fr.acinq.bitcoin.crypto.Digest;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lfr/acinq/bitcoin/crypto/DigestJvm;", "Lfr/acinq/bitcoin/crypto/Digest;", "algorithmName", "", "(Ljava/lang/String;)V", "digest", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "doFinal", "", "out", "", "outOffset", "getAlgorithmName", "getDigestSize", "reset", "", "update", "input", "", "inputOffset", "len", "bitcoin-kmp"})
public final class DigestJvm
implements Digest {
    private final MessageDigest digest;

    public DigestJvm(@NotNull String algorithmName) {
        Intrinsics.checkNotNullParameter((Object)algorithmName, (String)"algorithmName");
        this.digest = MessageDigest.getInstance(algorithmName);
    }

    @Override
    @NotNull
    public String getAlgorithmName() {
        String string = this.digest.getAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"digest.algorithm");
        return string;
    }

    @Override
    public int getDigestSize() {
        return this.digest.getDigestLength();
    }

    @Override
    public void update(byte input) {
        this.digest.update(input);
    }

    @Override
    public void update(@NotNull byte[] input, int inputOffset, int len) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.digest.update(input, inputOffset, len);
    }

    @Override
    public int doFinal(@NotNull byte[] out, int outOffset) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return this.digest.digest(out, outOffset, out.length - outOffset);
    }

    @Override
    public void reset() {
        this.digest.reset();
    }

    @Override
    @NotNull
    public byte[] hash(@NotNull byte[] input, int inputOffset, int len) {
        return Digest.DefaultImpls.hash(this, input, inputOffset, len);
    }

    @Override
    @NotNull
    public byte[] hash(@NotNull byte[] input) {
        return Digest.DefaultImpls.hash(this, input);
    }
}

