/*
 * Decompiled with CFR 0.152.
 */
package fr.vsct.tock.bot.mongo;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import fr.vsct.tock.bot.admin.bot.BotApplicationConfiguration;
import fr.vsct.tock.bot.admin.bot.BotApplicationConfigurationDAO;
import fr.vsct.tock.bot.admin.bot.BotApplicationConfiguration_;
import fr.vsct.tock.bot.mongo.BotApplicationConfigurationMongoDAO;
import fr.vsct.tock.bot.mongo.BotApplicationConfigurationMongoDAO$listenChanges$;
import fr.vsct.tock.bot.mongo.MongoBotConfiguration;
import fr.vsct.tock.shared.LoggersKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.SharedExtensionsKt;
import org.litote.kmongo.reactivestreams.MongoSharedCollectionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0016\u0010\u001a\u001a\u00020\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lfr/vsct/tock/bot/mongo/BotApplicationConfigurationMongoDAO;", "Lfr/vsct/tock/bot/admin/bot/BotApplicationConfigurationDAO;", "()V", "asyncCol", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lfr/vsct/tock/bot/admin/bot/BotApplicationConfiguration;", "col", "Lcom/mongodb/client/MongoCollection;", "logger", "Lmu/KLogger;", "delete", "", "conf", "getConfigurationByApplicationIdAndBotId", "applicationId", "", "botId", "getConfigurationById", "id", "Lorg/litote/kmongo/Id;", "getConfigurations", "", "getConfigurationsByBotId", "getConfigurationsByNamespaceAndNlpModel", "namespace", "nlpModel", "listenChanges", "listener", "Lkotlin/Function0;", "save", "tock-bot-storage-mongo"})
public final class BotApplicationConfigurationMongoDAO
implements BotApplicationConfigurationDAO {
    private static final KLogger logger;
    private static final MongoCollection<BotApplicationConfiguration> col;
    private static final com.mongodb.reactivestreams.client.MongoCollection<BotApplicationConfiguration> asyncCol;
    public static final BotApplicationConfigurationMongoDAO INSTANCE;

    /*
     * WARNING - void declaration
     */
    public void listenChanges(@NotNull Function0<Unit> listener2) {
        void reopenListener$iv$iv;
        void errorListener$iv$iv;
        void subscribeListener$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        com.mongodb.reactivestreams.client.MongoCollection<BotApplicationConfiguration> mongoCollection = asyncCol;
        Function1 listener$iv = (Function1)new Function1<ChangeStreamDocument<BotApplicationConfiguration>, Unit>(listener2){
            final /* synthetic */ Function0 $listener;

            public final void invoke(@NotNull ChangeStreamDocument<BotApplicationConfiguration> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.$listener.invoke();
            }
            {
                this.$listener = function0;
                super(1);
            }
        };
        FullDocument fullDocument$iv = FullDocument.DEFAULT;
        boolean $i$f$watch = false;
        void var6_6 = $receiver$iv;
        Function0 function0 = listenChanges$$inlined$watch$1.INSTANCE;
        Function1 function1 = listenChanges$$inlined$watch$2.INSTANCE;
        Function0 function02 = listenChanges$$inlined$watch$3.INSTANCE;
        long reopenDelayInMS$iv$iv = 5000L;
        boolean $i$f$watchIndefinitely = false;
        MongoSharedCollectionsKt.watchIndefinitely((com.mongodb.reactivestreams.client.MongoCollection)$receiver$iv$iv, (Function1)((Function1)new Function1<com.mongodb.reactivestreams.client.MongoCollection<BotApplicationConfiguration>, ChangeStreamPublisher<BotApplicationConfiguration>>((com.mongodb.reactivestreams.client.MongoCollection)$receiver$iv$iv, fullDocument$iv){
            final /* synthetic */ com.mongodb.reactivestreams.client.MongoCollection $this_watchIndefinitely;
            final /* synthetic */ FullDocument $fullDocument;
            {
                this.$this_watchIndefinitely = mongoCollection;
                this.$fullDocument = fullDocument;
                super(1);
            }

            public final ChangeStreamPublisher<BotApplicationConfiguration> invoke(@NotNull com.mongodb.reactivestreams.client.MongoCollection<BotApplicationConfiguration> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                ChangeStreamPublisher changeStreamPublisher = this.$this_watchIndefinitely.watch(BotApplicationConfiguration.class).fullDocument(this.$fullDocument);
                Intrinsics.checkExpressionValueIsNotNull((Object)changeStreamPublisher, (String)"watch(T::class.java).fullDocument(fullDocument)");
                return changeStreamPublisher;
            }
        }), (Function0)subscribeListener$iv$iv, (Function1)errorListener$iv$iv, (Function0)reopenListener$iv$iv, (long)reopenDelayInMS$iv$iv, (Function1)listener$iv);
    }

    @Nullable
    public BotApplicationConfiguration getConfigurationById(@NotNull Id<BotApplicationConfiguration> id) {
        Intrinsics.checkParameterIsNotNull(id, (String)"id");
        BotApplicationConfiguration botApplicationConfiguration = (BotApplicationConfiguration)MongoCollectionsKt.findOneById(col, id);
        if (botApplicationConfiguration == null) {
            botApplicationConfiguration = (BotApplicationConfiguration)MongoCollectionsKt.findOneById(col, (Object)new ObjectId(id.toString()));
        }
        return botApplicationConfiguration;
    }

    @Nullable
    public BotApplicationConfiguration getConfigurationByApplicationIdAndBotId(@NotNull String applicationId, @NotNull String botId) {
        Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        return (BotApplicationConfiguration)MongoCollectionsKt.findOne(col, (Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)BotApplicationConfiguration_.Companion.getApplicationId()), (Object)applicationId), FiltersKt.eq((KProperty)((KProperty)BotApplicationConfiguration_.Companion.getBotId()), (Object)botId)});
    }

    @NotNull
    public List<BotApplicationConfiguration> getConfigurationsByBotId(@NotNull String botId) {
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        FindIterable findIterable = col.find(FiltersKt.eq((KProperty)((KProperty)BotApplicationConfiguration_.Companion.getBotId()), (Object)botId));
        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"col.find(BotId eq botId)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    @NotNull
    public BotApplicationConfiguration save(@NotNull BotApplicationConfiguration conf2) {
        BotApplicationConfiguration botApplicationConfiguration;
        Intrinsics.checkParameterIsNotNull((Object)conf2, (String)"conf");
        try {
            MongoCollectionsKt.save(col, (Object)conf2);
            botApplicationConfiguration = conf2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            String filter = "{applicationId:" + SharedExtensionsKt.getJson((Object)conf2.getApplicationId()) + ", botId:" + SharedExtensionsKt.getJson((Object)conf2.getBotId()) + '}';
            MongoCollectionsKt.deleteOne(col, (String)filter);
            col.insertOne((Object)conf2);
            Object object = MongoCollectionsKt.findOne(col, (String)filter);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            botApplicationConfiguration = (BotApplicationConfiguration)object;
        }
        return botApplicationConfiguration;
    }

    public void delete(@NotNull BotApplicationConfiguration conf2) {
        Intrinsics.checkParameterIsNotNull((Object)conf2, (String)"conf");
        MongoCollectionsKt.deleteOneById(col, (Object)conf2.get_id());
        MongoCollectionsKt.deleteOneById(col, (Object)new ObjectId(conf2.get_id().toString()));
    }

    @NotNull
    public List<BotApplicationConfiguration> getConfigurationsByNamespaceAndNlpModel(@NotNull String namespace, @NotNull String nlpModel) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)nlpModel, (String)"nlpModel");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)MongoCollectionsKt.find(col, (Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)BotApplicationConfiguration_.Companion.getNamespace()), (Object)namespace), FiltersKt.eq((KProperty)((KProperty)BotApplicationConfiguration_.Companion.getNlpModel()), (Object)nlpModel)})));
    }

    @NotNull
    public List<BotApplicationConfiguration> getConfigurations() {
        FindIterable findIterable = col.find();
        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"col.find()");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    private BotApplicationConfigurationMongoDAO() {
    }

    static {
        com.mongodb.reactivestreams.client.MongoDatabase $receiver$iv;
        BotApplicationConfigurationMongoDAO botApplicationConfigurationMongoDAO;
        INSTANCE = botApplicationConfigurationMongoDAO = new BotApplicationConfigurationMongoDAO();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        MongoDatabase mongoDatabase = MongoBotConfiguration.INSTANCE.getDatabase();
        String collectionName$iv = "bot_configuration";
        boolean $i$f$getCollection = false;
        void $receiver$iv$iv = $receiver$iv;
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $receiver$iv$iv.getCollection(collectionName$iv, BotApplicationConfiguration.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection, (String)"getCollection(collectionName, T::class.java)");
        col = mongoCollection;
        $receiver$iv = MongoBotConfiguration.INSTANCE.getAsyncDatabase();
        collectionName$iv = "bot_configuration";
        boolean $i$f$getCollectionOfName2 = false;
        com.mongodb.reactivestreams.client.MongoCollection mongoCollection2 = $receiver$iv.getCollection(collectionName$iv, BotApplicationConfiguration.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection2, (String)"getCollection(collectionName, T::class.java)");
        asyncCol = mongoCollection2;
        MongoCollectionsKt.ensureUniqueIndex$default(col, (KProperty[])new KProperty[]{(KProperty)BotApplicationConfiguration_.Companion.getApplicationId(), (KProperty)BotApplicationConfiguration_.Companion.getBotId()}, null, (int)2, null);
    }
}

