/*
 * Decompiled with CFR 0.152.
 */
package fr.vsct.tock.bot.mongo;

import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.mongodb.Function;
import com.mongodb.ReadPreference;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import fr.vsct.tock.bot.admin.bot.BotApplicationConfiguration;
import fr.vsct.tock.bot.admin.bot.BotApplicationConfigurationDAO;
import fr.vsct.tock.bot.admin.dialog.DialogReport;
import fr.vsct.tock.bot.admin.dialog.DialogReportDAO;
import fr.vsct.tock.bot.admin.dialog.DialogReportQuery;
import fr.vsct.tock.bot.admin.dialog.DialogReportQueryResult;
import fr.vsct.tock.bot.admin.user.UserReportDAO;
import fr.vsct.tock.bot.admin.user.UserReportQuery;
import fr.vsct.tock.bot.admin.user.UserReportQueryResult;
import fr.vsct.tock.bot.connector.ConnectorMessage;
import fr.vsct.tock.bot.connector.ConnectorType;
import fr.vsct.tock.bot.definition.Intent;
import fr.vsct.tock.bot.definition.StoryDefinition;
import fr.vsct.tock.bot.engine.action.Action;
import fr.vsct.tock.bot.engine.action.SendSentence;
import fr.vsct.tock.bot.engine.dialog.Dialog;
import fr.vsct.tock.bot.engine.dialog.EntityStateValue;
import fr.vsct.tock.bot.engine.dialog.EntityValue;
import fr.vsct.tock.bot.engine.dialog.Snapshot;
import fr.vsct.tock.bot.engine.nlp.NlpCallStats;
import fr.vsct.tock.bot.engine.user.PlayerId;
import fr.vsct.tock.bot.engine.user.PlayerType;
import fr.vsct.tock.bot.engine.user.UserTimeline;
import fr.vsct.tock.bot.engine.user.UserTimelineDAO;
import fr.vsct.tock.bot.mongo.ClientIdCol;
import fr.vsct.tock.bot.mongo.ClientIdCol_;
import fr.vsct.tock.bot.mongo.ConnectorMessageCol;
import fr.vsct.tock.bot.mongo.ConnectorMessageColId;
import fr.vsct.tock.bot.mongo.DialogCol;
import fr.vsct.tock.bot.mongo.DialogCol_;
import fr.vsct.tock.bot.mongo.DialogTextCol;
import fr.vsct.tock.bot.mongo.DialogTextCol_;
import fr.vsct.tock.bot.mongo.MongoBotConfiguration;
import fr.vsct.tock.bot.mongo.MongoUserLock;
import fr.vsct.tock.bot.mongo.NlpStatsCol;
import fr.vsct.tock.bot.mongo.NlpStatsColId;
import fr.vsct.tock.bot.mongo.NlpStatsCol_;
import fr.vsct.tock.bot.mongo.SendSentenceWithNotLoadedMessage;
import fr.vsct.tock.bot.mongo.SnapshotCol;
import fr.vsct.tock.bot.mongo.SnapshotCol_;
import fr.vsct.tock.bot.mongo.UserTimelineCol;
import fr.vsct.tock.bot.mongo.UserTimelineCol_;
import fr.vsct.tock.bot.mongo.UserTimelineMongoDAO;
import fr.vsct.tock.shared.Executor;
import fr.vsct.tock.shared.IOCsKt;
import fr.vsct.tock.shared.LoggersKt;
import fr.vsct.tock.shared.PropertiesKt;
import fr.vsct.tock.shared.jackson.AnyValueWrapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.KMongoIterableKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.AggregatesKt;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.MongoOperator;
import org.litote.kmongo.SharedExtensionsKt;
import org.litote.kmongo.SortsKt;
import org.litote.kmongo.UpdatesKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J*\u0010(\u001a\b\u0012\u0004\u0012\u00020'0)2\u0006\u0010*\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020.0-H\u0016J\u0018\u0010/\u001a\u0004\u0018\u0001002\f\u00101\u001a\b\u0012\u0004\u0012\u00020'02H\u0016J*\u00103\u001a\b\u0012\u0004\u0012\u00020'0)2\u0006\u00104\u001a\u0002052\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020.0-H\u0016J\u0012\u00106\u001a\u0004\u0018\u00010+2\u0006\u00107\u001a\u000208H\u0016J \u00109\u001a\u0004\u0018\u00010:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<022\u0006\u0010=\u001a\u00020+H\u0016J\u001c\u0010>\u001a\b\u0012\u0004\u0012\u00020?0)2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020'02H\u0016J\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020B0)2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020+0)H\u0016J/\u0010D\u001a\b\u0012\u0004\u0012\u00020E0)2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<022\f\u0010@\u001a\b\u0012\u0004\u0012\u00020'02H\u0000\u00a2\u0006\u0002\bFJ2\u0010G\u001a\u0004\u0018\u00010'2\u0006\u0010H\u001a\u0002082\n\b\u0002\u0010I\u001a\u0004\u0018\u00010+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020.0-H\u0002J\u0012\u0010J\u001a\u0004\u0018\u00010\u00112\u0006\u0010H\u001a\u000208H\u0002J\u0012\u0010K\u001a\u0004\u0018\u00010\u00112\u0006\u0010I\u001a\u00020+H\u0002J+\u0010L\u001a\u0004\u0018\u00010:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<022\f\u0010@\u001a\b\u0012\u0004\u0012\u00020'02H\u0000\u00a2\u0006\u0002\bMJ8\u0010N\u001a\u00020B2\u0006\u0010H\u001a\u0002082\b\u0010O\u001a\u0004\u0018\u0001082\b\u0010I\u001a\u0004\u0018\u00010+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020.0-H\u0016J\u0010\u0010P\u001a\u00020B2\u0006\u0010H\u001a\u000208H\u0016J\u0010\u0010Q\u001a\u00020%2\u0006\u00107\u001a\u000208H\u0016J\u0010\u0010R\u001a\u00020%2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010S\u001a\u00020%2\u0006\u0010T\u001a\u00020BH\u0016J2\u0010U\u001a\u00020%2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<022\f\u0010@\u001a\b\u0012\u0004\u0012\u00020'022\f\u0010V\u001a\b\u0012\u0004\u0012\u00020E0)H\u0002J,\u0010W\u001a\u00020%2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<022\f\u0010@\u001a\b\u0012\u0004\u0012\u00020'022\u0006\u0010X\u001a\u00020:H\u0002J\u0010\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\H\u0016J\u0010\u0010Y\u001a\u00020]2\u0006\u0010[\u001a\u00020^H\u0016J\u0010\u0010_\u001a\u00020+2\u0006\u0010`\u001a\u00020+H\u0002J\u0018\u0010a\u001a\u00020%2\u0006\u0010b\u001a\u0002082\u0006\u0010c\u001a\u000208H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\n\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0013\u00a8\u0006d"}, d2={"Lfr/vsct/tock/bot/mongo/UserTimelineMongoDAO;", "Lfr/vsct/tock/bot/engine/user/UserTimelineDAO;", "Lfr/vsct/tock/bot/admin/user/UserReportDAO;", "Lfr/vsct/tock/bot/admin/dialog/DialogReportDAO;", "()V", "botConfiguration", "Lfr/vsct/tock/bot/admin/bot/BotApplicationConfigurationDAO;", "getBotConfiguration", "()Lfr/vsct/tock/bot/admin/bot/BotApplicationConfigurationDAO;", "botConfiguration$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "clientIdCol", "Lcom/mongodb/client/MongoCollection;", "Lfr/vsct/tock/bot/mongo/ClientIdCol;", "connectorMessageCol", "Lfr/vsct/tock/bot/mongo/ConnectorMessageCol;", "dialogCol", "Lfr/vsct/tock/bot/mongo/DialogCol;", "getDialogCol", "()Lcom/mongodb/client/MongoCollection;", "dialogTextCol", "Lfr/vsct/tock/bot/mongo/DialogTextCol;", "executor", "Lfr/vsct/tock/shared/Executor;", "getExecutor", "()Lfr/vsct/tock/shared/Executor;", "executor$delegate", "logger", "Lmu/KLogger;", "nlpStatsCol", "Lfr/vsct/tock/bot/mongo/NlpStatsCol;", "snapshotCol", "Lfr/vsct/tock/bot/mongo/SnapshotCol;", "userTimelineCol", "Lfr/vsct/tock/bot/mongo/UserTimelineCol;", "getUserTimelineCol", "addSnapshot", "", "dialog", "Lfr/vsct/tock/bot/engine/dialog/Dialog;", "getClientDialogs", "", "clientId", "", "storyDefinitionProvider", "Lkotlin/Function1;", "Lfr/vsct/tock/bot/definition/StoryDefinition;", "getDialog", "Lfr/vsct/tock/bot/admin/dialog/DialogReport;", "id", "Lorg/litote/kmongo/Id;", "getDialogsUpdatedFrom", "from", "Ljava/time/Instant;", "getLastStoryId", "playerId", "Lfr/vsct/tock/bot/engine/user/PlayerId;", "getNlpCallStats", "Lfr/vsct/tock/bot/engine/nlp/NlpCallStats;", "actionId", "Lfr/vsct/tock/bot/engine/action/Action;", "namespace", "getSnapshots", "Lfr/vsct/tock/bot/engine/dialog/Snapshot;", "dialogId", "loadByTemporaryIdsWithoutDialogs", "Lfr/vsct/tock/bot/engine/user/UserTimeline;", "temporaryIds", "loadConnectorMessage", "Lfr/vsct/tock/bot/connector/ConnectorMessage;", "loadConnectorMessage$tock_bot_storage_mongo", "loadLastValidDialog", "userId", "groupId", "loadLastValidDialogCol", "loadLastValidGroupDialogCol", "loadNlpStats", "loadNlpStats$tock_bot_storage_mongo", "loadWithLastValidDialog", "priorUserId", "loadWithoutDialogs", "remove", "removeClient", "save", "userTimeline", "saveConnectorMessage", "messages", "saveNlpStats", "nlpCallStats", "search", "Lfr/vsct/tock/bot/admin/dialog/DialogReportQueryResult;", "query", "Lfr/vsct/tock/bot/admin/dialog/DialogReportQuery;", "Lfr/vsct/tock/bot/admin/user/UserReportQueryResult;", "Lfr/vsct/tock/bot/admin/user/UserReportQuery;", "textKey", "text", "updatePlayerId", "oldPlayerId", "newPlayerId", "tock-bot-storage-mongo"})
public final class UserTimelineMongoDAO
implements UserTimelineDAO,
UserReportDAO,
DialogReportDAO {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final KLogger logger;
    private static final InjectedProperty botConfiguration$delegate;
    private static final InjectedProperty executor$delegate;
    @NotNull
    private static final MongoCollection<UserTimelineCol> userTimelineCol;
    @NotNull
    private static final MongoCollection<DialogCol> dialogCol;
    private static final MongoCollection<DialogTextCol> dialogTextCol;
    private static final MongoCollection<ClientIdCol> clientIdCol;
    private static final MongoCollection<ConnectorMessageCol> connectorMessageCol;
    private static final MongoCollection<NlpStatsCol> nlpStatsCol;
    private static final MongoCollection<SnapshotCol> snapshotCol;
    public static final UserTimelineMongoDAO INSTANCE;

    static {
        UserTimelineMongoDAO userTimelineMongoDAO;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(UserTimelineMongoDAO.class), "botConfiguration", "getBotConfiguration()Lfr/vsct/tock/bot/admin/bot/BotApplicationConfigurationDAO;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(UserTimelineMongoDAO.class), "executor", "getExecutor()Lfr/vsct/tock/shared/Executor;"))};
        INSTANCE = userTimelineMongoDAO = new UserTimelineMongoDAO();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<BotApplicationConfigurationDAO>(){};
        botConfiguration$delegate = kodeinInjector.Instance(typeToken, tag$iv);
        $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        tag$iv = null;
        kodeinInjector = $receiver$iv.getInjector();
        typeToken = (TypeToken)new TypeReference<Executor>(){};
        executor$delegate = kodeinInjector.Instance(typeToken, tag$iv);
        $receiver$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        String collectionName$iv = "user_timeline";
        boolean $i$f$getCollection = false;
        KodeinInjectedBase $receiver$iv$iv = $receiver$iv;
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $receiver$iv$iv.getCollection(collectionName$iv, UserTimelineCol.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection, (String)"getCollection(collectionName, T::class.java)");
        userTimelineCol = mongoCollection;
        $receiver$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        collectionName$iv = "dialog";
        $i$f$getCollection = false;
        $receiver$iv$iv = $receiver$iv;
        $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection2 = $receiver$iv$iv.getCollection(collectionName$iv, DialogCol.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection2, (String)"getCollection(collectionName, T::class.java)");
        dialogCol = mongoCollection2;
        $receiver$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        collectionName$iv = "dialog_text";
        $i$f$getCollection = false;
        $receiver$iv$iv = $receiver$iv;
        $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection3 = $receiver$iv$iv.getCollection(collectionName$iv, DialogTextCol.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection3, (String)"getCollection(collectionName, T::class.java)");
        dialogTextCol = mongoCollection3;
        $receiver$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        collectionName$iv = "client_id";
        $i$f$getCollection = false;
        $receiver$iv$iv = $receiver$iv;
        $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection4 = $receiver$iv$iv.getCollection(collectionName$iv, ClientIdCol.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection4, (String)"getCollection(collectionName, T::class.java)");
        clientIdCol = mongoCollection4;
        $receiver$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        collectionName$iv = "connector_message";
        $i$f$getCollection = false;
        $receiver$iv$iv = $receiver$iv;
        $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection5 = $receiver$iv$iv.getCollection(collectionName$iv, ConnectorMessageCol.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection5, (String)"getCollection(collectionName, T::class.java)");
        connectorMessageCol = mongoCollection5;
        $receiver$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        collectionName$iv = "action_nlp_stats";
        $i$f$getCollection = false;
        $receiver$iv$iv = $receiver$iv;
        $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection6 = $receiver$iv$iv.getCollection(collectionName$iv, NlpStatsCol.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection6, (String)"getCollection(collectionName, T::class.java)");
        nlpStatsCol = mongoCollection6;
        $receiver$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        collectionName$iv = "dialog_snapshot";
        $i$f$getCollection = false;
        $receiver$iv$iv = $receiver$iv;
        $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection7 = $receiver$iv$iv.getCollection(collectionName$iv, SnapshotCol.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection7, (String)"getCollection(collectionName, T::class.java)");
        snapshotCol = mongoCollection7;
        MongoCollectionsKt.ensureUniqueIndex$default(userTimelineCol, (KProperty[])new KProperty[]{(KProperty)UserTimelineCol_.Companion.getPlayerId().getId()}, null, (int)2, null);
        MongoCollectionsKt.ensureIndex$default(userTimelineCol, (KProperty[])new KProperty[]{(KProperty)UserTimelineCol_.Companion.getLastUpdateDate()}, null, (int)2, null);
        MongoCollectionsKt.ensureIndex$default(userTimelineCol, (KProperty[])new KProperty[]{(KProperty)UserTimelineCol_.Companion.getTemporaryIds()}, null, (int)2, null);
        MongoCollectionsKt.ensureIndex$default(dialogCol, (KProperty[])new KProperty[]{(KProperty)DialogCol_.Companion.getPlayerIds().getId()}, null, (int)2, null);
        MongoCollectionsKt.ensureIndex$default(dialogCol, (KProperty[])new KProperty[]{(KProperty)DialogCol_.Companion.getPlayerIds().getClientId()}, null, (int)2, null);
        IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(PropertiesKt.longProperty((String)"tock_bot_dialog_index_ttl_days", (long)7L)), TimeUnit.DAYS);
        Intrinsics.checkExpressionValueIsNotNull((Object)indexOptions, (String)"IndexOptions().expireAft\u2026ndex_ttl_days\", 7), DAYS)");
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)DialogCol_.Companion.getLastUpdateDate()};
        IndexOptions indexOptions2 = indexOptions;
        MongoCollectionsKt.ensureIndex(dialogCol, (KProperty[])kPropertyArray, (IndexOptions)indexOptions2);
        MongoCollectionsKt.ensureIndex$default(dialogCol, (Bson)SortsKt.orderBy((Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to(DialogCol_.Companion.getPlayerIds().getId(), (Object)true), TuplesKt.to(UserTimelineCol_.Companion.getLastUpdateDate(), (Object)false)})), null, (int)2, null);
        MongoCollectionsKt.ensureIndex$default(dialogCol, (KProperty[])new KProperty[]{(KProperty)DialogCol_.Companion.getGroupId()}, null, (int)2, null);
        MongoCollectionsKt.ensureIndex$default(dialogTextCol, (KProperty[])new KProperty[]{(KProperty)DialogTextCol_.Companion.getText()}, null, (int)2, null);
        MongoCollectionsKt.ensureUniqueIndex$default(dialogTextCol, (KProperty[])new KProperty[]{(KProperty)DialogTextCol_.Companion.getText(), (KProperty)DialogTextCol_.Companion.getDialogId()}, null, (int)2, null);
        IndexOptions indexOptions3 = new IndexOptions().expireAfter(Long.valueOf(PropertiesKt.longProperty((String)"tock_bot_dialog_index_ttl_days", (long)7L)), TimeUnit.DAYS);
        Intrinsics.checkExpressionValueIsNotNull((Object)indexOptions3, (String)"IndexOptions().expireAft\u2026ndex_ttl_days\", 7), DAYS)");
        kPropertyArray = new KProperty[]{(KProperty)DialogTextCol_.Companion.getDate()};
        indexOptions2 = indexOptions3;
        MongoCollectionsKt.ensureIndex(dialogTextCol, (KProperty[])kPropertyArray, (IndexOptions)indexOptions2);
        IndexOptions indexOptions4 = new IndexOptions().expireAfter(Long.valueOf(PropertiesKt.longProperty((String)"tock_bot_dialog_index_ttl_days", (long)7L)), TimeUnit.DAYS);
        Intrinsics.checkExpressionValueIsNotNull((Object)indexOptions4, (String)"IndexOptions().expireAft\u2026ndex_ttl_days\", 7), DAYS)");
        MongoCollectionsKt.ensureIndex(connectorMessageCol, (String)"{date:1}", (IndexOptions)indexOptions4);
        MongoCollectionsKt.ensureIndex$default(connectorMessageCol, (String)"{'_id.dialogId':1}", null, (int)2, null);
        IndexOptions indexOptions5 = new IndexOptions().expireAfter(Long.valueOf(PropertiesKt.longProperty((String)"tock_bot_dialog_index_ttl_days", (long)7L)), TimeUnit.DAYS);
        Intrinsics.checkExpressionValueIsNotNull((Object)indexOptions5, (String)"IndexOptions().expireAft\u2026ndex_ttl_days\", 7), DAYS)");
        kPropertyArray = new KProperty[]{(KProperty)DialogTextCol_.Companion.getDate()};
        indexOptions2 = indexOptions5;
        MongoCollectionsKt.ensureIndex(nlpStatsCol, (KProperty[])kPropertyArray, (IndexOptions)indexOptions2);
        MongoCollectionsKt.ensureIndex$default(nlpStatsCol, (KProperty[])new KProperty[]{(KProperty)NlpStatsCol_.Companion.get_id().getActionId(), (KProperty)NlpStatsCol_.Companion.getAppNamespace()}, null, (int)2, null);
        IndexOptions indexOptions6 = new IndexOptions().expireAfter(Long.valueOf(PropertiesKt.longProperty((String)"tock_bot_dialog_index_ttl_days", (long)7L)), TimeUnit.DAYS);
        Intrinsics.checkExpressionValueIsNotNull((Object)indexOptions6, (String)"IndexOptions().expireAft\u2026ndex_ttl_days\", 7), DAYS)");
        kPropertyArray = new KProperty[]{(KProperty)SnapshotCol_.Companion.getLastUpdateDate()};
        indexOptions2 = indexOptions6;
        MongoCollectionsKt.ensureIndex(snapshotCol, (KProperty[])kPropertyArray, (IndexOptions)indexOptions2);
    }

    private final String textKey(String text) {
        String string;
        if (text.length() > 512) {
            String string2 = text;
            int n = 0;
            int n2 = Math.min(512, text.length());
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = text;
        }
        return string;
    }

    private final BotApplicationConfigurationDAO getBotConfiguration() {
        return (BotApplicationConfigurationDAO)botConfiguration$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final Executor getExecutor() {
        return (Executor)executor$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @NotNull
    public final MongoCollection<UserTimelineCol> getUserTimelineCol() {
        return userTimelineCol;
    }

    @NotNull
    public final MongoCollection<DialogCol> getDialogCol() {
        return dialogCol;
    }

    public void save(@NotNull UserTimeline userTimeline) {
        Intrinsics.checkParameterIsNotNull((Object)userTimeline, (String)"userTimeline");
        logger.debug((Function0)new Function0<String>(userTimeline){
            final /* synthetic */ UserTimeline $userTimeline;

            @NotNull
            public final String invoke() {
                return "start to save timeline " + this.$userTimeline;
            }
            {
                this.$userTimeline = userTimeline;
                super(0);
            }
        });
        UserTimelineCol oldTimeline = (UserTimelineCol)MongoCollectionsKt.findOneById(userTimelineCol, (Object)userTimeline.getPlayerId().getId());
        logger.debug((Function0)new Function0<String>(userTimeline){
            final /* synthetic */ UserTimeline $userTimeline;

            @NotNull
            public final String invoke() {
                return "load old timeline " + this.$userTimeline;
            }
            {
                this.$userTimeline = userTimeline;
                super(0);
            }
        });
        UserTimelineCol newTimeline = new UserTimelineCol(userTimeline, oldTimeline);
        logger.debug((Function0)new Function0<String>(userTimeline){
            final /* synthetic */ UserTimeline $userTimeline;

            @NotNull
            public final String invoke() {
                return "create new timeline " + this.$userTimeline;
            }
            {
                this.$userTimeline = userTimeline;
                super(0);
            }
        });
        MongoCollectionsKt.save(userTimelineCol, (Object)newTimeline);
        logger.debug((Function0)new Function0<String>(userTimeline){
            final /* synthetic */ UserTimeline $userTimeline;

            @NotNull
            public final String invoke() {
                return "timeline saved " + this.$userTimeline;
            }
            {
                this.$userTimeline = userTimeline;
                super(0);
            }
        });
        for (Dialog dialog : userTimeline.getDialogs()) {
            DialogCol dialogToSave = new DialogCol(dialog, newTimeline);
            logger.debug((Function0)new Function0<String>(userTimeline){
                final /* synthetic */ UserTimeline $userTimeline;

                @NotNull
                public final String invoke() {
                    return "dialog to save created " + this.$userTimeline;
                }
                {
                    this.$userTimeline = userTimeline;
                    super(0);
                }
            });
            try {
                MongoCollectionsKt.save(dialogCol, (Object)dialogToSave);
            }
            catch (Exception e) {
                LoggersKt.error((KLogger)logger, (Throwable)e);
                logger.error("Dialog save failure: " + dialogToSave);
            }
            logger.debug((Function0)new Function0<String>(userTimeline){
                final /* synthetic */ UserTimeline $userTimeline;

                @NotNull
                public final String invoke() {
                    return "dialog saved " + this.$userTimeline;
                }
                {
                    this.$userTimeline = userTimeline;
                    super(0);
                }
            });
        }
        this.getExecutor().executeBlocking((Function0)new Function0<Unit>(userTimeline){
            final /* synthetic */ UserTimeline $userTimeline;

            public final void invoke() {
                block14: {
                    Object v8;
                    Dialog dialog;
                    Action action;
                    block13: {
                        if (this.$userTimeline.getPlayerId().getClientId() != null) {
                            MongoCollection mongoCollection = UserTimelineMongoDAO.access$getClientIdCol$p(UserTimelineMongoDAO.INSTANCE);
                            String string = this.$userTimeline.getPlayerId().getClientId();
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            MongoCollectionsKt.updateOneById((MongoCollection)mongoCollection, (Object)string, (Object)UpdatesKt.addEachToSet((KProperty)((KProperty)ClientIdCol_.Companion.getUserIds()), (List)CollectionsKt.listOf((Object)this.$userTimeline.getPlayerId().getId())), (UpdateOptions)UpdatesKt.upsert());
                        }
                        action = this.$userTimeline.getDialogs().iterator();
                        while (action.hasNext()) {
                            dialog = (Dialog)action.next();
                            UserTimelineMongoDAO.access$addSnapshot(UserTimelineMongoDAO.INSTANCE, dialog);
                            Iterable $receiver$iv = dialog.allActions();
                            for (T element$iv : $receiver$iv) {
                                Collection collection;
                                Action it = (Action)element$iv;
                                boolean bl = false;
                                Action action2 = it;
                                if (action2 instanceof SendSentenceWithNotLoadedMessage) {
                                    if (((SendSentenceWithNotLoadedMessage)it).getMessageLoaded$tock_bot_storage_mongo() && !(collection = (Collection)((SendSentenceWithNotLoadedMessage)it).getMessages()).isEmpty()) {
                                        UserTimelineMongoDAO.access$saveConnectorMessage(UserTimelineMongoDAO.INSTANCE, it.toActionId(), dialog.getId(), ((SendSentenceWithNotLoadedMessage)it).getMessages());
                                    }
                                    if (!((SendSentenceWithNotLoadedMessage)it).getNlpStatsLoaded$tock_bot_storage_mongo() || ((SendSentenceWithNotLoadedMessage)it).getNlpStats() == null) continue;
                                    Id id = it.toActionId();
                                    Id id2 = dialog.getId();
                                    NlpCallStats nlpCallStats = ((SendSentenceWithNotLoadedMessage)it).getNlpStats();
                                    if (nlpCallStats == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    UserTimelineMongoDAO.access$saveNlpStats(UserTimelineMongoDAO.INSTANCE, id, id2, nlpCallStats);
                                    continue;
                                }
                                if (!(action2 instanceof SendSentence)) continue;
                                collection = ((SendSentence)it).getMessages();
                                if (!collection.isEmpty()) {
                                    UserTimelineMongoDAO.access$saveConnectorMessage(UserTimelineMongoDAO.INSTANCE, it.toActionId(), dialog.getId(), ((SendSentence)it).getMessages());
                                }
                                if (((SendSentence)it).getNlpStats() == null) continue;
                                Id id = it.toActionId();
                                Id id3 = dialog.getId();
                                NlpCallStats nlpCallStats = ((SendSentence)it).getNlpStats();
                                if (nlpCallStats == null) {
                                    Intrinsics.throwNpe();
                                }
                                UserTimelineMongoDAO.access$saveNlpStats(UserTimelineMongoDAO.INSTANCE, id, id3, nlpCallStats);
                            }
                        }
                        dialog = this.$userTimeline.getCurrentDialog();
                        if (dialog == null) break block14;
                        List $receiver$iv = dialog.allActions();
                        ListIterator<E> iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            E element$iv = iterator$iv.previous();
                            Action it = (Action)element$iv;
                            boolean bl = false;
                            if (!(it.getPlayerId().getType() == PlayerType.user)) continue;
                            v8 = element$iv;
                            break block13;
                        }
                        v8 = null;
                    }
                    Action action3 = v8;
                    if (action3 != null) {
                        Action action4 = action = action3;
                        boolean bl = false;
                        if (action4 instanceof SendSentence && ((SendSentence)action4).getStringText() != null) {
                            String string = ((SendSentence)action4).getStringText();
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            String text = UserTimelineMongoDAO.access$textKey(UserTimelineMongoDAO.INSTANCE, string);
                            MongoCollection mongoCollection = UserTimelineMongoDAO.access$getDialogTextCol$p(UserTimelineMongoDAO.INSTANCE);
                            Bson bson = FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)DialogTextCol_.Companion.getText()), (Object)text), FiltersKt.eq((KProperty)((KProperty)DialogTextCol_.Companion.getDialogId()), (Object)dialog.getId())});
                            DialogTextCol dialogTextCol = new DialogTextCol(text, dialog.getId(), null, 4, null);
                            ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
                            Intrinsics.checkExpressionValueIsNotNull((Object)replaceOptions, (String)"ReplaceOptions().upsert(true)");
                            MongoCollectionsKt.replaceOneWithFilter((MongoCollection)mongoCollection, (Bson)bson, (Object)dialogTextCol, (ReplaceOptions)replaceOptions);
                        }
                    }
                }
            }
            {
                this.$userTimeline = userTimeline;
                super(0);
            }
        });
        logger.debug((Function0)new Function0<String>(userTimeline){
            final /* synthetic */ UserTimeline $userTimeline;

            @NotNull
            public final String invoke() {
                return "end saving timeline " + this.$userTimeline;
            }
            {
                this.$userTimeline = userTimeline;
                super(0);
            }
        });
    }

    public void updatePlayerId(@NotNull PlayerId oldPlayerId, @NotNull PlayerId newPlayerId) {
        Intrinsics.checkParameterIsNotNull((Object)oldPlayerId, (String)"oldPlayerId");
        Intrinsics.checkParameterIsNotNull((Object)newPlayerId, (String)"newPlayerId");
        MongoCollectionsKt.updateOneById$default(userTimelineCol, (Object)oldPlayerId.getId(), (Object)UpdatesKt.set((KProperty)((KProperty)UserTimelineCol_.Companion.getPlayerId()), (Object)newPlayerId), null, (int)4, null);
        dialogCol.updateMany(FiltersKt.contains((KProperty)((KProperty)DialogCol_.Companion.getPlayerIds()), (Object)oldPlayerId), UpdatesKt.addToSet((KProperty)((KProperty)DialogCol_.Companion.getPlayerIds()), (Object)newPlayerId));
        dialogCol.updateMany(FiltersKt.contains((KProperty)((KProperty)DialogCol_.Companion.getPlayerIds()), (Object)newPlayerId), UpdatesKt.pull((KProperty)((KProperty)DialogCol_.Companion.getPlayerIds()), (Object)oldPlayerId));
        if (newPlayerId.getClientId() != null) {
            String string = newPlayerId.getClientId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            MongoCollectionsKt.updateOneById(clientIdCol, (Object)string, (Object)UpdatesKt.addToSet((KProperty)((KProperty)ClientIdCol_.Companion.getUserIds()), (Object)newPlayerId.getId()), (UpdateOptions)UpdatesKt.upsert());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveConnectorMessage(Id<Action> actionId, Id<Dialog> dialogId, List<? extends ConnectorMessage> messages2) {
        Collection<AnyValueWrapper> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = messages2;
        ConnectorMessageColId connectorMessageColId = new ConnectorMessageColId(actionId, dialogId);
        MongoCollection<ConnectorMessageCol> mongoCollection = connectorMessageCol;
        void var5_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ConnectorMessage connectorMessage = (ConnectorMessage)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            AnyValueWrapper anyValueWrapper = new AnyValueWrapper((Object)it);
            collection.add(anyValueWrapper);
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        Instant instant = null;
        List list2 = collection;
        ConnectorMessageColId connectorMessageColId2 = connectorMessageColId;
        MongoCollectionsKt.save(mongoCollection, (Object)new ConnectorMessageCol(connectorMessageColId2, list2, instant, n, defaultConstructorMarker));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ConnectorMessage> loadConnectorMessage$tock_bot_storage_mongo(@NotNull Id<Action> actionId, @NotNull Id<Dialog> dialogId) {
        List list2;
        Intrinsics.checkParameterIsNotNull(actionId, (String)"actionId");
        Intrinsics.checkParameterIsNotNull(dialogId, (String)"dialogId");
        try {
            List list3;
            Object object = (ConnectorMessageCol)MongoCollectionsKt.findOneById(connectorMessageCol, (Object)new ConnectorMessageColId(actionId, dialogId));
            if (object != null && (object = ((ConnectorMessageCol)object).getMessages()) != null) {
                void $receiver$iv$iv;
                Iterable $receiver$iv = (Iterable)object;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ConnectorMessage connectorMessage;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    AnyValueWrapper it = (AnyValueWrapper)element$iv$iv;
                    boolean bl = false;
                    AnyValueWrapper anyValueWrapper = it;
                    Object object2 = anyValueWrapper != null ? anyValueWrapper.getValue() : null;
                    if (!(object2 instanceof ConnectorMessage)) {
                        object2 = null;
                    }
                    if ((ConnectorMessage)object2 == null) continue;
                    ConnectorMessage it$iv$iv = connectorMessage;
                    destination$iv$iv.add(it$iv$iv);
                }
                list3 = (List)destination$iv$iv;
            } else {
                list3 = CollectionsKt.emptyList();
            }
            list2 = list3;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final void saveNlpStats(Id<Action> actionId, Id<Dialog> dialogId, NlpCallStats nlpCallStats) {
        MongoCollectionsKt.save(nlpStatsCol, (Object)new NlpStatsCol(new NlpStatsColId(actionId, dialogId), nlpCallStats, nlpCallStats.getNlpQuery().getNamespace(), null, 8, null));
    }

    @Nullable
    public final NlpCallStats loadNlpStats$tock_bot_storage_mongo(@NotNull Id<Action> actionId, @NotNull Id<Dialog> dialogId) {
        NlpCallStats nlpCallStats;
        Intrinsics.checkParameterIsNotNull(actionId, (String)"actionId");
        Intrinsics.checkParameterIsNotNull(dialogId, (String)"dialogId");
        try {
            NlpStatsCol nlpStatsCol = (NlpStatsCol)MongoCollectionsKt.findOneById(UserTimelineMongoDAO.nlpStatsCol, (Object)new NlpStatsColId(actionId, dialogId));
            nlpCallStats = nlpStatsCol != null ? nlpStatsCol.getStats() : null;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            nlpCallStats = null;
        }
        return nlpCallStats;
    }

    @Nullable
    public NlpCallStats getNlpCallStats(@NotNull Id<Action> actionId, @NotNull String namespace) {
        NlpCallStats nlpCallStats;
        Intrinsics.checkParameterIsNotNull(actionId, (String)"actionId");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        try {
            NlpStatsCol nlpStatsCol = (NlpStatsCol)MongoCollectionsKt.findOne(UserTimelineMongoDAO.nlpStatsCol, (Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)NlpStatsCol_.Companion.get_id().getActionId()), actionId), FiltersKt.eq((KProperty)((KProperty)NlpStatsCol_.Companion.getAppNamespace()), (Object)namespace)});
            nlpCallStats = nlpStatsCol != null ? nlpStatsCol.getStats() : null;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            nlpCallStats = null;
        }
        return nlpCallStats;
    }

    @NotNull
    public UserTimeline loadWithLastValidDialog(@NotNull PlayerId userId, @Nullable PlayerId priorUserId, @Nullable String groupId, @NotNull Function1<? super String, ? extends StoryDefinition> storyDefinitionProvider) {
        Dialog $receiver;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        Intrinsics.checkParameterIsNotNull(storyDefinitionProvider, (String)"storyDefinitionProvider");
        UserTimeline timeline = this.loadWithoutDialogs(userId);
        Dialog dialog = this.loadLastValidDialog(userId, groupId, storyDefinitionProvider);
        if (dialog != null) {
            $receiver = object = dialog;
            boolean bl = false;
            timeline.getDialogs().add($receiver);
        }
        if (priorUserId != null) {
            timeline.getTemporaryIds().add(priorUserId.getId());
            UserTimelineCol userTimelineCol = (UserTimelineCol)MongoCollectionsKt.findOneById(UserTimelineMongoDAO.userTimelineCol, (Object)priorUserId.getId());
            if (userTimelineCol != null) {
                Map $receiver$iv;
                $receiver = object = userTimelineCol;
                boolean bl = false;
                Map map = $receiver$iv = $receiver.toUserTimeline().getUserState().getFlags();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    timeline.getUserState().getFlags().putIfAbsent(it.getKey(), it.getValue());
                }
            }
            Dialog dialog2 = this.loadLastValidDialog(priorUserId, groupId, storyDefinitionProvider);
            if (dialog2 != null) {
                $receiver = object = dialog2;
                boolean bl = false;
                timeline.getDialogs().add(Dialog.copy$default((Dialog)$receiver, (Set)SetsKt.plus((Set)$receiver.getPlayerIds(), (Object)userId), null, null, null, null, (int)30, null));
            }
        }
        logger.trace((Function0)new Function0<String>(userId, timeline){
            final /* synthetic */ PlayerId $userId;
            final /* synthetic */ UserTimeline $timeline;

            @NotNull
            public final String invoke() {
                return "timeline for user " + this.$userId + " : " + this.$timeline;
            }
            {
                this.$userId = playerId2;
                this.$timeline = userTimeline;
                super(0);
            }
        });
        return timeline;
    }

    public void remove(@NotNull PlayerId playerId2) {
        Intrinsics.checkParameterIsNotNull((Object)playerId2, (String)"playerId");
        dialogCol.deleteMany(FiltersKt.eq((KProperty)((KProperty)DialogCol_.Companion.getPlayerIds().getId()), (Object)playerId2.getId()));
        userTimelineCol.deleteOne(FiltersKt.eq((KProperty)((KProperty)UserTimelineCol_.Companion.getPlayerId().getId()), (Object)playerId2.getId()));
        MongoUserLock.INSTANCE.deleteLock(playerId2.getId());
    }

    public void removeClient(@NotNull String clientId) {
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        Object object = (ClientIdCol)MongoCollectionsKt.findOneById(clientIdCol, (Object)clientId);
        if (object != null && (object = ((ClientIdCol)object).getUserIds()) != null) {
            Iterable $receiver$iv = (Iterable)object;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                INSTANCE.remove(new PlayerId(it, null, null, 6, null));
            }
        }
    }

    @NotNull
    public UserTimeline loadWithoutDialogs(@NotNull PlayerId userId) {
        UserTimeline userTimeline;
        UserTimelineCol timeline;
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        UserTimelineCol userTimelineCol = (UserTimelineCol)MongoCollectionsKt.findOneById(UserTimelineMongoDAO.userTimelineCol, (Object)userId.getId());
        UserTimelineCol userTimelineCol2 = timeline = userTimelineCol != null ? UserTimelineCol.copy$default(userTimelineCol, null, userId, null, null, null, null, null, null, null, 509, null) : null;
        if (timeline == null) {
            logger.debug((Function0)new Function0<String>(userId){
                final /* synthetic */ PlayerId $userId;

                @NotNull
                public final String invoke() {
                    return "no timeline for user " + this.$userId;
                }
                {
                    this.$userId = playerId2;
                    super(0);
                }
            });
            userTimeline = new UserTimeline(userId, null, null, null, null, 30, null);
        } else {
            userTimeline = timeline.toUserTimeline();
        }
        return userTimeline;
    }

    @NotNull
    public List<UserTimeline> loadByTemporaryIdsWithoutDialogs(@NotNull List<String> temporaryIds2) {
        Intrinsics.checkParameterIsNotNull(temporaryIds2, (String)"temporaryIds");
        MongoIterable mongoIterable = userTimelineCol.find(FiltersKt.in((KProperty)((KProperty)UserTimelineCol_.Companion.getTemporaryIds()), (Iterable)temporaryIds2)).map((Function)loadByTemporaryIdsWithoutDialogs.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"userTimelineCol.find(Tem\u2026p { it.toUserTimeline() }");
        return KMongoIterableKt.toList((MongoIterable)mongoIterable);
    }

    /*
     * WARNING - void declaration
     */
    private final DialogCol loadLastValidGroupDialogCol(String groupId) {
        void $receiver$iv;
        MongoCollection<DialogCol> mongoCollection = dialogCol;
        Object[] pipeline$iv = new Bson[]{AggregatesKt.match((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)DialogCol_.Companion.getGroupId()), (Object)groupId), FiltersKt.gt((KProperty)((KProperty)UserTimelineCol_.Companion.getLastUpdateDate()), (Object)Instant.now().minusSeconds(86400L))}), AggregatesKt.sort((Bson)SortsKt.descending((KProperty[])new KProperty[]{(KProperty)UserTimelineCol_.Companion.getLastUpdateDate()})), AggregatesKt.limit((int)1)};
        boolean $i$f$aggregate = false;
        AggregateIterable aggregateIterable = $receiver$iv.aggregate(ArraysKt.toList((Object[])pipeline$iv), DialogCol.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)aggregateIterable, (String)"aggregate(pipeline.toList(), TResult::class.java)");
        return (DialogCol)KMongoIterableKt.firstOrNull((MongoIterable)((MongoIterable)aggregateIterable));
    }

    /*
     * WARNING - void declaration
     */
    private final DialogCol loadLastValidDialogCol(PlayerId userId) {
        void $receiver$iv;
        MongoCollection<DialogCol> mongoCollection = dialogCol;
        Object[] pipeline$iv = new Bson[]{AggregatesKt.match((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)DialogCol_.Companion.getPlayerIds().getId()), (Object)userId.getId()), FiltersKt.gt((KProperty)((KProperty)UserTimelineCol_.Companion.getLastUpdateDate()), (Object)Instant.now().minusSeconds(86400L))}), AggregatesKt.sort((Bson)SortsKt.descending((KProperty[])new KProperty[]{(KProperty)UserTimelineCol_.Companion.getLastUpdateDate()})), AggregatesKt.limit((int)1)};
        boolean $i$f$aggregate = false;
        AggregateIterable aggregateIterable = $receiver$iv.aggregate(ArraysKt.toList((Object[])pipeline$iv), DialogCol.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)aggregateIterable, (String)"aggregate(pipeline.toList(), TResult::class.java)");
        return (DialogCol)KMongoIterableKt.firstOrNull((MongoIterable)((MongoIterable)aggregateIterable));
    }

    private final Dialog loadLastValidDialog(PlayerId userId, String groupId, Function1<? super String, ? extends StoryDefinition> storyDefinitionProvider) {
        String string;
        try {
            Object object;
            block5: {
                block4: {
                    object = groupId;
                    if (object == null) break block4;
                    String it = string = object;
                    boolean bl = false;
                    object = INSTANCE.loadLastValidGroupDialogCol(it);
                    if (object != null) break block5;
                }
                object = this.loadLastValidDialogCol(userId);
            }
            string = object != null ? ((DialogCol)object).toDialog(storyDefinitionProvider) : null;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            string = null;
        }
        return string;
    }

    static /* synthetic */ Dialog loadLastValidDialog$default(UserTimelineMongoDAO userTimelineMongoDAO, PlayerId playerId2, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return userTimelineMongoDAO.loadLastValidDialog(playerId2, string, (Function1<? super String, ? extends StoryDefinition>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public UserReportQueryResult search(@NotNull UserReportQuery query) {
        UserReportQueryResult userReportQueryResult;
        BsonDocument bsonDocument;
        Bson bson;
        Object $receiver$iv$iv;
        Object $receiver$iv;
        Bson[] bsonArray;
        Bson[] bsonArray2;
        Object object;
        Object item$iv$iv2;
        Iterable $receiver$iv$iv2;
        void $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        UserReportQuery $receiver = query;
        boolean bl = false;
        Iterable iterable = INSTANCE.getBotConfiguration().getConfigurationsByNamespaceAndNlpModel(query.getNamespace(), query.getNlpModel());
        void var5_5 = $receiver$iv2;
        Bson[] destination$iv$iv = (Bson[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv2 : $receiver$iv$iv2) {
            void it;
            object = (BotApplicationConfiguration)item$iv$iv2;
            bsonArray2 = destination$iv$iv;
            boolean bl2 = false;
            bsonArray = it.getApplicationId();
            bsonArray2.add(bsonArray);
        }
        List applicationsIds = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $receiver$iv$iv2 = applicationsIds;
        KProperty kProperty = (KProperty)UserTimelineCol_.Companion.getApplicationIds();
        int n = 0;
        bsonArray2 = bsonArray = new Bson[5];
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        item$iv$iv2 = $receiver$iv$iv.iterator();
        while (item$iv$iv2.hasNext()) {
            Object element$iv$iv = item$iv$iv2.next();
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            CharSequence $i$f$map = it;
            if (!($i$f$map.length() > 0)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Object object2 = (List)destination$iv$iv2;
        bsonArray[n] = FiltersKt.in((KProperty)kProperty, (Iterable)((Iterable)object2));
        $receiver$iv = $receiver.getName();
        n = 1;
        bsonArray = bsonArray2;
        boolean bl4 = $receiver$iv == null || StringsKt.isBlank((CharSequence)$receiver$iv);
        Bson[] bsonArray3 = bsonArray2;
        Bson[] bsonArray4 = bsonArray;
        int n2 = n;
        if (bl4) {
            bson = null;
        } else {
            KProperty kProperty2 = (KProperty)UserTimelineCol_.Companion.getUserPreferences().getLastName();
            String string = $receiver.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv = string;
            KProperty kProperty3 = kProperty2;
            n = n2;
            bsonArray = bsonArray4;
            bsonArray2 = bsonArray3;
            CharSequence charSequence = $receiver$iv;
            if (charSequence == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object2 = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
            bsonArray3 = bsonArray2;
            bsonArray4 = bsonArray;
            n2 = n;
            bson = FiltersKt.regex((KProperty)kProperty3, (String)object2, (String)"i");
        }
        bsonArray4[n2] = bson;
        bsonArray3[2] = $receiver.getFrom() == null ? null : FiltersKt.gt((KProperty)((KProperty)UserTimelineCol_.Companion.getLastUpdateDate()), (Object)$receiver.getFrom());
        bsonArray3[3] = $receiver.getTo() == null ? null : FiltersKt.lt((KProperty)((KProperty)UserTimelineCol_.Companion.getLastUpdateDate()), (Object)$receiver.getTo());
        Bson[] bsonArray5 = bsonArray3;
        Bson[] bsonArray6 = bsonArray3;
        int n3 = 4;
        if ($receiver.getFlags().isEmpty()) {
            bsonDocument = null;
        } else {
            $receiver$iv = $receiver.getFlags();
            n = n3;
            bsonArray = bsonArray5;
            bsonArray2 = bsonArray6;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv2 = new ArrayList();
            item$iv$iv2 = $receiver$iv$iv;
            object = item$iv$iv2.entrySet().iterator();
            while (object.hasNext()) {
                String string;
                String string2;
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = (Map.Entry)object.next();
                boolean bl5 = false;
                String key = string2 = "userState.flags." + (String)it.getKey();
                boolean bl6 = false;
                Object[] objectArray = new String[2];
                if (it.getValue() == null) {
                    string = null;
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("{'").append(key).append(".value':");
                    Object v = it.getValue();
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    string = stringBuilder.append(SharedExtensionsKt.getJson(v)).append('}').toString();
                }
                objectArray[0] = string;
                StringBuilder stringBuilder = new StringBuilder().append('{').append(MongoOperator.or).append(":[{'").append(key).append(".expirationDate':{").append(MongoOperator.gt).append(':');
                Instant instant = Instant.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"now()");
                objectArray[1] = stringBuilder.append(SharedExtensionsKt.getJson((Object)instant)).append("}},{'").append(key).append(".expirationDate':{").append(MongoOperator.type).append(":10}}]}").toString();
                Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            bsonArray6 = bsonArray2;
            bsonArray5 = bsonArray;
            n3 = n;
            bsonDocument = SharedExtensionsKt.getBson((String)CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)",", (CharSequence)("" + '{' + MongoOperator.and + ":["), (CharSequence)"]}", (int)0, null, null, (int)56, null));
        }
        bsonArray5[n3] = (Bson)bsonDocument;
        Bson filter = FiltersKt.and((Bson[])bsonArray6);
        logger.debug("user search query: " + filter);
        MongoCollection c = userTimelineCol.withReadPreference(ReadPreference.secondaryPreferred());
        long count = c.countDocuments(filter);
        if (count > $receiver.getStart()) {
            FindIterable findIterable = c.find(filter).skip((int)$receiver.getStart()).limit($receiver.getSize());
            Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"c.find(filter)\n         \u2026tart.toInt()).limit(size)");
            MongoIterable mongoIterable = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)UserTimelineCol_.Companion.getLastUpdateDate()}).map((Function)search.1.list.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"c.find(filter)\n         \u2026map { it.toUserReport() }");
            List list3 = KMongoIterableKt.toList((MongoIterable)mongoIterable);
            userReportQueryResult = new UserReportQueryResult(count, $receiver.getStart(), $receiver.getStart() + (long)$receiver.getSize(), list3);
        } else {
            userReportQueryResult = new UserReportQueryResult(0L, 0L, 0L, CollectionsKt.emptyList());
        }
        return userReportQueryResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DialogReportQueryResult search(@NotNull DialogReportQuery query) {
        DialogReportQueryResult dialogReportQueryResult;
        Bson bson;
        Bson bson2;
        Bson bson3;
        void $receiver$iv$iv;
        CharSequence $receiver$iv;
        Set dialogIds2;
        Object object;
        UserTimelineMongoDAO userTimelineMongoDAO;
        Set set;
        Bson[] bsonArray;
        Bson[] bsonArray2;
        CharSequence $receiver$iv$iv2;
        void $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        DialogReportQuery $receiver = query;
        boolean bl = false;
        Iterable iterable = INSTANCE.getBotConfiguration().getConfigurationsByNamespaceAndNlpModel(query.getNamespace(), query.getNlpModel());
        void var5_5 = $receiver$iv2;
        Object destination$iv$iv = (Bson[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        Iterator iterator = $receiver$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Iterator it;
            Object item$iv$iv = iterator.next();
            BotApplicationConfiguration botApplicationConfiguration = (BotApplicationConfiguration)item$iv$iv;
            bsonArray2 = destination$iv$iv;
            boolean bl2 = false;
            bsonArray = it.getApplicationId();
            bsonArray2.add(bsonArray);
        }
        List applicationsIds = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        $receiver$iv$iv2 = query.getText();
        if ($receiver$iv$iv2 == null || StringsKt.isBlank((CharSequence)$receiver$iv$iv2)) {
            set = SetsKt.emptySet();
        } else if (query.getExactMatch()) {
            KProperty kProperty = (KProperty)DialogTextCol_.Companion.getText();
            String string = query.getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv$iv2 = string;
            userTimelineMongoDAO = INSTANCE;
            bsonArray = kProperty;
            bsonArray2 = dialogTextCol;
            CharSequence charSequence = $receiver$iv$iv2;
            if (charSequence == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
            MongoIterable mongoIterable = bsonArray2.find(FiltersKt.eq((KProperty)bsonArray, (Object)userTimelineMongoDAO.textKey((String)object))).map((Function)search.2.dialogIds.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"dialogTextCol.find(Text \u2026m())).map { it.dialogId }");
            set = KMongoIterableKt.toSet((MongoIterable)mongoIterable);
        } else {
            KProperty kProperty = (KProperty)DialogTextCol_.Companion.getText();
            String string = query.getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv$iv2 = string;
            userTimelineMongoDAO = INSTANCE;
            bsonArray = kProperty;
            bsonArray2 = dialogTextCol;
            CharSequence charSequence = $receiver$iv$iv2;
            if (charSequence == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
            MongoIterable mongoIterable = bsonArray2.find(FiltersKt.regex((KProperty)bsonArray, (String)userTimelineMongoDAO.textKey((String)object), (String)"i")).map((Function)search.2.dialogIds.2.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"dialogTextCol\n          \u2026     .map { it.dialogId }");
            set = dialogIds2 = KMongoIterableKt.toSet((MongoIterable)mongoIterable);
        }
        if (dialogIds2.isEmpty() && !(($receiver$iv$iv2 = (CharSequence)query.getText()) == null || StringsKt.isBlank((CharSequence)$receiver$iv$iv2))) {
            return new DialogReportQueryResult(0L, 0L, 0L, CollectionsKt.emptyList());
        }
        destination$iv$iv = applicationsIds;
        object = (KProperty)DialogCol_.Companion.getApplicationIds();
        int n = 0;
        bsonArray2 = bsonArray = new Bson[8];
        iterator = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            CharSequence charSequence = it;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv2;
        bsonArray[n] = FiltersKt.in((KProperty)object, (Iterable)list2);
        Bson[] bsonArray3 = bsonArray2;
        if (query.getPlayerId() == null) {
            bson3 = null;
        } else {
            KProperty kProperty = (KProperty)DialogCol_.Companion.getPlayerIds().getId();
            PlayerId playerId2 = query.getPlayerId();
            if (playerId2 == null) {
                Intrinsics.throwNpe();
            }
            bson3 = bsonArray2[1] = FiltersKt.eq((KProperty)kProperty, (Object)playerId2.getId());
        }
        if (query.getDialogId() == null) {
            bson2 = null;
        } else {
            KProperty kProperty = (KProperty)DialogCol_.Companion.get_id();
            String string = query.getDialogId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            bson2 = FiltersKt.eq((KProperty)kProperty, (Object)IdsKt.toId((String)string));
        }
        bsonArray3[2] = bson2;
        bsonArray3[3] = dialogIds2.isEmpty() ? null : FiltersKt.in((KProperty)((KProperty)DialogCol_.Companion.get_id()), (Iterable)dialogIds2);
        bsonArray3[4] = $receiver.getFrom() == null ? null : FiltersKt.gt((KProperty)((KProperty)UserTimelineCol_.Companion.getLastUpdateDate()), (Object)$receiver.getFrom());
        Bson bson4 = bsonArray3[5] = $receiver.getTo() == null ? null : FiltersKt.lt((KProperty)((KProperty)UserTimelineCol_.Companion.getLastUpdateDate()), (Object)$receiver.getTo());
        if ($receiver.getConnectorType() == null) {
            bson = null;
        } else {
            KProperty kProperty = (KProperty)DialogCol_.Companion.getStories().getActions().getState().getTargetConnectorType().getId();
            ConnectorType connectorType2 = $receiver.getConnectorType();
            if (connectorType2 == null) {
                Intrinsics.throwNpe();
            }
            bson = FiltersKt.eq((KProperty)kProperty, (Object)connectorType2.getId());
        }
        bsonArray3[6] = bson;
        $receiver$iv = query.getIntentName();
        n = 7;
        bsonArray = bsonArray3;
        bsonArray2 = bsonArray3;
        boolean bl4 = $receiver$iv == null || StringsKt.isBlank((CharSequence)$receiver$iv);
        bsonArray[n] = bl4 ? null : FiltersKt.eq((KProperty)((KProperty)DialogCol_.Companion.getStories().getCurrentIntent().getName_()), (Object)query.getIntentName());
        Bson filter = FiltersKt.and((Bson[])bsonArray2);
        logger.debug("dialog search query: " + filter);
        MongoCollection c = dialogCol.withReadPreference(ReadPreference.secondaryPreferred());
        long count = c.countDocuments(filter);
        if (count > $receiver.getStart()) {
            FindIterable findIterable = c.find(filter).skip((int)$receiver.getStart()).limit($receiver.getSize());
            Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"c.find(filter)\n         \u2026             .limit(size)");
            MongoIterable mongoIterable = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)UserTimelineCol_.Companion.getLastUpdateDate()}).map((Function)search.2.list.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"c.find(filter)\n         \u2026p { it.toDialogReport() }");
            List list3 = KMongoIterableKt.toList((MongoIterable)mongoIterable);
            dialogReportQueryResult = new DialogReportQueryResult(count, $receiver.getStart(), $receiver.getStart() + (long)$receiver.getSize(), list3);
        } else {
            dialogReportQueryResult = new DialogReportQueryResult(0L, 0L, 0L, CollectionsKt.emptyList());
        }
        return dialogReportQueryResult;
    }

    @Nullable
    public DialogReport getDialog(@NotNull Id<Dialog> id) {
        Intrinsics.checkParameterIsNotNull(id, (String)"id");
        DialogCol dialogCol = (DialogCol)MongoCollectionsKt.findOneById(UserTimelineMongoDAO.dialogCol, id);
        return dialogCol != null ? dialogCol.toDialogReport() : null;
    }

    @NotNull
    public List<Dialog> getClientDialogs(@NotNull String clientId, @NotNull Function1<? super String, ? extends StoryDefinition> storyDefinitionProvider) {
        List list2;
        Object ids;
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        Intrinsics.checkParameterIsNotNull(storyDefinitionProvider, (String)"storyDefinitionProvider");
        Object object = (ClientIdCol)MongoCollectionsKt.findOneById(clientIdCol, (Object)clientId);
        if (object == null || (object = ((ClientIdCol)object).getUserIds()) == null) {
            object = ids = SetsKt.emptySet();
        }
        if (ids.isEmpty()) {
            list2 = CollectionsKt.emptyList();
        } else {
            FindIterable findIterable = dialogCol.find(FiltersKt.in((KProperty)((KProperty)DialogCol_.Companion.getPlayerIds().getId()), (Iterable)((Iterable)ids)));
            Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"dialogCol\n              \u2026nd(PlayerIds.id `in` ids)");
            MongoIterable mongoIterable = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)UserTimelineCol_.Companion.getLastUpdateDate()}).map(new Function<TResult, U>(storyDefinitionProvider){
                final /* synthetic */ Function1 $storyDefinitionProvider;

                @NotNull
                public final Dialog apply(DialogCol it) {
                    return it.toDialog((Function1<? super String, ? extends StoryDefinition>)this.$storyDefinitionProvider);
                }
                {
                    this.$storyDefinitionProvider = function1;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"dialogCol\n              \u2026toryDefinitionProvider) }");
            list2 = KMongoIterableKt.toList((MongoIterable)mongoIterable);
        }
        return list2;
    }

    @NotNull
    public List<Dialog> getDialogsUpdatedFrom(@NotNull Instant from, @NotNull Function1<? super String, ? extends StoryDefinition> storyDefinitionProvider) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull(storyDefinitionProvider, (String)"storyDefinitionProvider");
        MongoIterable mongoIterable = dialogCol.find(FiltersKt.gt((KProperty)((KProperty)UserTimelineCol_.Companion.getLastUpdateDate()), (Object)from)).map(new Function<TResult, U>(storyDefinitionProvider){
            final /* synthetic */ Function1 $storyDefinitionProvider;

            @NotNull
            public final Dialog apply(DialogCol it) {
                return it.toDialog((Function1<? super String, ? extends StoryDefinition>)this.$storyDefinitionProvider);
            }
            {
                this.$storyDefinitionProvider = function1;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"dialogCol\n            .f\u2026toryDefinitionProvider) }");
        return KMongoIterableKt.toList((MongoIterable)mongoIterable);
    }

    /*
     * WARNING - void declaration
     */
    private final void addSnapshot(Dialog dialog) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intent intent2 = dialog.getState().getCurrentIntent();
        Iterable iterable = dialog.getState().getEntityValues().values();
        String string = intent2 != null ? intent2.getName() : null;
        void var4_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EntityValue entityValue;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            EntityStateValue it = (EntityStateValue)element$iv$iv;
            boolean bl = false;
            if (it.getValue() == null) continue;
            EntityValue it$iv$iv = entityValue;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        Instant instant = null;
        List list3 = list2;
        String string2 = string;
        Snapshot snapshot = new Snapshot(string2, list3, instant, n, defaultConstructorMarker);
        SnapshotCol existingSnapshot = (SnapshotCol)MongoCollectionsKt.findOneById(snapshotCol, (Object)dialog.getId());
        if (existingSnapshot == null) {
            snapshotCol.insertOne((Object)new SnapshotCol(dialog.getId(), CollectionsKt.listOf((Object)snapshot), null, 4, null));
        } else {
            List list4 = CollectionsKt.plus((Collection)existingSnapshot.getSnapshots(), (Object)snapshot);
            Instant instant2 = Instant.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"now()");
            MongoCollectionsKt.save(snapshotCol, (Object)SnapshotCol.copy$default(existingSnapshot, null, list4, instant2, 1, null));
        }
    }

    @NotNull
    public List<Snapshot> getSnapshots(@NotNull Id<Dialog> dialogId) {
        Intrinsics.checkParameterIsNotNull(dialogId, (String)"dialogId");
        Object object = (SnapshotCol)MongoCollectionsKt.findOneById(snapshotCol, dialogId);
        if (object == null || (object = ((SnapshotCol)object).getSnapshots()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public String getLastStoryId(@NotNull PlayerId playerId2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)playerId2, (String)"playerId");
        try {
            Object object = this.loadLastValidDialogCol(playerId2);
            string = object != null && (object = ((DialogCol)object).getStories()) != null && (object = (DialogCol.StoryMongoWrapper)CollectionsKt.lastOrNull((List)object)) != null ? ((DialogCol.StoryMongoWrapper)object).getStoryDefinitionId() : null;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            string = null;
        }
        return string;
    }

    private UserTimelineMongoDAO() {
    }

    public static final /* synthetic */ MongoCollection access$getClientIdCol$p(UserTimelineMongoDAO $this) {
        UserTimelineMongoDAO userTimelineMongoDAO = $this;
        return clientIdCol;
    }

    public static final /* synthetic */ void access$addSnapshot(UserTimelineMongoDAO $this, Dialog dialog) {
        $this.addSnapshot(dialog);
    }

    public static final /* synthetic */ void access$saveConnectorMessage(UserTimelineMongoDAO $this, Id actionId, Id dialogId, List messages2) {
        $this.saveConnectorMessage((Id<Action>)actionId, (Id<Dialog>)dialogId, messages2);
    }

    public static final /* synthetic */ void access$saveNlpStats(UserTimelineMongoDAO $this, Id actionId, Id dialogId, NlpCallStats nlpCallStats) {
        $this.saveNlpStats((Id<Action>)actionId, (Id<Dialog>)dialogId, nlpCallStats);
    }

    public static final /* synthetic */ String access$textKey(UserTimelineMongoDAO $this, String text) {
        return $this.textKey(text);
    }

    public static final /* synthetic */ MongoCollection access$getDialogTextCol$p(UserTimelineMongoDAO $this) {
        UserTimelineMongoDAO userTimelineMongoDAO = $this;
        return dialogTextCol;
    }
}

