/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import guru.nidi.graphviz.attribute.validate.ValidatorMessage;
import java.util.regex.Pattern;

abstract class Datatype {
    final String name;

    Datatype(String name) {
        this.name = name;
    }

    abstract ValidatorMessage validate(Object var1);

    static Pattern pattern(String p) {
        return Pattern.compile(p.replace("%s", "(e,%f,%f)?(s,%f,%f)?%p(%p %p %p)+").replace("%p", "(%f,%f(,%f)?!?)").replace("%c", "(n|ne|e|se|s|sw|w|nw|c|_)").replace("%x", "([0-9A-Fa-f])").replace("%n", "(1\\.0|1|0|0?\\.[0-9]+)").replace("%d", "([+-]?[0-9]{1,9})").replace("%f", "([+-]?(\\d+([.]\\d*)?(e[+-]?\\d+)?|[.]\\d+(e[+-]?\\d+)?))"));
    }

    static boolean matches(Object value, String pattern) {
        return Datatype.pattern(pattern).matcher(value.toString()).matches();
    }

    static Double doubleValue(Object value) {
        return value instanceof Double ? (Double)value : Datatype.tryParseDouble(value.toString());
    }

    static Integer intValue(Object value) {
        return value instanceof Integer ? (Integer)value : Datatype.tryParseInt(value.toString());
    }

    static Boolean boolValue(Object value) {
        return value instanceof Boolean ? (Boolean)value : Datatype.boolValue(value.toString(), Datatype.tryParseInt(value.toString()));
    }

    static Boolean boolValue(String val, Integer i) {
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || i != null && i != 0) {
            return true;
        }
        if (val.equalsIgnoreCase("false") || val.equalsIgnoreCase("no") || i != null && i == 0) {
            return false;
        }
        return null;
    }

    static Double tryParseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    static Integer tryParseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

