/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdepend.framework.DependencyDefiner;
import jdepend.framework.JavaPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyConstraint {
    private final String basePackage;
    private final Map<String, JavaPackage> packages;

    public DependencyConstraint(String basePackage) {
        this.basePackage = DependencyConstraint.normalize(basePackage);
        this.packages = new HashMap<String, JavaPackage>();
    }

    public DependencyConstraint() {
        this("");
    }

    private static String normalize(String basePackage) {
        return basePackage.length() == 0 || basePackage.endsWith(".") ? basePackage : basePackage + ".";
    }

    public static DependencyConstraint fromFields(String basePackage, Object ... objs) {
        try {
            DependencyConstraint constraint = new DependencyConstraint();
            basePackage = DependencyConstraint.normalize(basePackage);
            for (Object obj : objs) {
                for (Field f : obj.getClass().getDeclaredFields()) {
                    f.setAccessible(true);
                    if (f.getType() != JavaPackage.class) continue;
                    String start = basePackage + DependencyConstraint.camelCaseToDotCase(obj.getClass().getSimpleName());
                    f.set(obj, constraint.addPackage(start + (f.getName().equals("self") ? "" : "." + DependencyConstraint.camelCaseToDotCase(f.getName()))));
                }
                if (!(obj instanceof DependencyDefiner)) continue;
                ((DependencyDefiner)obj).dependUpon();
            }
            return constraint;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access field", e);
        }
    }

    public static DependencyConstraint fromFields(Object ... objs) {
        return DependencyConstraint.fromFields("", objs);
    }

    private static String camelCaseToDotCase(String s) {
        StringBuilder res = new StringBuilder();
        boolean dollarMode = s.contains("$");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (dollarMode) {
                if (c == '$' && i > 0) {
                    res.append(".");
                    continue;
                }
                res.append(c);
                continue;
            }
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    res.append(".");
                }
                res.append(Character.toLowerCase(c));
                continue;
            }
            res.append(c);
        }
        return res.toString();
    }

    public JavaPackage addPackage(String packageName) {
        String pack = this.basePackage + packageName;
        JavaPackage jPackage = this.packages.get(pack);
        if (jPackage == null) {
            jPackage = new JavaPackage(pack);
            this.addPackage(jPackage);
        }
        return jPackage;
    }

    public void addPackage(JavaPackage jPackage) {
        if (!this.packages.containsValue(jPackage)) {
            this.packages.put(jPackage.getName(), jPackage);
        }
    }

    public Collection getPackages() {
        return this.packages.values();
    }

    public MatchResult match(Collection<JavaPackage> expectedPackages) {
        MatchResult res = new MatchResult();
        for (JavaPackage next : expectedPackages) {
            JavaPackage actualPackage = this.packages.get(next.getName());
            if (actualPackage == null) {
                res.getUndefinedPackages().add(next);
                continue;
            }
            if (this.equalsDependencies(next, actualPackage)) continue;
            res.getNonMatchingPackages().add(new JavaPackage[]{actualPackage, next});
        }
        return res;
    }

    private boolean equalsDependencies(JavaPackage a, JavaPackage b) {
        return this.equalsAfferents(a, b) && this.equalsEfferents(a, b);
    }

    private boolean equalsAfferents(JavaPackage a, JavaPackage b) {
        if (a.equals(b)) {
            Collection<JavaPackage> otherAfferents = b.getAfferents();
            if (a.getAfferents().size() == otherAfferents.size()) {
                for (JavaPackage afferent : a.getAfferents()) {
                    if (otherAfferents.contains(afferent)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean equalsEfferents(JavaPackage a, JavaPackage b) {
        if (a.equals(b)) {
            Collection<JavaPackage> otherEfferents = b.getEfferents();
            if (a.getEfferents().size() == otherEfferents.size()) {
                for (JavaPackage efferent : a.getEfferents()) {
                    if (otherEfferents.contains(efferent)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MatchResult {
        private List<JavaPackage> undefinedPackages = new ArrayList<JavaPackage>();
        private List<JavaPackage[]> notMatchingPackages = new ArrayList<JavaPackage[]>();

        public boolean matches() {
            return this.undefinedPackages.isEmpty() && this.notMatchingPackages.isEmpty();
        }

        public List<JavaPackage> getUndefinedPackages() {
            return this.undefinedPackages;
        }

        public List<JavaPackage[]> getNonMatchingPackages() {
            return this.notMatchingPackages;
        }
    }
}

