/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import jdepend.framework.DependencyConstraint;
import jdepend.framework.JDepend;
import jdepend.framework.JavaPackage;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyMatchers {
    private static final Comparator<JavaPackage> PACKAGE_COMPARATOR = new Comparator<JavaPackage>(){

        @Override
        public int compare(JavaPackage p1, JavaPackage p2) {
            return p2.getName().compareTo(p1.getName());
        }
    };

    private DependencyMatchers() {
    }

    public static Matcher<JDepend> matchesPackages(Object ... objs) {
        return DependencyMatchers.matches(DependencyConstraint.fromFields(objs));
    }

    public static Matcher<JDepend> matchesPackages(String basePackage, Object ... objs) {
        return DependencyMatchers.matches(DependencyConstraint.fromFields(basePackage, objs));
    }

    public static Matcher<JDepend> matches(final DependencyConstraint constraint) {
        return new TypeSafeMatcher<JDepend>(){
            private DependencyConstraint.MatchResult result;

            protected boolean matchesSafely(JDepend item) {
                this.result = constraint.match(item.getPackages());
                return this.result.matches();
            }

            public void describeTo(Description description) {
                description.appendText("No dependency problems");
            }

            protected void describeMismatchSafely(JDepend item, Description description) {
                if (!this.result.getUndefinedPackages().isEmpty()) {
                    description.appendText("Found undefined packages: ");
                    description.appendText(this.toString(this.result.getUndefinedPackages()) + "\n");
                }
                if (!this.result.getNonMatchingPackages().isEmpty()) {
                    description.appendText("Non matching packages:");
                    for (JavaPackage[] packs : this.result.getNonMatchingPackages()) {
                        description.appendText("\n" + packs[0].getName() + "\n");
                        List exAff = (List)packs[0].getAfferents();
                        List effAff = (List)packs[1].getAfferents();
                        List exEff = (List)packs[0].getEfferents();
                        List effEff = (List)packs[1].getEfferents();
                        if (!exAff.equals(effAff)) {
                            description.appendText("Expected afferents: " + this.toString(exAff) + "\n");
                            description.appendText("Found    afferents: " + this.toString(effAff) + "\n");
                        }
                        if (exEff.equals(effEff)) continue;
                        description.appendText("Expected efferents: " + this.toString(exEff) + "\n");
                        description.appendText("Found    efferents: " + this.toString(effEff) + "\n");
                    }
                }
            }

            private String toString(List<JavaPackage> packs) {
                String s = "";
                for (JavaPackage pack : this.sorted(packs)) {
                    s = s + ", " + pack;
                }
                return s.length() > 0 ? s.substring(2) : s;
            }

            private boolean equals(List<JavaPackage> p1, List<JavaPackage> p2) {
                return this.sorted(p1).equals(this.sorted(p2));
            }

            private List<JavaPackage> sorted(List<JavaPackage> packs) {
                ArrayList<JavaPackage> sorted = new ArrayList<JavaPackage>(packs);
                Collections.sort(sorted, PACKAGE_COMPARATOR);
                return sorted;
            }
        };
    }

    public static Matcher<JDepend> hasNoCycles() {
        return new TypeSafeMatcher<JDepend>(){

            protected boolean matchesSafely(JDepend item) {
                return !item.containsCycles();
            }

            public void describeTo(Description description) {
                description.appendText("No cycles");
            }

            protected void describeMismatchSafely(JDepend item, Description description) {
                description.appendText("is cyclic");
            }
        };
    }

    public static Matcher<JDepend> hasMaxDistance(final String packageFilter, final double maxDistance) {
        return new TypeSafeMatcher<JDepend>(){
            private JavaPackage problem;

            protected boolean matchesSafely(JDepend item) {
                for (JavaPackage pack : item.getPackages()) {
                    if (!pack.getName().startsWith(packageFilter) || !((double)pack.distance() > maxDistance)) continue;
                    this.problem = pack;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("Distance <= " + maxDistance);
            }

            protected void describeMismatchSafely(JDepend item, Description description) {
                description.appendText(this.problem.getName() + " has distance of " + this.problem.distance());
            }
        };
    }

    public static String distances(JDepend depend, String packageFilter) {
        StringBuilder s = new StringBuilder().append("Name                                      abst  inst  dist\n").append("----------------------------------------------------------\n");
        Formatter formatter = new Formatter(s);
        for (JavaPackage pack : depend.getPackages()) {
            if (!pack.getName().startsWith(packageFilter)) continue;
            formatter.format("%-40s: %-1.2f  %-1.2f  %-1.2f%n", pack.getName(), Float.valueOf(pack.abstractness()), Float.valueOf(pack.instability()), Float.valueOf(pack.distance()));
        }
        return s.toString();
    }
}

